/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployablemonitor.mbean;

import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.ow2.jonas.deployablemonitor.DeployableMonitor;
import org.ow2.jonas.deployablemonitor.DeployableMonitorService;
import org.ow2.jonas.lib.jmbeans.JNotification;
import org.ow2.jonas.lib.management.javaee.J2EEManagedObjectMBean;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployableMonitorMBean
extends J2EEManagedObjectMBean<DeployableMonitorService>
implements NotificationListener {
    private Log logger = LogFactory.getLog(DeployableMonitor.class);
    private MBeanServer mbeanServer = null;
    private boolean readyToRunning = false;

    public String getName() {
        return "emptyname";
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mbeanServer = server;
        if (name != null) {
            this.oname = name;
        }
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            return;
        }
        try {
            ObjectName on = this.getServer();
            this.mbeanServer.addNotificationListener(on, this.oname, null, null);
        }
        catch (JMException me) {
            me.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof JNotification) {
            this.logger.debug((Object)("Received JNotification" + notification), new Object[0]);
            if (notification.getType().equals("j2ee.state.running")) {
                this.logger.debug((Object)"j2ee.state.running", new Object[0]);
                ((DeployableMonitorService)((Object)this.getManagedComponent())).startMonitor();
            }
        }
    }

    public ObjectName getServer() {
        ObjectName serverName = null;
        try {
            ObjectName on = new ObjectName(this.getObjectName());
            serverName = J2eeObjectName.J2EEServer((String)on.getDomain(), (String)on.getKeyProperty("J2EEServer"));
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Cannot build Server object name", e);
        }
        return serverName;
    }

    public boolean isReadyToRunning() {
        return this.readyToRunning;
    }

    public void setReadyToRunning(boolean readyToRunning) {
        this.readyToRunning = readyToRunning;
        this.logger.debug((Object)("readyToRunning passed to " + readyToRunning), new Object[0]);
    }
}

