/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index;

import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.core.index.DiskIndex;
import org.eclipse.jdt.internal.core.index.EntryResult;
import org.eclipse.jdt.internal.core.index.MemoryIndex;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.util.SimpleSet;

public class Index {
    public String containerPath;
    public ReadWriteMonitor monitor;
    protected DiskIndex diskIndex;
    protected MemoryIndex memoryIndex;
    static final int MATCH_RULE_INDEX_MASK = 15;

    public static boolean isMatch(char[] pattern, char[] word, int matchRule) {
        if (pattern == null) {
            return true;
        }
        switch (matchRule & 0xF) {
            case 0: {
                return CharOperation.equals(pattern, word, false);
            }
            case 1: {
                return CharOperation.prefixEquals(pattern, word, false);
            }
            case 2: {
                return CharOperation.match(pattern, word, false);
            }
            case 8: {
                return pattern[0] == word[0] && CharOperation.equals(pattern, word);
            }
            case 9: {
                return pattern[0] == word[0] && CharOperation.prefixEquals(pattern, word);
            }
            case 10: {
                return CharOperation.match(pattern, word, true);
            }
        }
        return false;
    }

    public Index(String fileName, String containerPath, boolean reuseExistingFile) throws IOException {
        this.containerPath = containerPath;
        this.monitor = new ReadWriteMonitor();
        this.memoryIndex = new MemoryIndex();
        this.diskIndex = new DiskIndex(fileName);
        this.diskIndex.initialize(reuseExistingFile);
    }

    public void addIndexEntry(char[] category, char[] key, String containerRelativePath) {
        this.memoryIndex.addIndexEntry(category, key, containerRelativePath);
    }

    public String containerRelativePath(String documentPath) {
        int index = documentPath.indexOf("|");
        if (index == -1) {
            index = this.containerPath.length();
            if (documentPath.length() <= index) {
                throw new IllegalArgumentException("Document path " + documentPath + " must be relative to " + this.containerPath);
            }
        }
        return documentPath.substring(index + 1);
    }

    public File getIndexFile() {
        if (this.diskIndex == null) {
            return null;
        }
        return this.diskIndex.getIndexFile();
    }

    public boolean hasChanged() {
        return this.memoryIndex.hasChanged();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EntryResult[] query(char[][] categories, char[] key, int matchRule) throws IOException {
        HashtableOfObject results;
        if (this.memoryIndex.shouldMerge() && this.monitor.exitReadEnterWrite()) {
            try {
                this.save();
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.monitor.exitWriteEnterRead();
                throw throwable;
            }
            {
                Object var4_7 = null;
                this.monitor.exitWriteEnterRead();
            }
        }
        int rule = matchRule & 0xF;
        if (this.memoryIndex.hasChanged()) {
            results = this.diskIndex.addQueryResults(categories, key, rule, this.memoryIndex);
            results = this.memoryIndex.addQueryResults(categories, key, rule, results);
        } else {
            results = this.diskIndex.addQueryResults(categories, key, rule, null);
        }
        if (results == null) {
            return null;
        }
        EntryResult[] entryResults = new EntryResult[results.elementSize];
        int count = 0;
        Object[] values = results.valueTable;
        int i = 0;
        int l = values.length;
        while (i < l) {
            EntryResult result = (EntryResult)values[i];
            if (result != null) {
                entryResults[count++] = result;
            }
            ++i;
        }
        return entryResults;
    }

    public String[] queryDocumentNames(String substring) throws IOException {
        SimpleSet results;
        if (this.memoryIndex.hasChanged()) {
            results = this.diskIndex.addDocumentNames(substring, this.memoryIndex);
            this.memoryIndex.addDocumentNames(substring, results);
        } else {
            results = this.diskIndex.addDocumentNames(substring, null);
        }
        if (results.elementSize == 0) {
            return null;
        }
        String[] documentNames = new String[results.elementSize];
        int count = 0;
        Object[] paths = results.values;
        int i = 0;
        int l = paths.length;
        while (i < l) {
            if (paths[i] != null) {
                documentNames[count++] = (String)paths[i];
            }
            ++i;
        }
        return documentNames;
    }

    public void remove(String containerRelativePath) {
        this.memoryIndex.remove(containerRelativePath);
    }

    public void save() throws IOException {
        if (!this.hasChanged()) {
            return;
        }
        int numberOfChanges = this.memoryIndex.docsToReferences.elementSize;
        this.diskIndex = this.diskIndex.mergeWith(this.memoryIndex);
        this.memoryIndex = new MemoryIndex();
        if (numberOfChanges > 1000) {
            System.gc();
        }
    }

    public void startQuery() {
        if (this.diskIndex != null) {
            this.diskIndex.startQuery();
        }
    }

    public void stopQuery() {
        if (this.diskIndex != null) {
            this.diskIndex.stopQuery();
        }
    }

    public String toString() {
        return "Index for " + this.containerPath;
    }
}

