/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.helper;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.archive.IArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebArchiveClassLoaderURLsHelper {
    private WebArchiveClassLoaderURLsHelper() {
    }

    public static List<URL> getURLs(IArchive webArchive) throws ArchiveException {
        Iterator itResources;
        try {
            itResources = webArchive.getResources();
        }
        catch (ArchiveException e) {
            throw new ArchiveException("Cannot get resources on the given archive '" + webArchive + "'.", (Throwable)e);
        }
        ArrayList<URL> classLoaderURLs = new ArrayList<URL>();
        URL warURL = webArchive.getURL();
        URL webInfClassesURL = webArchive.getResource("WEB-INF/classes");
        boolean webinfClassesFound = false;
        if (webInfClassesURL != null) {
            classLoaderURLs.add(webInfClassesURL);
            webinfClassesFound = true;
        }
        while (itResources.hasNext()) {
            String relativePath;
            URL currentURL = (URL)itResources.next();
            int filePos = currentURL.toExternalForm().indexOf(warURL.toExternalForm());
            if (filePos >= 0) {
                filePos += warURL.toExternalForm().length();
            }
            if ((relativePath = currentURL.toExternalForm().substring(filePos)).startsWith("!/")) {
                relativePath = relativePath.substring(2);
            } else if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            if (!webinfClassesFound && relativePath.startsWith("WEB-INF/classes/")) {
                int index = currentURL.toExternalForm().indexOf(relativePath);
                URL webinfClassesURL = null;
                try {
                    webinfClassesURL = new URL(currentURL.toExternalForm().substring(0, index) + "WEB-INF/classes/");
                }
                catch (MalformedURLException e) {
                    throw new ArchiveException("Unable to build URL for WEB-INF/classes on the given archive '" + webArchive + "'.", (Throwable)e);
                }
                classLoaderURLs.add(webinfClassesURL);
                webinfClassesFound = true;
            }
            if (!relativePath.startsWith("WEB-INF/lib/") || !relativePath.endsWith(".jar")) continue;
            classLoaderURLs.add(currentURL);
        }
        return classLoaderURLs;
    }
}

