/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import org.apache.felix.framework.FelixBundle;
import org.apache.felix.framework.ServiceRegistrationImpl;
import org.apache.felix.framework.util.Util;
import org.apache.felix.moduleloader.IWire;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

class ServiceReferenceImpl
implements ServiceReference {
    private ServiceRegistrationImpl m_registration = null;
    private Bundle m_bundle = null;

    public ServiceReferenceImpl(ServiceRegistrationImpl reg, Bundle bundle) {
        this.m_registration = reg;
        this.m_bundle = bundle;
    }

    protected ServiceRegistrationImpl getServiceRegistration() {
        return this.m_registration;
    }

    public Object getProperty(String s) {
        return this.m_registration.getProperty(s);
    }

    public String[] getPropertyKeys() {
        return this.m_registration.getPropertyKeys();
    }

    public Bundle getBundle() {
        return this.m_registration.isValid() ? this.m_bundle : null;
    }

    public Bundle[] getUsingBundles() {
        return this.m_registration.getUsingBundles();
    }

    public boolean equals(Object obj) {
        try {
            ServiceReferenceImpl ref = (ServiceReferenceImpl)obj;
            return ref.m_registration == this.m_registration;
        }
        catch (ClassCastException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public int hashCode() {
        if (this.m_registration.getReference() != null) {
            if (this.m_registration.getReference() != this) {
                return this.m_registration.getReference().hashCode();
            }
            return super.hashCode();
        }
        return 0;
    }

    public String toString() {
        String[] ocs = (String[])this.getProperty("objectClass");
        String oc = "[";
        for (int i = 0; i < ocs.length; ++i) {
            oc = oc + ocs[i];
            if (i >= ocs.length - 1) continue;
            oc = oc + ", ";
        }
        oc = oc + "]";
        return oc;
    }

    public boolean isAssignableTo(Bundle requester, String className) {
        if (requester == this.m_bundle) {
            return true;
        }
        boolean allow = true;
        String pkgName = Util.getClassPackage(className);
        IWire requesterWire = Util.getWire(((FelixBundle)requester).getInfo().getCurrentModule(), pkgName);
        IWire providerWire = Util.getWire(((FelixBundle)this.m_bundle).getInfo().getCurrentModule(), pkgName);
        if (requesterWire != null) {
            if (providerWire == null) {
                if (!((FelixBundle)this.m_bundle).getInfo().hasModule(requesterWire.getExporter())) {
                    try {
                        Class requestClass = ((FelixBundle)requester).getInfo().getCurrentModule().getClass(className);
                        allow = this.getServiceRegistration().isClassAccessible(requestClass);
                    }
                    catch (Exception ex) {
                        allow = false;
                    }
                } else {
                    allow = ((FelixBundle)this.m_bundle).getInfo().getCurrentModule() == requesterWire.getExporter();
                }
            } else {
                allow = providerWire.getExporter().equals(requesterWire.getExporter());
            }
        }
        return allow;
    }
}

