/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.searchpolicy;

import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import org.apache.felix.framework.searchpolicy.R4SearchPolicyCore;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.Capability;
import org.apache.felix.moduleloader.ICapability;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.IRequirement;
import org.apache.felix.moduleloader.IWire;
import org.apache.felix.moduleloader.ResourceNotFoundException;

public class R4WireModule
implements IWire {
    private IModule m_importer = null;
    private IRequirement m_requirement = null;
    private IModule m_exporter = null;
    private ICapability m_capability = null;
    private Map m_pkgMap = null;

    public R4WireModule(IModule importer, IRequirement requirement, IModule exporter, ICapability capability, Map pkgMap) {
        this.m_importer = importer;
        this.m_requirement = requirement;
        this.m_exporter = exporter;
        this.m_capability = capability;
        this.m_pkgMap = pkgMap;
    }

    public IModule getImporter() {
        return this.m_importer;
    }

    public IRequirement getRequirement() {
        return this.m_requirement;
    }

    public IModule getExporter() {
        return this.m_exporter;
    }

    public ICapability getCapability() {
        return this.m_capability;
    }

    public Class getClass(String name) throws ClassNotFoundException {
        String pkgName = Util.getClassPackage(name);
        R4SearchPolicyCore.ResolvedPackage rp = (R4SearchPolicyCore.ResolvedPackage)this.m_pkgMap.get(pkgName);
        if (rp != null) {
            for (int srcIdx = 0; srcIdx < rp.m_sourceList.size(); ++srcIdx) {
                Class clazz;
                R4SearchPolicyCore.PackageSource ps = (R4SearchPolicyCore.PackageSource)rp.m_sourceList.get(srcIdx);
                if (ps.m_module != this.m_importer && (!(ps.m_capability instanceof Capability) || !((Capability)ps.m_capability).isIncluded(name)) || (clazz = ps.m_module.getContentLoader().getClass(name)) == null) continue;
                return clazz;
            }
        }
        return null;
    }

    public URL getResource(String name) throws ResourceNotFoundException {
        String pkgName = Util.getResourcePackage(name);
        R4SearchPolicyCore.ResolvedPackage rp = (R4SearchPolicyCore.ResolvedPackage)this.m_pkgMap.get(pkgName);
        if (rp != null) {
            for (int srcIdx = 0; srcIdx < rp.m_sourceList.size(); ++srcIdx) {
                R4SearchPolicyCore.PackageSource ps = (R4SearchPolicyCore.PackageSource)rp.m_sourceList.get(srcIdx);
                URL url = ps.m_module.getContentLoader().getResource(name);
                if (url == null) continue;
                return url;
            }
        }
        return null;
    }

    public Enumeration getResources(String name) throws ResourceNotFoundException {
        return null;
    }

    public String toString() {
        return this.m_importer + " -> " + this.m_capability + " -> " + this.m_exporter;
    }
}

