/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.launcher.felix;

import java.io.File;
import java.rmi.RMISecurityManager;
import java.util.Map;
import org.apache.felix.framework.Felix;
import org.osgi.framework.BundleException;
import org.ow2.jonas.launcher.felix.DefaultConfigurationProvider;
import org.ow2.jonas.launcher.felix.IConfigurationProvider;
import org.ow2.jonas.launcher.felix.util.IOUtils;
import org.ow2.jonas.launcher.felix.util.JOnASUtils;

public class JOnAS {
    private Felix felix;
    private static final String SECURITY_MANAGER = "jonas.security.manager";

    public JOnAS(boolean forceCleanUp) throws Exception {
        System.out.println("\nWelcome to OW2 JOnAS (Running on Felix).");
        System.out.println("   Type 'help' for available commands.");
        System.out.println("-----------------------------------------------\n");
        IConfigurationProvider provider = this.getConfigurationProvider();
        Map config = provider.getConfiguration();
        if (forceCleanUp) {
            IOUtils.deleteDir(new File((String)config.get("felix.cache.profiledir")));
        }
        this.felix = new Felix(config, null);
    }

    protected IConfigurationProvider getConfigurationProvider() {
        return new DefaultConfigurationProvider();
    }

    public void start() throws BundleException {
        this.felix.start();
    }

    public void stop() throws BundleException {
        if (this.felix.getState() == 32) {
            this.felix.stop();
        }
    }

    public static void main(String[] args) throws Exception {
        boolean useSecurityManager = new Boolean(JOnASUtils.getServerProperty(SECURITY_MANAGER, "true").trim());
        if (useSecurityManager && System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        JOnAS.initializeSystemProperties();
        final JOnAS jonas = new JOnAS(Boolean.getBoolean("jonas.cache.clean"));
        jonas.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    jonas.stop();
                }
                catch (BundleException e) {
                    e.printStackTrace(System.err);
                }
            }
        });
    }

    protected static void initializeSystemProperties() {
        System.setProperty("javax.security.jacc.PolicyConfigurationFactory.provider", "org.ow2.jonas.lib.security.jacc.JPolicyConfigurationFactory");
        System.setProperty("monolog.wrappers", "mx4j.log.CommonsLogger,mx4j.log.Logger,java.util.logging.Logger,org.ow2.util.log.JDKLogger, org.apache.juli.logging.DirectJDKLog,org.ow2.carol.util.configuration.TraceCarol");
        System.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
        System.setProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
        System.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.standard_init", "org.jacorb.orb.standardInterceptors.IORInterceptorInitializer");
        System.setProperty("javax.rmi.CORBA.PortableRemoteObjectClass", "org.ow2.carol.rmi.multi.MultiPRODelegate");
        System.setProperty("javax.rmi.CORBA.UtilClass", "org.ow2.carol.util.delegate.UtilDelegateImpl");
        System.setProperty("java.naming.factory.initial", "org.ow2.carol.jndi.spi.MultiOrbInitialContextFactory");
        System.setProperty("install.root", "NOT_USED");
        JOnAS.setDefaultPropertyIfNotSet("java.security.policy", IOUtils.getSystemPath(JOnASUtils.getJOnASBase(), "conf/java.policy"));
        JOnAS.setDefaultPropertyIfNotSet("java.security.auth.login.config", IOUtils.getSystemPath(JOnASUtils.getJOnASBase(), "conf/jaas.config"));
    }

    protected static void setDefaultPropertyIfNotSet(String key, String def) {
        System.setProperty(key, System.getProperty(key, def));
    }
}

