/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.bootstrap;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import org.ow2.jonas.empty.Empty;
import org.ow2.jonas.lib.bootstrap.JClassLoader;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.bootstrap.JURLs;
import org.ow2.jonas.lib.bootstrap.LoaderManager;

public class OSGiLoaderManager
extends LoaderManager {
    private static final String APPS = "loader.apps";
    private static final String COMMONS = "loader.commons";
    private Map<String, JClassLoader> loaders = null;
    private static File jonasLib = null;
    private static String jonasRoot = null;
    private static String jonasBase = null;
    private File jonasAppsDir;
    private File jonasCommonsDir;

    public OSGiLoaderManager() {
        jonasRoot = System.getProperty("install.root");
        if (jonasRoot == null) {
            System.err.println("JONAS_ROOT is not set");
            System.exit(2);
        }
        jonasLib = new File(jonasRoot, "lib");
        this.jonasAppsDir = new File(jonasLib, "apps");
        this.jonasCommonsDir = new File(jonasLib, "commons");
        this.loaders = new Hashtable<String, JClassLoader>();
    }

    public void init(JProp props) {
        jonasBase = JProp.getJonasBase();
    }

    public JClassLoader getCommonsLoader() throws Exception {
        JClassLoader commons = this.getLoader(COMMONS);
        if (commons == null) {
            commons = this.createCommonsClassLoader();
            this.setLoader(COMMONS, commons);
        }
        return commons;
    }

    public JClassLoader getAppsLoader() throws Exception {
        JClassLoader apps = this.getLoader(APPS);
        if (apps == null) {
            apps = this.createAppsClassLoader();
            this.setLoader(APPS, apps);
        }
        return apps;
    }

    public JClassLoader getCatalinaLoader() throws Exception {
        return this.getAppsLoader();
    }

    private JClassLoader getLoader(String name) {
        return this.loaders.get(name);
    }

    private void setLoader(String name, JClassLoader loader) {
        this.loaders.put(name, loader);
    }

    private JClassLoader createAppsClassLoader() throws Exception {
        JURLs jurls = new JURLs();
        jurls.add(this.jonasAppsDir, ".jar");
        File jonasBaseLibApps = new File(jonasBase, "lib" + File.separator + "apps");
        if (jonasBaseLibApps.exists()) {
            jurls.add(jonasBaseLibApps, ".jar");
        }
        return new JClassLoader("Apps", jurls.toURLs(), this.getCommonsLoader());
    }

    private JClassLoader createCommonsClassLoader() throws Exception {
        File jonasBaseLibExt;
        JURLs jurls = new JURLs();
        jurls.add(this.jonasCommonsDir, ".jar");
        File jonasBaseLibCommons = new File(jonasBase, "lib" + File.separator + "commons");
        if (jonasBaseLibCommons.exists()) {
            jurls.add(jonasBaseLibCommons, ".jar");
        }
        if (!System.getProperty("install.root").toLowerCase().equals(jonasBase.toLowerCase()) && (jonasBaseLibExt = new File(jonasBase + File.separator + "lib" + File.separator + "ext")).exists()) {
            jurls.add(jonasBaseLibExt, ".jar");
        }
        jurls.add(new File(jonasLib, "ext"), ".jar");
        return new JClassLoader("Commons", jurls.toURLs(), Empty.class.getClassLoader());
    }
}

