/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.bootstrap;

import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.ow2.jonas.lib.bootstrap.JClassLoader;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.bootstrap.JURLs;
import org.ow2.jonas.lib.bootstrap.LoaderManager;

public class TraditionalLoaderManager
extends LoaderManager {
    private static final String COMMONS = "loader.commons";
    private static final String APPS = "loader.apps";
    private static final String CATALINA = "loader.catalina";
    private static final String CATALINA_BOOTSTRAP_JAR = "bin" + File.separator + "bootstrap.jar";
    private Map<String, JClassLoader> loaders = null;
    private static File jonasLib = null;
    private static File catalinaLib = null;
    private static File tomcat6Lib = null;
    private static File jetty6Lib = null;
    private static String jonasRoot = null;
    private static String jonasBase = null;
    private static String catalinaHome = null;
    private boolean hasWeb = false;
    private boolean useDefaultClassPath = false;
    private boolean isCatalina = false;
    private boolean isTomcat6 = false;
    private File jonasCommonsDir;
    private File jonasToolsDir;
    private File jonasAppsDir;

    public TraditionalLoaderManager() {
        jonasRoot = System.getProperty("install.root");
        if (jonasRoot == null) {
            System.err.println("JONAS_ROOT is not set");
            System.exit(2);
        }
        jonasLib = new File(jonasRoot, "lib");
        this.jonasCommonsDir = new File(jonasLib, "commons");
        this.jonasToolsDir = new File(jonasLib, "tools");
        this.jonasAppsDir = new File(jonasLib, "apps");
        catalinaLib = new File(jonasLib, "catalina");
        jetty6Lib = new File(jonasLib, "jetty6");
        tomcat6Lib = new File(jonasLib, "tomcat6");
        this.loaders = new Hashtable<String, JClassLoader>();
    }

    public void init(JProp props) {
        jonasBase = JProp.getJonasBase();
        this.useDefaultClassPath = props.getValueAsBoolean("jonas.default.classloader", false);
        String[] services = props.getValueAsArray("jonas.services");
        if (services != null) {
            for (int i = 0; i < services.length; ++i) {
                if (!services[i].equals("web")) continue;
                this.hasWeb = true;
                String classname = props.getValue("jonas.service.web.class");
                if (classname.matches(".*Catalina.*") || classname.matches(".*Tomcat6.*")) {
                    this.isCatalina = true;
                }
                if (!classname.matches(".*Tomcat6.*")) break;
                this.isTomcat6 = true;
                break;
            }
        }
        catalinaHome = System.getProperty("catalina.home");
        if (this.hasEmbeddedCatalina5() && !this.isTomcat6) {
            System.setProperty("catalina.home", catalinaLib.getPath());
            System.setProperty("catalina.base", jonasBase);
            catalinaHome = catalinaLib.getPath();
        }
        if (this.isTomcat6) {
            System.setProperty("catalina.home", jonasRoot);
            System.setProperty("catalina.base", jonasBase);
            catalinaHome = jonasRoot;
        }
    }

    private boolean hasEmbeddedCatalina5() {
        return new File(catalinaLib, CATALINA_BOOTSTRAP_JAR).exists();
    }

    public JClassLoader getCommonsLoader() throws Exception {
        JClassLoader commons = this.getLoader(COMMONS);
        if (commons == null) {
            commons = this.createCommonsClassLoader();
            this.setLoader(COMMONS, commons);
        }
        return commons;
    }

    public JClassLoader getAppsLoader() throws Exception {
        JClassLoader apps = this.getLoader(APPS);
        if (apps == null) {
            apps = this.createAppsClassLoader();
            this.setLoader(APPS, apps);
        }
        return apps;
    }

    public JClassLoader getCatalinaLoader() throws Exception {
        JClassLoader catalina = this.getLoader(CATALINA);
        if (catalina == null) {
            catalina = this.createCatalinaClassLoader();
            this.setLoader(CATALINA, catalina);
        }
        return catalina;
    }

    private static JURLs getClassPath(boolean xtracp) throws Exception {
        String cpprop = "java.class.path";
        if (xtracp) {
            cpprop = "jonas.classpath";
        }
        String cpValue = System.getProperty(cpprop);
        String sep = File.pathSeparator;
        JURLs jurls = new JURLs();
        StringTokenizer tokenizer = new StringTokenizer(cpValue, sep);
        while (tokenizer.hasMoreTokens()) {
            File file = new File(tokenizer.nextToken());
            if (file.isDirectory()) {
                jurls.addDir(file);
                continue;
            }
            if (file.getName().equals("ow_jonas_bootstrap.jar")) continue;
            jurls.add(file);
        }
        return jurls;
    }

    private JClassLoader getLoader(String name) {
        return this.loaders.get(name);
    }

    private void setLoader(String name, JClassLoader loader) {
        this.loaders.put(name, loader);
    }

    private JClassLoader createCommonsClassLoader() throws Exception {
        File jonasBaseLibExt;
        JURLs jurls = new JURLs();
        jurls.merge(TraditionalLoaderManager.getClassPath(this.useDefaultClassPath));
        jurls.add(this.jonasCommonsDir, ".jar");
        File jonasBaseLibCommons = new File(jonasBase, "lib" + File.separator + "commons");
        if (jonasBaseLibCommons.exists()) {
            jurls.add(jonasBaseLibCommons, ".jar");
        }
        if (!System.getProperty("install.root").toLowerCase().equals(jonasBase.toLowerCase()) && (jonasBaseLibExt = new File(jonasBase + File.separator + "lib" + File.separator + "ext")).exists()) {
            jurls.add(jonasBaseLibExt, ".jar");
        }
        jurls.add(new File(jonasLib, "ext"), ".jar");
        if (this.hasWeb) {
            if (!this.isCatalina) {
                jurls.add(jetty6Lib, ".jar");
            }
            if (this.isTomcat6) {
                jurls.add(tomcat6Lib, ".jar");
            }
        }
        return new JClassLoader("Commons", jurls.toURLs());
    }

    private JClassLoader createAppsClassLoader() throws Exception {
        JURLs jurls = new JURLs();
        jurls.add(this.jonasAppsDir, ".jar");
        File jonasBaseLibApps = new File(jonasBase, "lib" + File.separator + "apps");
        if (jonasBaseLibApps.exists()) {
            jurls.add(jonasBaseLibApps, ".jar");
        }
        if (this.hasWeb && catalinaHome != null && this.isCatalina && !this.isTomcat6) {
            File catalinaBinDir = new File(catalinaHome, "bin");
            File catalinaCommonLibDir = new File(catalinaHome, "common" + File.separator + "lib");
            File catalinaSharedLibDir = new File(catalinaHome, "shared" + File.separator + "lib");
            jurls.add(new File(catalinaBinDir, "bootstrap.jar"));
            jurls.add(catalinaCommonLibDir, ".jar");
            jurls.add(catalinaSharedLibDir, ".jar");
        }
        return new JClassLoader("Apps", jurls.toURLs(), this.getCommonsLoader());
    }

    private JClassLoader createCatalinaClassLoader() throws Exception {
        JURLs jurls = new JURLs();
        if (this.isTomcat6) {
            return new JClassLoader("Tomcat6", new URL[0], this.getAppsLoader());
        }
        if (!this.hasEmbeddedCatalina5()) {
            File jonasTomcat5Glue = new File(catalinaLib, "server" + File.separator + "lib" + File.separator + "ow_jonas_tomcat5.jar");
            File jonasTomcat55Glue = new File(catalinaLib, "server" + File.separator + "lib" + File.separator + "ow_jonas_tomcat55.jar");
            if (jonasTomcat5Glue.exists()) {
                jurls.add(jonasTomcat5Glue);
            } else if (jonasTomcat55Glue.exists()) {
                jurls.add(jonasTomcat55Glue);
            } else {
                System.out.println("WARN : No ow_jonas_tomcat5.jar found in " + catalinaLib + "/server/lib directory.");
            }
        }
        File catalinaServerLibDir = new File(catalinaHome, "server" + File.separator + "lib");
        jurls.add(catalinaServerLibDir, ".jar");
        return new JClassLoader("Catalina", jurls.toURLs(), this.getAppsLoader());
    }
}

