/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.work;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.ow2.jonas.lib.work.FileManager;
import org.ow2.jonas.lib.work.FileManagerException;

public class EarFileManager
extends FileManager {
    private EarFileManager() {
    }

    protected static boolean isUnpackedEar(URL urlFileName, URL urlDirName) throws FileManagerException {
        File urlFile = new File(urlFileName.getFile());
        if (!urlFile.exists()) {
            throw new FileManagerException("File " + urlFileName + "doesn't exist");
        }
        String timeStampDir = EarFileManager.fileToTimeStampDir(urlFileName);
        File f = new File(urlDirName.getPath() + File.separator + timeStampDir);
        return f.exists();
    }

    public static URL unpackEar(URL urlFileName, URL urlDirName) throws FileManagerException {
        return EarFileManager.unpackEar(urlFileName, urlDirName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL unpackEar(URL urlFileName, URL urlDirName, boolean useTimeStamp) throws FileManagerException {
        if (!urlFileName.getProtocol().equalsIgnoreCase("file") || !urlDirName.getProtocol().equalsIgnoreCase("file")) {
            throw new FileManagerException("Only the file:/ URL can be used");
        }
        if (new File(urlFileName.getFile()).isDirectory()) {
            return urlFileName;
        }
        String timeStampDir = EarFileManager.fileToTimeStampDir(urlFileName);
        boolean unPacked = false;
        if (useTimeStamp) {
            unPacked = EarFileManager.isUnpackedEar(urlFileName, urlDirName);
        }
        JarFile earFile = null;
        File parentDirectoryFile = null;
        URL parentDirectoryUrl = null;
        try {
            earFile = new JarFile(urlFileName.getFile());
            if (useTimeStamp) {
                parentDirectoryFile = new File(urlDirName.getPath() + File.separator + timeStampDir);
            } else {
                String stReturn = new File(urlFileName.getFile()).getName();
                String userName = System.getProperty("user.name", "default");
                int lastIndex = stReturn.lastIndexOf(".");
                if (lastIndex == -1) {
                    throw new FileManagerException("The specified file " + urlFileName.getFile() + " is not a file with the format XXX.ear.");
                }
                stReturn = stReturn.substring(0, lastIndex);
                parentDirectoryFile = new File(urlDirName.getPath() + File.separator + userName + "_" + stReturn);
            }
            parentDirectoryUrl = new URL("file:" + parentDirectoryFile.getPath());
        }
        catch (IOException e) {
            throw new FileManagerException("Error while creating file for reading the ear file :" + urlFileName + ": " + e.getMessage());
        }
        if (unPacked) {
            return parentDirectoryUrl;
        }
        JarEntry earEntry = null;
        try {
            try {
                Enumeration<JarEntry> earEntries = earFile.entries();
                while (earEntries.hasMoreElements()) {
                    earEntry = earEntries.nextElement();
                    File earEntryFile = new File(parentDirectoryFile, earEntry.getName());
                    if (earEntry.isDirectory()) {
                        if (earEntryFile.exists() || earEntryFile.mkdirs()) continue;
                        String err = "Can not create directory " + earEntryFile + ", Check the write access.";
                        throw new FileManagerException(err);
                    }
                    earEntryFile.getParentFile().mkdirs();
                    InputStream is = null;
                    try {
                        is = earFile.getInputStream(earEntry);
                        EarFileManager.dump(is, earEntryFile);
                    }
                    finally {
                        is.close();
                    }
                }
            }
            finally {
                earFile.close();
            }
        }
        catch (IOException e) {
            throw new FileManagerException("Error while uncompressing entry " + earEntry + ": " + e.getMessage());
        }
        return parentDirectoryUrl;
    }
}

