/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class CaseInsensitiveDictionary
extends Dictionary {
    private Hashtable internalMap;
    private Hashtable originalKeys;

    CaseInsensitiveDictionary() {
        this.internalMap = new Hashtable();
        this.originalKeys = new Hashtable();
    }

    CaseInsensitiveDictionary(Dictionary props) {
        this();
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Key [" + key + "] must be a String");
            }
            String lowerCase = ((String)key).toLowerCase();
            if (this.internalMap.containsKey(lowerCase)) {
                throw new IllegalArgumentException("Key [" + key + "] already present in different case");
            }
            Object value = props.get(key);
            CaseInsensitiveDictionary.checkValue(value);
            this.internalMap.put(lowerCase, value);
            this.originalKeys.put(lowerCase, key);
        }
    }

    CaseInsensitiveDictionary(CaseInsensitiveDictionary props) {
        this.internalMap = new Hashtable(props.internalMap);
        this.originalKeys = new Hashtable(props.originalKeys);
    }

    public Enumeration elements() {
        return Collections.enumeration(this.internalMap.values());
    }

    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        String stringKey = String.valueOf(key).toLowerCase();
        return this.internalMap.get(stringKey);
    }

    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    public Enumeration keys() {
        return Collections.enumeration(this.originalKeys.values());
    }

    public Object put(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException("key or value");
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("Key [" + key + "] must be a String");
        }
        CaseInsensitiveDictionary.checkValue(value);
        String lowerCase = String.valueOf(key).toLowerCase();
        this.originalKeys.put(lowerCase, key);
        return this.internalMap.put(lowerCase, value);
    }

    public Object remove(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        String lowerCase = String.valueOf(key).toLowerCase();
        this.originalKeys.remove(lowerCase);
        return this.internalMap.remove(lowerCase);
    }

    public int size() {
        return this.internalMap.size();
    }

    /*
     * WARNING - void declaration
     */
    static void checkValue(Object value) {
        void var1_1;
        Class<?> type;
        if (value instanceof Object[]) {
            type = value.getClass().getComponentType();
            if (type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE || type == Byte.TYPE || type == Short.TYPE || type == Character.TYPE || type == Boolean.TYPE) {
                return;
            }
        } else if (value instanceof Vector) {
            Vector vector = (Vector)value;
            if (vector.isEmpty()) {
                throw new IllegalArgumentException("Vector must not be empty");
            }
            type = null;
            for (int i = 0; i < vector.size(); ++i) {
                Object el = vector.get(i);
                if (el == null) {
                    throw new IllegalArgumentException("Vector must not contain null elements");
                }
                if (type == null) {
                    type = el.getClass();
                    continue;
                }
                if (type == el.getClass()) continue;
                throw new IllegalArgumentException("Vector element types must not be mixed");
            }
        } else if (value != null) {
            type = value.getClass();
        } else {
            throw new IllegalArgumentException("Value must not be null");
        }
        if (var1_1 == String.class || var1_1 == Integer.class || var1_1 == Long.class || var1_1 == Float.class || var1_1 == Double.class || var1_1 == Byte.class || var1_1 == Short.class || var1_1 == Character.class || var1_1 == Boolean.class) {
            return;
        }
        throw new IllegalArgumentException("Value [" + value + "] has unsupported (base-) type " + var1_1);
    }

    public String toString() {
        return this.internalMap.toString();
    }
}

