/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    private static final int BUFFER_SIZE = 4096;
    private static Log logger = LogFactory.getLog(FileUtils.class);

    private FileUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unpack(JarFile packedJar, File dest) throws FileUtilsException {
        JarEntry entry = null;
        Enumeration<JarEntry> entries = packedJar.entries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            File entryFile = new File(dest, entry.getName());
            if (entry.isDirectory()) {
                if (entryFile.exists() || entryFile.mkdirs()) continue;
                String err = "Can not create directory " + entryFile + ", Check the write access.";
                throw new FileUtilsException(err);
            }
            entryFile.getParentFile().mkdirs();
            InputStream is = null;
            try {
                is = packedJar.getInputStream(entry);
                FileUtils.dump(is, entryFile);
            }
            catch (IOException ioe) {
                try {
                    throw new FileUtilsException("Cannot get inputstream of entry '" + entry + "' of file '" + packedJar + "'.");
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException ioe2) {
                        logger.error((Object)"Cannot close input stream", new Object[]{ioe2});
                    }
                    throw throwable;
                }
            }
            try {
                is.close();
            }
            catch (IOException ioe) {
                logger.error((Object)"Cannot close input stream", new Object[]{ioe});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(InputStream in, File entryFile) throws FileUtilsException {
        try {
            FileOutputStream out = new FileOutputStream(entryFile);
            int n = 0;
            try {
                byte[] buffer = new byte[4096];
                n = in.read(buffer);
                while (n > 0) {
                    out.write(buffer, 0, n);
                    n = in.read(buffer);
                }
                out.flush();
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            String err = "Error while unpacking entry " + entryFile + " : ";
            throw new FileUtilsException(err, e);
        }
    }

    public static void copyFile(String src, String dest) throws FileUtilsException {
        FileUtils.copyFile(new File(src), new File(dest));
    }

    /*
     * Loose catch block
     */
    public static void copyFile(File src, File dest) throws FileUtilsException {
        block17: {
            File newDest = null;
            if (dest.isDirectory()) {
                logger.debug((Object)"Copy a file to a directory, append source filename to directory.", new Object[0]);
                newDest = new File(dest, src.getName());
            } else {
                newDest = dest;
            }
            FileInputStream fIn = null;
            FileOutputStream fOut = null;
            AbstractInterruptibleChannel sourceFC = null;
            AbstractInterruptibleChannel targetFC = null;
            fIn = new FileInputStream(src);
            fOut = new FileOutputStream(newDest);
            sourceFC = fIn.getChannel();
            targetFC = fOut.getChannel();
            ((FileChannel)targetFC).transferFrom((ReadableByteChannel)((Object)sourceFC), 0L, ((FileChannel)sourceFC).size());
            ((FileChannel)targetFC).force(true);
            Object var9_7 = null;
            try {
                if (sourceFC != null) {
                    sourceFC.close();
                }
                if (targetFC != null) {
                    targetFC.close();
                }
                if (fOut != null) {
                    fOut.flush();
                    fOut.close();
                }
                if (fIn != null) {
                    fIn.close();
                }
                break block17;
            }
            catch (Exception e) {
                logger.error((Object)"Cannot close some i/o which are open.", new Object[]{e});
            }
            break block17;
            {
                catch (Exception e) {
                    throw new FileUtilsException("Error during copy file : " + src + " -> " + newDest, e);
                }
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                try {
                    if (sourceFC != null) {
                        sourceFC.close();
                    }
                    if (targetFC != null) {
                        targetFC.close();
                    }
                    if (fOut != null) {
                        fOut.flush();
                        fOut.close();
                    }
                    if (fIn != null) {
                        fIn.close();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Cannot close some i/o which are open.", new Object[]{e});
                }
                throw throwable;
            }
        }
    }

    public static boolean delete(String path) {
        return FileUtils.delete(new File(path));
    }

    public static boolean delete(File f) {
        if (f.isFile()) {
            return f.delete();
        }
        File[] children = f.listFiles();
        if (children == null) {
            return f.delete();
        }
        boolean result = true;
        for (int i = 0; i < children.length; ++i) {
            result &= FileUtils.delete(children[i]);
        }
        return result && f.delete();
    }

    public static void copyDirectory(String src, String dest) throws FileUtilsException {
        FileUtils.copyDirectory(new File(src), new File(dest));
    }

    public static void copyDirectory(File src, File dest) throws FileUtilsException {
        File[] childs;
        if (!src.isDirectory()) {
            throw new IllegalArgumentException("Source '" + src + "' must be a directory");
        }
        if (!dest.exists()) {
            dest.mkdirs();
        }
        if ((childs = src.listFiles()) != null) {
            for (int i = 0; i < childs.length; ++i) {
                File child = childs[i];
                if (child.isFile()) {
                    FileUtils.copyFile(child, dest);
                    continue;
                }
                FileUtils.copyDirectory(child, new File(dest, child.getName()));
            }
        }
    }

    public static void updateAttributesInManifest(String jarName, Map<String, String> attributes) throws FileUtilsException {
        File file = new File(jarName);
        if (!file.exists()) {
            throw new FileUtilsException("The file '" + file + "' is not existing on the filesystem");
        }
        JarFile jarFile = null;
        Manifest manifest = null;
        try {
            jarFile = new JarFile(file);
            manifest = jarFile.getManifest();
        }
        catch (IOException e) {
            throw new FileUtilsException("Error while using jar file " + file + "'", e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    throw new FileUtilsException("Error while closing jar file " + jarFile + "'", e);
                }
            }
        }
        boolean manifestUpdated = false;
        if (manifest == null) {
            manifest = new Manifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            mainAttributes.putValue("Manifest-Version", "1.0");
            manifestUpdated = true;
        }
        Attributes manifestAttributes = manifest.getMainAttributes();
        for (String attributeName : attributes.keySet()) {
            String attributeValue = attributes.get(attributeName);
            String manifestAttributeValue = manifestAttributes.getValue(attributeName);
            if (attributeValue == null || attributeValue.equals(manifestAttributeValue)) continue;
            Attributes.Name manifestAttributeName = new Attributes.Name(attributeName);
            manifestAttributes.put(manifestAttributeName, attributeValue);
            manifestUpdated = true;
        }
        if (!manifestUpdated) {
            return;
        }
        File tmpJarFile = null;
        try {
            tmpJarFile = File.createTempFile("tmpGenICFile", ".jar");
            FileUtils.updateJarFile(file, manifest, tmpJarFile);
            FileUtils.copyFile(tmpJarFile, file);
        }
        catch (IOException e) {
            throw new FileUtilsException("Cannot create temporary file", e);
        }
        finally {
            tmpJarFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateJarFile(File file, Manifest manifest, File tmpJarFile) throws FileUtilsException {
        FileOutputStream fileOS = null;
        try {
            fileOS = new FileOutputStream(tmpJarFile);
        }
        catch (FileNotFoundException e) {
            throw new FileUtilsException("Cannot create file output stream on the file '" + file + "'", e);
        }
        JarOutputStream fileJarOutputStream = null;
        try {
            fileJarOutputStream = new JarOutputStream((OutputStream)fileOS, manifest);
        }
        catch (IOException e) {
            throw new FileUtilsException("Cannot create Jar OutputStream", e);
        }
        JarFile jarFile = null;
        try {
            byte[] buffer = new byte[4096];
            jarFile = new JarFile(file);
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                if ("META-INF/MANIFEST.MF".equals(jarEntry.getName())) continue;
                fileJarOutputStream.putNextEntry(jarEntry);
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                try {
                    int n = inputStream.read(buffer);
                    while (n > 0) {
                        fileJarOutputStream.write(buffer, 0, n);
                        n = inputStream.read(buffer);
                    }
                    fileJarOutputStream.closeEntry();
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (IOException ioe) {
            throw new FileUtilsException("Cannot update jar file '" + file + "'", ioe);
        }
        finally {
            try {
                fileJarOutputStream.flush();
                fileJarOutputStream.close();
            }
            catch (IOException e) {
                throw new FileUtilsException("Cannot close jar file output stream", e);
            }
            try {
                fileOS.close();
            }
            catch (IOException e) {
                throw new FileUtilsException("Cannot close file output stream", e);
            }
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                throw new FileUtilsException("Cannot close jar file '" + jarFile + "'.", e);
            }
        }
    }
}

