/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.commands.admin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.ow2.jonas.commands.admin.CLIArgument;
import org.ow2.jonas.commands.admin.UtilAdmin;
import org.ow2.jonas.commands.admin.util.JMXConnectionHelper;

public class ClientAdmin {
    private static final String SERVERNAME = "JOnAS server ";
    private static final String DEFAULT_NAME = "jonas";
    private static String jonasName = null;
    private static String domainName = null;
    private static ObjectName j2eeServerObjectName = null;
    private static ObjectName domainOn = null;
    private static final String DEFAULT_REGISTRY_URL = "rmi://localhost:1099";
    private static final String DEFAULT_PROTOCOL = "jrmp";
    private static final String JXMSERVICE_URL_PREFIX = "service:jmx:rmi:///jndi/";
    private static boolean isError = false;
    private static final int DEFAULT_TIMEOUT = 15000;
    private static final long WAIT_LOOP_MSEC = 1000L;
    private static String[] target = null;
    private static boolean qOption = false;
    private static JMXConnectionHelper connection;

    public static void main(String[] args) throws IOException {
        ArrayList<CLIArgument> lstArgs;
        boolean interactive;
        boolean sOption;
        block67: {
            String fileName = null;
            String timeout = null;
            String topic = null;
            String pingTimeoutValue = null;
            String protocol = null;
            String registry = null;
            boolean pingOption = false;
            sOption = false;
            interactive = true;
            boolean namedServer = false;
            lstArgs = new ArrayList<CLIArgument>();
            for (int argn = 0; argn < args.length; ++argn) {
                CLIArgument ja;
                boolean nextArgument;
                String arg = args[argn];
                boolean bl = nextArgument = argn < args.length - 1;
                if (arg.equals("-a") && nextArgument) {
                    fileName = args[++argn];
                    ja = new CLIArgument(101, fileName);
                    lstArgs.add(ja);
                    interactive = false;
                    continue;
                }
                if (arg.equals("-ping")) {
                    pingOption = true;
                    continue;
                }
                if (arg.equals("-custom")) {
                    ja = new CLIArgument(110);
                    lstArgs.add(ja);
                    interactive = false;
                    continue;
                }
                if (arg.equals("-e")) {
                    ja = new CLIArgument(105);
                    lstArgs.add(ja);
                    interactive = false;
                    continue;
                }
                if (arg.equals("-h") || arg.equals("-?")) {
                    ClientAdmin.usage();
                    System.exit(0);
                }
                if (arg.equals("-gc")) {
                    ja = new CLIArgument(112);
                    lstArgs.add(ja);
                    interactive = false;
                    continue;
                }
                if (arg.equals("-j")) {
                    ja = new CLIArgument(104);
                    lstArgs.add(ja);
                    interactive = false;
                    continue;
                }
                if (arg.equals("-l")) {
                    ja = new CLIArgument(103);
                    lstArgs.add(ja);
                    interactive = false;
                    continue;
                }
                if (arg.equals("-lmodules")) {
                    ja = new CLIArgument(116);
                    lstArgs.add(ja);
                    interactive = false;
                    continue;
                }
                if (arg.equals("-lapps")) {
                    ja = new CLIArgument(117);
                    lstArgs.add(ja);
                    interactive = false;
                    continue;
                }
                if (arg.equals("-n") && nextArgument) {
                    jonasName = args[++argn];
                    namedServer = true;
                    continue;
                }
                if (arg.equals("-registry") && nextArgument) {
                    registry = args[++argn];
                    continue;
                }
                if (arg.equals("-protocol") && nextArgument) {
                    protocol = args[++argn];
                    continue;
                }
                if (arg.equals("-timeout") && nextArgument) {
                    pingTimeoutValue = args[++argn];
                    continue;
                }
                if (arg.equals("-target") && nextArgument) {
                    target = ClientAdmin.makeArrayFrom(args[++argn]);
                    continue;
                }
                if (arg.equals("-r") && nextArgument) {
                    fileName = args[++argn];
                    ja = new CLIArgument(102, fileName);
                    lstArgs.add(ja);
                    interactive = false;
                    continue;
                }
                if (arg.equals("-s")) {
                    sOption = true;
                    interactive = false;
                    continue;
                }
                if (arg.equals("-stop")) {
                    ja = new CLIArgument(115);
                    lstArgs.add(ja);
                    interactive = false;
                    continue;
                }
                if (arg.equals("-halt")) {
                    ja = new CLIArgument(118);
                    lstArgs.add(ja);
                    interactive = false;
                    continue;
                }
                if (arg.equals("-start")) {
                    ja = new CLIArgument(114);
                    lstArgs.add(ja);
                    interactive = false;
                    continue;
                }
                if (arg.equals("-sync")) {
                    ja = new CLIArgument(109);
                    lstArgs.add(ja);
                    interactive = false;
                    continue;
                }
                if (arg.equals("-passivate")) {
                    ja = new CLIArgument(111);
                    lstArgs.add(ja);
                    interactive = false;
                    continue;
                }
                if (arg.equals("--debug-level") && nextArgument) {
                    topic = args[++argn];
                    ja = new CLIArgument(107, topic);
                    lstArgs.add(ja);
                    interactive = false;
                    continue;
                }
                if (arg.equals("-t")) {
                    ja = new CLIArgument(106);
                    lstArgs.add(ja);
                    interactive = false;
                    continue;
                }
                if (arg.equals("-tt") && nextArgument) {
                    timeout = args[++argn];
                    ja = new CLIArgument(108, timeout);
                    lstArgs.add(ja);
                    interactive = false;
                    continue;
                }
                if (arg.equals("-isdeployed") && nextArgument) {
                    fileName = args[++argn];
                    ja = new CLIArgument(113, fileName);
                    lstArgs.add(ja);
                    interactive = false;
                    continue;
                }
                if (arg.equals("-q")) {
                    qOption = true;
                    interactive = false;
                    continue;
                }
                System.out.println("Bad option: " + arg);
                ClientAdmin.usage();
                System.exit(2);
            }
            if (!namedServer) {
                jonasName = DEFAULT_NAME;
            }
            if (registry == null) {
                registry = DEFAULT_REGISTRY_URL;
            }
            if (protocol == null) {
                protocol = DEFAULT_PROTOCOL;
            }
            String serverUrl = JXMSERVICE_URL_PREFIX.concat(registry).concat("/").concat(protocol).concat("connector_").concat(jonasName);
            JMXServiceURL jmxServerUrl = null;
            try {
                jmxServerUrl = new JMXServiceURL(serverUrl);
            }
            catch (MalformedURLException e) {
                System.err.println("Can't administer server " + jonasName + " because of incorrect jmx url (" + e.getMessage() + ")");
                System.exit(2);
            }
            connection = new JMXConnectionHelper(jmxServerUrl, null);
            if (pingOption) {
                int pingTimeout = 15000;
                if (pingTimeoutValue != null) {
                    try {
                        pingTimeout = Integer.parseInt(pingTimeoutValue);
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("Incorrect timeout value for ping. Value is '" + pingTimeoutValue + "'.");
                    }
                }
                System.exit(ClientAdmin.waitServerRunning(pingTimeout));
            }
            if (!connection.connect()) {
                System.err.println("Cannot connect to JOnAS using '" + jmxServerUrl + "'");
                connection.getLastException().printStackTrace(System.err);
            }
            System.out.println("Welcome to the new administration client based on JMX Remote !");
            System.out.println("You are administering server named " + jonasName);
            System.out.println("  " + serverUrl);
            try {
                MBeanServerConnection conn = connection.getConnection();
                j2eeServerObjectName = ClientAdmin.getJ2EEServerObjectName(conn);
                domainName = j2eeServerObjectName.getDomain();
                domainOn = ObjectName.getInstance(domainName + ":j2eeType=J2EEDomain,name=" + domainName);
            }
            catch (Exception e) {
                if (pingOption) break block67;
                System.err.println("Can't admin server " + jonasName + ". Problem with jmx remote connection (" + e.getMessage() + ")");
                System.exit(2);
            }
        }
        if (sOption) {
            ClientAdmin.stopServer();
            if (isError) {
                System.exit(2);
            } else {
                return;
            }
        }
        if (interactive) {
            ClientAdmin.menu();
        } else {
            boolean first = true;
            boolean forQuiet = qOption;
            qOption = true;
            for (CLIArgument argument : lstArgs) {
                switch (argument.type) {
                    case 101: {
                        ClientAdmin.addFile(argument.value);
                        break;
                    }
                    case 102: {
                        ClientAdmin.removeFile(argument.value);
                        break;
                    }
                    case 114: {
                        ClientAdmin.startServer();
                        break;
                    }
                    case 115: {
                        ClientAdmin.stopServer();
                        break;
                    }
                    case 118: {
                        ClientAdmin.haltServer();
                        break;
                    }
                    case 103: {
                        ClientAdmin.listBeans();
                        break;
                    }
                    case 116: {
                        ClientAdmin.listModules();
                        break;
                    }
                    case 117: {
                        ClientAdmin.listApps();
                        break;
                    }
                    case 104: {
                        ClientAdmin.listJNDINames();
                        break;
                    }
                    case 105: {
                        ClientAdmin.listProperties();
                        break;
                    }
                    case 106: {
                        ClientAdmin.listTopics();
                        break;
                    }
                    case 107: {
                        ClientAdmin.setTopic(argument.value, "DEBUG");
                        break;
                    }
                    case 108: {
                        ClientAdmin.setTTimeout(argument.value);
                        break;
                    }
                    case 109: {
                        ClientAdmin.sync(false);
                        break;
                    }
                    case 110: {
                        ClientAdmin.custom();
                        break;
                    }
                    case 111: {
                        ClientAdmin.sync(true);
                        break;
                    }
                    case 112: {
                        ClientAdmin.runGC();
                        break;
                    }
                    case 113: {
                        ClientAdmin.isDeployedFile(argument.value);
                    }
                }
                if (first) {
                    first = false;
                    qOption = forQuiet;
                }
                if (!isError) continue;
                System.exit(2);
            }
        }
        connection.close();
    }

    private static void runGC() {
        MBeanServerConnection conn;
        if (!qOption) {
            System.out.println("Run GC:");
        }
        if ((conn = ClientAdmin.getConnection()) == null) {
            isError = true;
            return;
        }
        String operationName = "runGC";
        Object[] params = null;
        String[] signature = null;
        try {
            conn.invoke(j2eeServerObjectName, operationName, params, signature);
        }
        catch (Exception e) {
            System.err.println("Can't run GC in server " + jonasName + ". JMX Problem with MBean " + j2eeServerObjectName + " " + e.getMessage() + ".");
        }
        System.out.println("");
    }

    private static MBeanServerConnection getConnection() {
        try {
            return connection.getConnection();
        }
        catch (IOException e) {
            System.err.println("Unable to connect to " + connection.getURL());
            System.err.println("Latest Exception: " + e.getMessage());
            return null;
        }
    }

    private static void custom() {
        MBeanServerConnection conn;
        if (!qOption) {
            System.out.println("Custom:");
        }
        if ((conn = ClientAdmin.getConnection()) == null) {
            isError = true;
            return;
        }
        try {
            System.out.println(UtilAdmin.dumpCustom(domainName, jonasName, conn));
        }
        catch (Exception e) {
            System.err.println(e);
            isError = true;
            return;
        }
        System.out.println("");
    }

    private static String[] makeArrayFrom(String line) {
        StringTokenizer stk = new StringTokenizer(line, ",");
        int nb = stk.countTokens();
        String[] ret = new String[nb];
        for (int i = 0; i < nb; ++i) {
            ret[i] = stk.nextToken();
        }
        return ret;
    }

    private static void usage() {
        System.out.println("usage : jonas admin <options>");
        System.out.println("if no option(except -n), mode is interactive.");
        System.out.println("list of available options:");
        System.out.println("    -n name : to identify an JOnAS Server");
        System.out.println("    -registry : to define registry address (rmi://localhost:1099 by default)");
        System.out.println("    -protocol : to define protocol (jrmp by default)");
        System.out.println("    -s : stops the EJB server.");
        System.out.println("    -l        : lists beans currently in the JOnAS Server.");
        System.out.println("    -lmodules : lists J2EEModules currently in the JOnAS Server.");
        System.out.println("    -lapps    : lists J2EEApplications currently in the JOnAS Server.");
        System.out.println("    -j : lists registered JNDI names.");
        System.out.println("    -e : lists JOnAS properties currently used by the JOnAS Server.");
        System.out.println("    -a fileName : dynamically adds   : - beans from fileName in a new container");
        System.out.println("                                     : - servlets from a WAR file");
        System.out.println("                                     : - j2ee application from an EAR file");
        System.out.println("                                     : - resource adapter from a RAR file");
        System.out.println("    -r fileName : dynamically remove : - beans from container fileName");
        System.out.println("                                     : - servlets of a WAR file");
        System.out.println("                                     : - j2ee application of an EAR file");
        System.out.println("                                     : - resource adapter from a RAR file");
        System.out.println("    -sync: synchronize all entities");
        System.out.println("    -passivate: passivate all entities");
        System.out.println("    -gc: run the garbage collector");
        System.out.println("    -tt timeout: set default transaction timeout");
        System.out.println("    -start: Start servers designed by '-target' arg");
        System.out.println("    -target target: set target for commands (default is local server)");
        System.out.println("    -ping [-timeout <val (sec)>]: ping server for a given time.(default=100s)");
        System.out.println("    -t list monolog topics");
        System.out.println("    --debug-level topic : set DEBUG for a monolog topic");
        System.out.println("    -q : quiet mode, no processing header information.");
        System.out.println("    -h : help message.");
        System.out.println("    -? : help message.");
    }

    public static void menu() throws IOException {
        BufferedReader inbuf = new BufferedReader(new InputStreamReader(System.in));
        block0: while (true) {
            String fName;
            System.out.print("Admin (" + jonasName + ") > ");
            String command = inbuf.readLine();
            if (command.length() == 0) continue;
            if ("addbeans".startsWith(command) || "addfile".startsWith(command)) {
                fName = null;
                System.out.print("file name ? > ");
                fName = inbuf.readLine();
                if (fName.length() == 0) continue;
                ClientAdmin.addFile(fName);
                continue;
            }
            if ("start".startsWith(command)) {
                ClientAdmin.startServer();
                continue;
            }
            if ("env".startsWith(command)) {
                ClientAdmin.listProperties();
                continue;
            }
            if ("gc".startsWith(command)) {
                ClientAdmin.runGC();
                continue;
            }
            if ("help".startsWith(command) || command.equals("?")) {
                ClientAdmin.help();
                continue;
            }
            if ("jndinames".startsWith(command)) {
                ClientAdmin.listJNDINames();
                continue;
            }
            if ("listbeans".startsWith(command)) {
                ClientAdmin.listBeans();
                continue;
            }
            if ("listmodules".startsWith(command)) {
                ClientAdmin.listModules();
                continue;
            }
            if ("listapps".startsWith(command)) {
                ClientAdmin.listApps();
                continue;
            }
            if ("custom".startsWith(command)) {
                ClientAdmin.custom();
                continue;
            }
            if ("name".startsWith(command)) {
                System.out.println("Use the -n option to define the managed server name");
                continue;
            }
            if ("quit".startsWith(command) || "exit".startsWith(command)) {
                return;
            }
            if ("removebeans".startsWith(command) || "removefile".startsWith(command)) {
                fName = null;
                System.out.print("file name ? > ");
                fName = inbuf.readLine();
                if (fName.length() == 0) continue;
                ClientAdmin.removeFile(fName);
                continue;
            }
            if ("trace".startsWith(command)) {
                while (true) {
                    if (!ClientAdmin.listTopics()) continue block0;
                    System.out.print("topic name ? > ");
                    String tname = inbuf.readLine().trim();
                    if (tname.length() == 0) continue block0;
                    System.out.print("topic level ? (DEBUG | WARN | INFO | ERROR | INHERIT) > ");
                    String levstr = inbuf.readLine().trim();
                    ClientAdmin.setTopic(tname, levstr);
                }
            }
            if ("stop".startsWith(command)) {
                ClientAdmin.stopServer();
                continue;
            }
            if ("sync".startsWith(command)) {
                ClientAdmin.sync(false);
                continue;
            }
            if ("passivate".startsWith(command)) {
                ClientAdmin.sync(true);
                continue;
            }
            if ("ttimeout".startsWith(command)) {
                String tstr = null;
                System.out.print("transaction timeout in seconds ? > ");
                tstr = inbuf.readLine();
                if (tstr.length() == 0) continue;
                ClientAdmin.setTTimeout(tstr);
                continue;
            }
            if ("target".startsWith(command)) {
                System.out.print("Server or Cluster where to deploy the beans ? > ");
                target = ClientAdmin.makeArrayFrom(inbuf.readLine());
                continue;
            }
            System.out.println("Unknown command. Type help to get for the list of commands.");
        }
    }

    private static void help() {
        System.out.println("addbeans    adds beans in a new JOnAS container");
        System.out.println("addfile     adds beans/servlets/j2ee app/rars based upon the file extension");
        System.out.println("custom      dump jonas customization");
        System.out.println("env         JOnAS properties used by the server");
        System.out.println("gc          run the garbage collector");
        System.out.println("help        help");
        System.out.println("jndinames   lists registered JNDI names");
        System.out.println("listbeans          lists beans");
        System.out.println("listmodules        lists modules");
        System.out.println("listapps           lists applications");
        System.out.println("name        to identify a current JOnAS server");
        System.out.println("quit        quit JonasAdmin");
        System.out.println("removebeans remove beans in a new JOnAS container");
        System.out.println("removefile  remove beans/servlets/j2ee app/rars (based upon the file extension)");
        System.out.println("start       stop target servers");
        System.out.println("stop        stop target servers");
        System.out.println("sync        synchronize all entities");
        System.out.println("passivate   passivate all entities");
        System.out.println("trace       get/set monolog topics");
        System.out.println("ttimeout    set default transaction timeout");
        System.out.println("target      set list of servers where command must be applied");
    }

    private static int waitServerRunning(int pingTimeout) {
        if (pingTimeout <= 0) {
            throw new IllegalArgumentException("Timeout should be a value greater than 0");
        }
        String serverState = null;
        double loopValue = (double)pingTimeout / 1.0;
        int i = 0;
        while ((double)i < loopValue) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return 1;
            }
            if (connection.connect()) {
                MBeanServerConnection conn = ClientAdmin.getConnection();
                if (j2eeServerObjectName == null) {
                    j2eeServerObjectName = ClientAdmin.getJ2EEServerObjectName(conn);
                } else {
                    try {
                        serverState = (String)conn.getAttribute(j2eeServerObjectName, "state");
                        if (serverState.equalsIgnoreCase("RUNNING")) {
                            return 0;
                        }
                    }
                    catch (IOException e) {
                    }
                    catch (InstanceNotFoundException e) {
                    }
                    catch (Exception e) {
                        System.err.println("Cannot administer server " + jonasName + ". Problem with MBean " + j2eeServerObjectName + " (" + e.getMessage() + ")");
                        return 2;
                    }
                }
            }
            ++i;
        }
        System.out.println(SERVERNAME + jonasName + " is " + serverState);
        return 1;
    }

    private static ObjectName getJ2EEServerObjectName(MBeanServerConnection conn) {
        if (j2eeServerObjectName == null) {
            try {
                Set<ObjectName> servers = conn.queryNames(UtilAdmin.J2EEServer(jonasName), null);
                if (!servers.isEmpty()) {
                    return servers.iterator().next();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static void addFile(String fileName) {
        MBeanServerConnection conn;
        if (!qOption) {
            System.out.println("Add File:" + fileName);
        }
        if ((conn = ClientAdmin.getConnection()) == null) {
            isError = true;
            return;
        }
        String operationName = "deploy";
        Object[] params = new String[]{fileName};
        String[] signature = new String[]{"java.lang.String"};
        try {
            conn.invoke(j2eeServerObjectName, operationName, params, signature);
            System.out.println("Check result with listmodules or listapps command.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("");
    }

    private static void isDeployedFile(String fileName) {
        MBeanServerConnection conn;
        if (!qOption) {
            System.out.println("Is File Deployable:");
        }
        if ((conn = ClientAdmin.getConnection()) == null) {
            isError = true;
            return;
        }
        String operationName = "isDeployed";
        Object[] params = new String[]{fileName};
        String[] signature = new String[]{"java.lang.String"};
        try {
            boolean res = (Boolean)conn.invoke(j2eeServerObjectName, operationName, params, signature);
            if (res) {
                System.out.println("File " + fileName + " deployed");
            } else {
                System.out.println("File " + fileName + " not deployed");
            }
            System.out.println("Check result with listmodules or listapps command.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("");
    }

    private static void removeFile(String fileName) {
        MBeanServerConnection conn;
        if (!qOption) {
            System.out.println("Remove File: " + fileName);
        }
        if ((conn = ClientAdmin.getConnection()) == null) {
            isError = true;
            return;
        }
        String operationName = "undeploy";
        Object[] params = new String[]{fileName};
        String[] signature = new String[]{"java.lang.String"};
        try {
            conn.invoke(j2eeServerObjectName, operationName, params, signature);
            System.out.println("Check result with listmodules or listapps command.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("");
    }

    private static void stopServer() {
        MBeanServerConnection conn = ClientAdmin.getConnection();
        if (conn == null) {
            isError = true;
            return;
        }
        try {
            if (target == null) {
                System.out.println("Stop server: " + jonasName);
                String operationName = "stop";
                Object[] params = null;
                String[] signature = null;
                try {
                    conn.invoke(j2eeServerObjectName, operationName, params, signature);
                }
                catch (Exception e) {
                    System.err.println("Can't stop server " + jonasName + ". JMX Problem with MBean " + j2eeServerObjectName + " " + e.getMessage() + ".");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("");
    }

    private static void haltServer() {
        block10: {
            MBeanServerConnection conn = ClientAdmin.getConnection();
            if (conn == null) {
                isError = true;
                return;
            }
            try {
                if (target == null) {
                    System.out.println("Halting server: " + jonasName);
                    String operationName = "halt";
                    Object[] params = null;
                    String[] signature = null;
                    try {
                        conn.invoke(j2eeServerObjectName, operationName, params, signature);
                    }
                    catch (Exception e) {
                        System.err.println("Can't halt server " + jonasName + ". JMX Problem with MBean " + j2eeServerObjectName + " " + e.getMessage() + ".");
                    }
                } else {
                    for (int i = 0; i < target.length; ++i) {
                        String atarget = target[i];
                        String operationName = "stopRemoteTarget";
                        Object[] params = new String[]{atarget};
                        String[] signature = new String[]{"java.lang.String"};
                        try {
                            conn.invoke(domainOn, operationName, params, signature);
                            continue;
                        }
                        catch (Exception e) {
                            System.err.println("Can't halt remote server " + atarget + ". JMX Problem with MBean " + domainOn + " " + e.getMessage() + ".");
                        }
                    }
                }
            }
            catch (Exception e) {
                if (target == null) break block10;
                System.err.println("Error while halting servers:" + e.getCause().getMessage());
            }
        }
        System.out.println("");
    }

    private static void startServer() {
        block10: {
            MBeanServerConnection conn = ClientAdmin.getConnection();
            if (conn == null) {
                isError = true;
                return;
            }
            try {
                if (target == null) {
                    String operationName = "start";
                    Object[] params = null;
                    String[] signature = null;
                    try {
                        conn.invoke(j2eeServerObjectName, operationName, params, signature);
                    }
                    catch (Exception e) {
                        System.err.println("Can't start server " + jonasName + ". JMX Problem with MBean " + j2eeServerObjectName + " " + e.getMessage() + ".");
                    }
                } else {
                    for (int i = 0; i < target.length; ++i) {
                        String atarget = target[i];
                        String operationName = "startRemoteTarget";
                        Object[] params = new String[]{atarget};
                        String[] signature = new String[]{"java.lang.String"};
                        try {
                            conn.invoke(domainOn, operationName, params, signature);
                            continue;
                        }
                        catch (Exception e) {
                            System.err.println("Can't start remote server " + atarget + ". JMX Problem with MBean " + domainOn + " " + e.getMessage() + ".");
                        }
                    }
                }
            }
            catch (Exception e) {
                if (target == null) break block10;
                System.err.println("Error while starting servers:" + e.getCause().getMessage());
            }
        }
        System.out.println("");
    }

    private static void listBeans() {
        MBeanServerConnection conn;
        if (!qOption) {
            System.out.println("ListBeans:");
        }
        if ((conn = ClientAdmin.getConnection()) == null) {
            isError = true;
            return;
        }
        try {
            ArrayList<String> names = UtilAdmin.listBeans(domainName, jonasName, conn);
            if (names.size() == 0) {
                System.out.println("No beans in " + jonasName);
            } else {
                for (String name : names) {
                    System.out.println(name);
                }
            }
        }
        catch (Exception e) {
            System.err.println("ListBeans: " + e);
            isError = true;
            return;
        }
        System.out.println("");
    }

    private static void listModules() {
        MBeanServerConnection conn;
        if (!qOption) {
            System.out.println("ListModules:");
        }
        if ((conn = ClientAdmin.getConnection()) == null) {
            isError = true;
            return;
        }
        try {
            ArrayList<String> names = UtilAdmin.listModules(domainName, jonasName, conn);
            if (names.size() == 0) {
                System.out.println("No modules in " + jonasName);
            } else {
                for (String name : names) {
                    System.out.println(name);
                }
            }
        }
        catch (Exception e) {
            System.err.println("ListModules: " + e);
            isError = true;
            return;
        }
        System.out.println("");
    }

    private static void listApps() {
        MBeanServerConnection conn;
        if (!qOption) {
            System.out.println("ListApplications:");
        }
        if ((conn = ClientAdmin.getConnection()) == null) {
            isError = true;
            return;
        }
        try {
            ArrayList<String> names = UtilAdmin.listApps(domainName, jonasName, conn);
            if (names.size() == 0) {
                System.out.println("No applications in " + jonasName);
            } else {
                for (String name : names) {
                    System.out.println(name);
                }
            }
        }
        catch (Exception e) {
            System.err.println("ListApplications: " + e);
            isError = true;
            return;
        }
        System.out.println("");
    }

    private static void listJNDINames() {
        MBeanServerConnection conn;
        if (!qOption) {
            System.out.println("List JndiNames:");
        }
        if ((conn = ClientAdmin.getConnection()) == null) {
            isError = true;
            return;
        }
        try {
            ArrayList<ObjectName> ons = UtilAdmin.listJNDIResources(domainName, jonasName, conn);
            for (ObjectName on : ons) {
                System.out.println("");
                try {
                    String name = (String)conn.getAttribute(on, "Name");
                    ArrayList names = (ArrayList)conn.getAttribute(on, "Names");
                    System.out.println(name + " names:");
                    for (int i = 0; i < names.size(); ++i) {
                        System.out.println(names.get(i));
                    }
                }
                catch (JMException me) {
                    System.out.println(">> JNDIResource: " + me);
                }
            }
        }
        catch (Exception e) {
            System.err.println("List JndiNames: " + e);
            isError = true;
            return;
        }
        System.out.println("");
    }

    private static void listProperties() {
        MBeanServerConnection conn;
        if (!qOption) {
            System.out.println("ListProperties:");
        }
        if ((conn = ClientAdmin.getConnection()) == null) {
            isError = true;
            return;
        }
        String operationName = "getConfigFileEnv";
        Object[] params = null;
        String[] signature = null;
        try {
            Properties configProps = (Properties)conn.invoke(j2eeServerObjectName, operationName, params, signature);
            Enumeration<Object> e = configProps.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = configProps.get(key);
                System.out.println(key.toString() + "=" + value.toString());
            }
        }
        catch (Exception e) {
            System.err.println("Can't get properties of server " + jonasName + ". JMX Problem with MBean " + j2eeServerObjectName + " " + e.getMessage() + ".");
        }
        System.out.println("");
    }

    private static boolean listTopics() {
        MBeanServerConnection conn;
        if (!qOption) {
            System.out.println("List Monolog Topics:");
        }
        if ((conn = ClientAdmin.getConnection()) == null) {
            isError = true;
            return false;
        }
        try {
            String[] result = UtilAdmin.getTopics(domainName, jonasName, conn);
            if (result == null) {
                System.out.println("Can't list Monolog Topics. Didn't found MBean for JOnAS logging management");
                return false;
            }
            if (result.length == 0) {
                System.out.println("No topics in " + jonasName);
            }
            for (int i = 0; i < result.length; ++i) {
                String level = UtilAdmin.getTopicLevel(domainName, jonasName, conn, result[i]);
                System.out.println(level + "\t" + result[i]);
            }
        }
        catch (Exception e) {
            System.err.println("List Monolog Topics : " + e);
            isError = true;
            return false;
        }
        return true;
    }

    private static void setTopic(String t, String l) {
        MBeanServerConnection conn;
        if (!qOption) {
            System.out.println("Set Monolog Topic:");
        }
        if ((conn = ClientAdmin.getConnection()) == null) {
            isError = true;
            return;
        }
        try {
            UtilAdmin.setTopicLevel(domainName, jonasName, conn, t, l);
        }
        catch (Exception e) {
            System.err.println("Set Monolog Topic : " + e);
            isError = true;
        }
        System.out.println("");
    }

    private static void setTTimeout(String tstr) {
        MBeanServerConnection conn;
        if (!qOption) {
            System.out.println("Set TransactionTimeout:");
        }
        if ((conn = ClientAdmin.getConnection()) == null) {
            isError = true;
            return;
        }
        Integer t = new Integer(tstr);
        try {
            ObjectName on = UtilAdmin.getJ2eeMBean(domainName, jonasName, "JTAResource", "JTAResource");
            if (conn.isRegistered(on)) {
                Attribute att = new Attribute("timeOut", t);
                conn.setAttribute(on, att);
                Integer val = (Integer)conn.getAttribute(on, "timeOut");
                System.out.println("TM timeout=" + val);
            }
        }
        catch (Exception e) {
            System.err.println("Can't set transaction time-out for server " + jonasName + ". " + e.getMessage());
        }
        System.out.println("");
    }

    private static void sync(boolean passivate) {
        MBeanServerConnection conn;
        if (!qOption) {
            System.out.println("Sync:");
        }
        if ((conn = ClientAdmin.getConnection()) == null) {
            isError = true;
            return;
        }
        try {
            ObjectName on = ClientAdmin.getJonasServiceMBean(domainName, jonasName, "ejbContainers");
            String operationName = "syncAllEntities";
            Object[] params = new Boolean[]{passivate};
            String[] signature = new String[]{"boolean"};
            try {
                conn.invoke(on, operationName, params, signature);
            }
            catch (Exception e) {
                System.err.println("Can't sync entity beans in server " + jonasName + ". JMX Problem with MBean " + on + " " + e + ".");
            }
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        System.out.println("");
    }

    private static ObjectName getJonasServiceMBean(String domain, String server, String service) throws MalformedObjectNameException, NullPointerException {
        StringBuffer sb = new StringBuffer(domain);
        sb.append(":");
        sb.append("type");
        sb.append("=");
        sb.append("service");
        sb.append(",");
        sb.append("name");
        sb.append("=");
        sb.append(service);
        return ObjectName.getInstance(new String(sb));
    }
}

