/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.commands.admin.util;

import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;

public class JMXConnectionHelper {
    private JMXServiceURL url;
    private Subject subject;
    private JMXConnector connector;
    private IOException lastException;

    public JMXConnectionHelper(JMXServiceURL url, Subject subject) {
        this.url = url;
        this.subject = subject;
    }

    public boolean connect() {
        if (this.connector == null) {
            try {
                this.connector = this.createConnector();
            }
            catch (IOException e) {
                this.lastException = e;
                return false;
            }
        }
        return true;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    private JMXConnector createConnector() throws IOException {
        return JMXConnectorFactory.connect(this.url, null);
    }

    public MBeanServerConnection getConnection() throws IOException {
        if (this.connector != null) {
            return this.connector.getMBeanServerConnection(this.subject);
        }
        if (this.connect()) {
            return this.connector.getMBeanServerConnection(this.subject);
        }
        throw this.lastException;
    }

    public boolean close() {
        if (this.connector != null) {
            try {
                this.connector.close();
                this.connector = null;
            }
            catch (IOException e) {
                this.lastException = e;
                return false;
            }
        }
        return true;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public JMXServiceURL getURL() {
        return this.url;
    }
}

