/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.registry;

import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.ow2.carol.rmi.exception.NamingExceptionHelper;
import org.ow2.carol.util.naming.LocalEnumeration;
import org.ow2.carol.util.naming.SimpleNameParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsRegistryWrapperContext
implements Context {
    private final Registry registry;
    private static Hashtable<Object, Object> environment = null;
    private static final NameParser NAME_PARSER = new SimpleNameParser();

    public AbsRegistryWrapperContext(Hashtable<Object, Object> env, Registry registry, String initialContextFactory) {
        this.registry = registry;
        environment = env;
        environment.put("java.naming.factory.initial", initialContextFactory);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Remote obj;
        if (name.isEmpty()) {
            return this;
        }
        try {
            obj = this.registry.lookup(name.get(0));
        }
        catch (NotBoundException e) {
            NameNotFoundException nnfe = new NameNotFoundException(name.get(0));
            nnfe.setRootCause(e);
            throw nnfe;
        }
        catch (Exception e) {
            throw NamingExceptionHelper.create("Cannot lookup name '" + name + "' : " + e.getMessage(), e);
        }
        return obj;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException("Cannot bind empty name");
        }
        if (!(obj instanceof Remote)) {
            throw new NamingException("Can only bind object which implements Remote interface. This is not the case for object '" + obj + "' with name '" + name + "'.");
        }
        try {
            this.registry.bind(name.get(0), (Remote)obj);
        }
        catch (AlreadyBoundException e) {
            NameAlreadyBoundException ne = new NameAlreadyBoundException(name.get(0));
            ne.setRootCause(e);
            throw ne;
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException("Cannot rebind empty name");
        }
        if (!(obj instanceof Remote)) {
            throw new NamingException("Can only rebind object which implements Remote interface. This is not the case for object '" + obj + "' with name '" + name + "'.");
        }
        try {
            this.registry.rebind(name.get(0), (Remote)obj);
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new NamingException("Cannot unbind empty name");
        }
        try {
            this.registry.unbind(name.get(0));
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.bind(newName, this.lookup(oldName));
        this.unbind(oldName);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new CompositeName(oldName), new CompositeName(newName));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw new NamingException("Cannot list with a given empty name");
        }
        try {
            String[] names = this.registry.list();
            return new LocalEnumeration<NameClassPair>(this, names);
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw new NamingException("can not list");
        }
        try {
            String[] names = this.registry.list();
            return new LocalEnumeration<Binding>(this, names);
        }
        catch (RemoteException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new NamingException("destroySubcontext() method not implemented");
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new NamingException("createSubcontext() method not implemented");
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return NAME_PARSER;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return NAME_PARSER;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        return result.addAll(name);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(new CompositeName(name), new CompositeName(prefix)).toString();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return environment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return environment.remove(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return (Hashtable)environment.clone();
    }

    @Override
    public void close() {
    }

    @Override
    public String getNameInNamespace() {
        return "";
    }
}

