/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.rmi.jrmp.interceptor.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.List;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorsGroup;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorsKind;
import org.ow2.carol.rmi.jrmp.interceptor.spi.JClientRequestInterceptor;
import org.ow2.carol.rmi.jrmp.interceptor.spi.JServerRequestInterceptor;
import org.ow2.carol.util.configuration.TraceCarol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JInterceptorHelper {
    protected static final int NO_CTX = 0;
    protected static final int REMOTE_CTX = 1;
    protected static final int LOCAL_CTX = 2;
    protected static byte[] ia = null;
    protected static UID spaceID = null;

    public static byte[] getInetAddress() {
        if (ia == null) {
            try {
                ia = InetAddress.getLocalHost().getAddress();
            }
            catch (UnknownHostException e) {
                TraceCarol.error("Cannot get the address of localhost", e);
            }
        }
        return ia;
    }

    public static UID getSpaceID() {
        if (spaceID == null) {
            spaceID = new UID();
        }
        return spaceID;
    }

    public static JInterceptorsKind getInterceptorsByType(List<JInterceptorsGroup> jinterceptorsList) {
        ArrayList<JServerRequestInterceptor> sis = new ArrayList<JServerRequestInterceptor>();
        ArrayList<JClientRequestInterceptor> cis = new ArrayList<JClientRequestInterceptor>();
        ArrayList<String> jinitializers = new ArrayList<String>();
        for (JInterceptorsGroup jInterceptors : jinterceptorsList) {
            jinitializers.add(jInterceptors.getInitializer());
            sis.addAll(jInterceptors.getSis());
            cis.addAll(jInterceptors.getCis());
        }
        return new JInterceptorsKind(jinitializers, sis, cis);
    }
}

