/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.archive;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import org.ow2.util.ee.deploy.api.archive.ArchiveFactory;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.ee.deploy.impl.archive.DirectoryArchiveImpl;
import org.ow2.util.ee.deploy.impl.archive.JarArchiveImpl;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArchiveFactory
implements ArchiveFactory<File> {
    private Log logger = LogFactory.getLog(DefaultArchiveFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IArchive create(File file) {
        if (file.isDirectory()) {
            return new DirectoryArchiveImpl(file);
        }
        JarFile jarFile = null;
        jarFile = new JarFile(file);
        if (jarFile == null) return new JarArchiveImpl(file);
        try {
            jarFile.close();
            return new JarArchiveImpl(file);
        }
        catch (IOException e) {
            this.logger.debug("Cannot close the jar file ''{0}''", jarFile);
        }
        return new JarArchiveImpl(file);
        catch (IOException e) {
            IArchive iArchive;
            try {
                this.logger.debug("File ''{0}'' is not a valid Jar File", file);
                iArchive = null;
                if (jarFile == null) return iArchive;
            }
            catch (Throwable throwable) {
                if (jarFile == null) throw throwable;
                try {
                    jarFile.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    this.logger.debug("Cannot close the jar file ''{0}''", jarFile);
                }
                throw throwable;
            }
            try {
                jarFile.close();
                return iArchive;
            }
            catch (IOException e3) {
                this.logger.debug("Cannot close the jar file ''{0}''", jarFile);
            }
            return iArchive;
        }
    }
}

