/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.xml;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ow2.util.xml.DefaultErrorHandler;
import org.ow2.util.xml.DocumentParserException;
import org.ow2.util.xml.EmptyEntityResolver;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DocumentParser {
    private DocumentParser() {
    }

    public static Document getDocument(URL url, boolean isValidating, EntityResolver entityResolver) throws DocumentParserException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(isValidating);
        if (isValidating) {
            factory.setIgnoringElementContentWhitespace(true);
            factory.setAttribute("http://apache.org/xml/features/validation/schema", isValidating);
            factory.setAttribute("http://apache.org/xml/features/validation/schema-full-checking", true);
        }
        if (isValidating) {
            factory.setAttribute("http://apache.org/xml/properties/schema/external-schemaLocation", "http://java.sun.com/xml/ns/persistence http://java.sun.com/xml/ns/persistence/persistence_1_0.xsd");
        }
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new DocumentParserException("Cannot build a document builder", e);
        }
        builder.setErrorHandler(new DefaultErrorHandler());
        if (entityResolver == null) {
            builder.setEntityResolver(new EmptyEntityResolver());
        } else {
            builder.setEntityResolver(entityResolver);
        }
        URLConnection urlConnection = null;
        try {
            urlConnection = url.openConnection();
        }
        catch (IOException e) {
            throw new DocumentParserException("Cannot open a connection on URL '" + url + "'", e);
        }
        urlConnection.setDefaultUseCaches(false);
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(urlConnection.getInputStream());
        }
        catch (IOException e) {
            throw new DocumentParserException("Cannot build an input stream reader on URL '" + url + "'", e);
        }
        InputSource inputSource = new InputSource(reader);
        Document document = null;
        try {
            document = builder.parse(inputSource);
        }
        catch (SAXException e) {
            throw new DocumentParserException("Cannot parse the XML file '" + url + "'.", e);
        }
        catch (IOException e) {
            throw new DocumentParserException("Cannot parse the XML file '" + url + "'.", e);
        }
        finally {
            try {
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new DocumentParserException("Cannot close the inputsource of the XML file'" + url + "'.", e);
            }
        }
        return document;
    }
}

