/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.discovery.jgroups.comm;

import java.io.Serializable;
import java.net.UnknownHostException;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Receiver;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.discovery.base.DuplicateServerNameException;
import org.ow2.jonas.discovery.base.comm.DiscEvent;
import org.ow2.jonas.discovery.base.comm.DiscMessage;
import org.ow2.jonas.discovery.jgroups.comm.api.DiscComm;
import org.ow2.jonas.discovery.jgroups.comm.exception.StopDiscException;
import org.ow2.jonas.discovery.jgroups.comm.handler.DiscCommGreetingHandler;
import org.ow2.jonas.discovery.jgroups.comm.handler.DiscCommHandlerImpl;
import org.ow2.jonas.discovery.jgroups.utils.JGroupsDiscoveryUtils;
import org.ow2.jonas.lib.util.Log;

public class DiscCommManager
implements DiscComm {
    private Channel comChannel = null;
    private Logger logger;
    boolean greetingTimeOutExceeded = false;
    private Address sourceAddr = null;
    private long startTime;
    private DiscCommHandlerImpl discMesssageEventHandler = null;
    private String discoveryType = null;

    public DiscCommManager(String discoveryType) {
        this.discoveryType = discoveryType;
    }

    public void run() {
    }

    public void stop() {
        this.freeMem();
    }

    public void start() throws StopDiscException {
        this.logger = Log.getLogger((String)"org.ow2.jonas.discovery");
        this.comChannel = JGroupsDiscoveryUtils.getInstance().getComChannel();
        if (this.comChannel == null) {
            this.logger.log(BasicLevel.ERROR, (Object)"Bad initialization of JGroupsDiscoveryUtils");
            throw new StopDiscException("Bad initialization of JGroupsDiscoveryUtils");
        }
        this.sourceAddr = this.comChannel.getLocalAddress();
        DiscCommGreetingHandler greetingReceiver = new DiscCommGreetingHandler(this.sourceAddr);
        this.comChannel.setReceiver((Receiver)greetingReceiver);
        try {
            JGroupsDiscoveryUtils.send(null, JGroupsDiscoveryUtils.objectToBytes((Serializable)JGroupsDiscoveryUtils.createDiscGreeting(true)));
        }
        catch (UnknownHostException e1) {
            throw new StopDiscException(e1.getMessage());
        }
        catch (Exception e1) {
            throw new StopDiscException(e1.getMessage());
        }
        try {
            this.receiveGreetingMessage();
        }
        catch (DuplicateServerNameException e) {
            this.freeMem();
            throw new StopDiscException(e.getMessage());
        }
        DiscEvent discEventMsg = null;
        try {
            discEventMsg = this.discoveryType.equals("CLUSTERD") ? JGroupsDiscoveryUtils.createNotifMessageForClusterd("starting up") : JGroupsDiscoveryUtils.createNotifMessage("starting up");
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.ERROR, (Object)"DiscoveryComm:  Unable to create a notification message \n", (Throwable)e);
        }
        if (discEventMsg != null) {
            this.sendNotif(null, (DiscMessage)discEventMsg);
        }
        this.discMesssageEventHandler = new DiscCommHandlerImpl(this.sourceAddr, this.discoveryType);
        this.comChannel.setReceiver((Receiver)this.discMesssageEventHandler);
    }

    private boolean timeOutExceeded() {
        return System.currentTimeMillis() - this.startTime > (long)JGroupsDiscoveryUtils.getInstance().getGreetingAckTimeOut().intValue();
    }

    public void receiveGreetingMessage() throws DuplicateServerNameException {
        this.startTime = System.currentTimeMillis();
        while (!this.timeOutExceeded() && !JGroupsDiscoveryUtils.duplicateExceptionName) {
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                this.logger.log(BasicLevel.ERROR, (Object)("InterruptedException when handling greeting message \n" + e));
            }
        }
        if (JGroupsDiscoveryUtils.duplicateExceptionName) {
            this.logger.log(BasicLevel.DEBUG, (Object)"Duplicate server name exception occurred \n");
            throw new DuplicateServerNameException(JGroupsDiscoveryUtils.getInstance().getServerId(), JGroupsDiscoveryUtils.getInstance().getJonasName(), JGroupsDiscoveryUtils.getInstance().getDomainName());
        }
        this.logger.log(BasicLevel.DEBUG, (Object)"Time out exceeded: no DuplicateNameException \n GO on starting discovery service");
    }

    private void freeMem() {
        if (this.comChannel != null && this.comChannel.isOpen()) {
            this.comChannel.close();
        }
        this.comChannel = null;
        this.logger = null;
        this.sourceAddr = null;
    }

    public void sendNotif(Address dest, DiscMessage msg) {
        try {
            JGroupsDiscoveryUtils.send(dest, JGroupsDiscoveryUtils.objectToBytes((Serializable)msg));
        }
        catch (Exception e) {
            this.logger.log(BasicLevel.ERROR, (Object)e);
        }
    }
}

