/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.discovery.jgroups.manager;

import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.discovery.jgroups.comm.DiscCommManager;
import org.ow2.jonas.discovery.jgroups.comm.api.DiscComm;
import org.ow2.jonas.discovery.jgroups.comm.exception.StopDiscException;
import org.ow2.jonas.lib.util.Log;

public class DiscoveryManager {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.discovery");
    private DiscComm discoveryComm;
    private String discoverType = null;

    public DiscoveryManager(String discoveryType) {
        this.discoverType = discoveryType;
    }

    private void freeMem() {
        this.discoveryComm = null;
    }

    public void stop() {
        logger.log(BasicLevel.DEBUG, (Object)"Stopping discovery manager");
        if (this.discoveryComm != null) {
            this.discoveryComm.stop();
            this.freeMem();
        }
        logger.log(BasicLevel.DEBUG, (Object)"Discovery manager started successfully");
    }

    public void start() throws StopDiscException {
        logger.log(BasicLevel.DEBUG, (Object)"Starting discovery manager");
        this.discoveryComm = new DiscCommManager(this.discoverType);
        try {
            this.discoveryComm.start();
        }
        catch (StopDiscException e) {
            this.freeMem();
            throw e;
        }
        logger.log(BasicLevel.DEBUG, (Object)"Discovery manager stopped successfully");
    }
}

