/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.ant.archive.file;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.ow2.easybeans.ant.archive.api.IClient;
import org.ow2.easybeans.ant.archive.info.ArchiveInfo;
import org.ow2.easybeans.ant.archive.info.ClientInfo;

public class ClientFile
extends Jar
implements IClient {
    private static final String DEPLOYMENT_DESCRIPTOR = "META-INF/application-client.xml";
    private ClientInfo clientInfo = null;
    private ArchiveInfo archiveInfo = null;

    public ClientFile(Project p) {
        this.setProject(p);
    }

    public void setArchiveInfo(ArchiveInfo archiveInfo) {
        this.archiveInfo = archiveInfo;
    }

    public void setClientInfo(ClientInfo clientInfo) {
        this.setArchiveInfo(clientInfo);
        this.clientInfo = clientInfo;
    }

    public void execute() {
        String mainClass;
        if (this.archiveInfo.getDd() != null) {
            this.setDD(this.archiveInfo.getDd());
        }
        if ((mainClass = this.clientInfo.getMainClass()) != null) {
            Manifest mf = new Manifest();
            Manifest.Attribute attribute = new Manifest.Attribute();
            attribute.setName("Main-Class");
            attribute.setValue(mainClass);
            try {
                mf.addConfiguredAttribute(attribute);
            }
            catch (ManifestException e) {
                throw new BuildException("Cannot add the Main-Class attribute in the manifest", (Throwable)e);
            }
            try {
                this.addConfiguredManifest(mf);
            }
            catch (ManifestException e) {
                throw new BuildException("Cannot add the manifest", (Throwable)e);
            }
        }
        this.setDestFile(this.archiveInfo.getDest());
        for (FileSet fileSet : this.archiveInfo.getFileSetList()) {
            this.addFileset(fileSet);
        }
        super.execute();
    }

    public void setDD(File dd) {
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setFile(dd);
        zipFileSet.setFullpath(DEPLOYMENT_DESCRIPTOR);
        this.addFileset((FileSet)zipFileSet);
    }
}

