/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.ant.archive.file;

import java.io.File;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.ow2.easybeans.ant.archive.api.IEjb;
import org.ow2.easybeans.ant.archive.info.ArchiveInfo;
import org.ow2.easybeans.ant.archive.info.EjbInfo;

public class EjbFile
extends Jar
implements IEjb {
    private static final String DEPLOYMENT_DESCRIPTOR = "META-INF/ejb-jar.xml";
    private static final String PERSISTENCE_DEPLOYMENT_DESCRIPTOR = "META-INF/persistence.xml";
    private ArchiveInfo archiveInfo = null;

    public EjbFile(Project p) {
        this.setProject(p);
    }

    public void setArchiveInfo(ArchiveInfo archiveInfo) {
        this.archiveInfo = archiveInfo;
    }

    public void setEjbInfo(EjbInfo ejbInfo) {
        this.setArchiveInfo(ejbInfo);
    }

    public void execute() {
        if (this.archiveInfo.getDd() != null) {
            this.setDD(this.archiveInfo.getDd());
        }
        if (this.archiveInfo.getPersistenceDD() != null) {
            this.setPersistenceDD(this.archiveInfo.getPersistenceDD());
        }
        this.setDestFile(this.archiveInfo.getDest());
        for (FileSet fileSet : this.archiveInfo.getFileSetList()) {
            this.addFileset(fileSet);
        }
        super.execute();
    }

    public void setDD(File dd) {
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setFile(dd);
        zipFileSet.setFullpath(DEPLOYMENT_DESCRIPTOR);
        this.addFileset((FileSet)zipFileSet);
    }

    public void setPersistenceDD(File persistenceDD) {
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setFile(persistenceDD);
        zipFileSet.setFullpath(PERSISTENCE_DEPLOYMENT_DESCRIPTOR);
        this.addFileset((FileSet)zipFileSet);
    }
}

