/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant;

import java.io.File;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;

public class WsGenTask
extends MatchingTask {
    private static final String BOOTSTRAP_CLASS = "org.ow2.jonas.lib.bootstrap.Bootstrap";
    private static final String WSGEN_CLASS = "org.ow2.jonas.generators.wsgen.WsGen";
    private File destination = null;
    private File source = null;
    private boolean validation = true;
    private String javac = null;
    private String javacOpts = null;
    private boolean keepGenerated = false;
    private boolean noConfig = false;
    private boolean verbose = false;
    private boolean debug = false;
    private boolean jvmDebug = false;
    private File jonasRoot = null;
    private File jonasBase = null;

    public void setDestdir(File d) {
        this.destination = d;
    }

    public void setSrcdir(File s) {
        this.source = s;
    }

    public void setValidation(boolean v) {
        this.validation = v;
    }

    public void setJavac(String j) {
        this.javac = j;
    }

    public void setJavacopts(String opts) {
        this.javacOpts = opts;
    }

    public void setKeepgen(boolean k) {
        this.keepGenerated = k;
    }

    public void setNoconfig(boolean c) {
        this.noConfig = c;
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    public void setJvmdebug(boolean d) {
        this.jvmDebug = d;
    }

    public void setJonasroot(File jr) {
        this.jonasRoot = jr;
    }

    public void setJonasbase(File jb) {
        this.jonasBase = jb;
    }

    public void execute() throws BuildException {
        this.initWsGenTask();
        DirectoryScanner ds = this.getDirectoryScanner(this.source);
        ds.scan();
        String[] files = ds.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            Java wsgen = this.createWsGen(this.source + File.separator + files[i]);
            this.log("Calling  WsGen task for '" + this.source + File.separator + files[i] + "'.", 3);
            if (wsgen.executeJava() == 0) continue;
            throw new BuildException("WsGen reported an error.");
        }
    }

    private Java createWsGen(String filename) throws BuildException {
        Java wsgenTask = null;
        wsgenTask = (Java)this.getProject().createTask("java");
        wsgenTask.setTaskName("wsgen");
        wsgenTask.setFork(true);
        wsgenTask.createJvmarg().setValue("-Dinstall.root=" + this.jonasRoot);
        wsgenTask.createJvmarg().setValue("-Djonas.base=" + this.jonasBase);
        File endorsedDir = new File(new File(this.jonasRoot, "lib"), "endorsed");
        wsgenTask.createJvmarg().setValue("-Djava.endorsed.dirs=" + endorsedDir);
        String jonasConfigDir = this.jonasRoot + File.separator + "conf";
        File javaPolicyFile = new File(jonasConfigDir, "java.policy");
        if (javaPolicyFile.exists()) {
            wsgenTask.createJvmarg().setValue("-Djava.security.policy=" + javaPolicyFile.toString());
        }
        if (this.jvmDebug) {
            this.log("Launching in debug mode on port 12345, waiting for connection ...", 2);
            wsgenTask.createJvmarg().setLine("-Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,address=12345,suspend=y");
        }
        wsgenTask.createArg().setValue(WSGEN_CLASS);
        wsgenTask.createArg().setValue("-d");
        wsgenTask.createArg().setFile(this.destination);
        String bootJar = this.jonasRoot + File.separator + "lib" + File.separator + "common" + File.separator + "ow_jonas_bootstrap.jar";
        Path classpath = new Path(this.getProject(), bootJar);
        this.log("Using classpath: " + classpath.toString(), 3);
        wsgenTask.setClasspath(classpath);
        if (!this.checkBootstrapClassName(classpath)) {
            this.log("Cannot find bootstrap class in classpath.", 0);
            throw new BuildException("Bootstrap class not found, please check the classpath.");
        }
        wsgenTask.setClassname(BOOTSTRAP_CLASS);
        if (this.keepGenerated) {
            wsgenTask.createArg().setValue("-keepgenerated");
        }
        if (this.noConfig) {
            wsgenTask.createArg().setValue("-noconfig");
        }
        if (!this.validation) {
            wsgenTask.createArg().setValue("-novalidation");
        }
        if (this.javac != null) {
            wsgenTask.createArg().setValue("-javac");
            wsgenTask.createArg().setLine(this.javac);
        }
        if (this.javacOpts != null && !this.javacOpts.equals("")) {
            wsgenTask.createArg().setValue("-javacopts");
            wsgenTask.createArg().setLine(this.javacOpts);
        }
        if (this.verbose) {
            wsgenTask.createArg().setValue("-verbose");
        }
        if (this.debug) {
            wsgenTask.createArg().setValue("-debug");
        }
        wsgenTask.createArg().setValue(filename);
        return wsgenTask;
    }

    private void initWsGenTask() throws BuildException {
        if (this.jonasRoot == null) {
            String jr = this.getProject().getProperty("jonas.root");
            this.jonasRoot = new File(jr);
            if (jr == null) {
                throw new BuildException("attribute jonasroot is necessary.");
            }
        }
        if (this.jonasBase == null) {
            String jb = this.getProject().getProperty("jonas.base");
            this.jonasBase = jb == null ? this.jonasRoot : new File(jb);
        }
        if (this.destination == null) {
            this.destination = this.getProject().getBaseDir();
        }
    }

    private boolean checkBootstrapClassName(Path classpath) {
        this.log("Looking for bootstrap class in classpath: " + classpath.toString(), 3);
        AntClassLoader cl = new AntClassLoader(classpath.getProject(), classpath);
        try {
            cl.loadClass(BOOTSTRAP_CLASS);
            this.log("Found Bootstrap class 'org.ow2.jonas.lib.bootstrap.Bootstrap' in classpath.", 3);
        }
        catch (ClassNotFoundException cnf1) {
            this.log("Bootstrap class 'org.ow2.jonas.lib.bootstrap.Bootstrap' not found in classpath.", 3);
            return false;
        }
        return true;
    }
}

