/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.jorm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.ejb.EJBException;
import org.objectweb.jorm.api.PAccessor;
import org.objectweb.jorm.api.PBinding;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PExceptionProtocol;
import org.objectweb.jorm.api.PGenClassAccessor;
import org.objectweb.jorm.api.PIndexedElem;
import org.objectweb.jorm.naming.api.PBinder;
import org.objectweb.jorm.naming.api.PExceptionNaming;
import org.objectweb.jorm.naming.api.PName;
import org.objectweb.jorm.naming.api.PNameManager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.ejb21.JEntityContext;
import org.ow2.jonas.lib.ejb21.JEntityFactory;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.ejb21.jorm.GenClassElement;
import org.ow2.jonas.lib.ejb21.jorm.GenClassListener;
import org.ow2.jonas.lib.ejb21.jorm.PObject;
import org.ow2.jonas.lib.ejb21.jorm.PObjectHome;

public abstract class GenClassImpl
implements PGenClassAccessor {
    protected ArrayList pIndexedElems = new ArrayList(0);
    protected int[] deletedLength = new int[0];
    protected int size = 0;
    protected boolean isModified = false;
    protected boolean selectForUpdate = false;
    protected PClassMapping gcm = null;
    protected JEntityContext ectx = null;
    protected PBinding pb = null;
    protected GenClassListener listener = null;

    public void setPClassMapping(PClassMapping gcm) {
        this.gcm = gcm;
    }

    public void setEntityContext(JEntityContext ectx) {
        this.ectx = ectx;
        this.selectForUpdate = ectx.getEntityFactory().getSelectForUpdate();
    }

    public void reset() {
        this.pIndexedElems.clear();
        this.size = 0;
        this.deletedLength = new int[0];
        this.isModified = false;
    }

    public void setPBinding(PBinding pb) {
        this.pb = pb;
    }

    public PBinding gcGetPBinding() {
        return this.pb;
    }

    public void setListener(GenClassListener gcl) {
        this.listener = gcl;
    }

    public GenClassListener getListener() {
        return this.listener;
    }

    public boolean gcIsModified() {
        return this.isModified;
    }

    public void read(PName pn, Object connection, Object tx) throws PException {
        Object conn;
        if (pn == null || pn.isNull()) {
            TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)"null pn");
            this.reset();
            return;
        }
        if (this.pb == null) {
            throw new PExceptionProtocol("Impossible to read a persitent object withoout PBinding");
        }
        if (TraceEjb.genclass.isLoggable(BasicLevel.DEBUG)) {
            TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)("PName=" + pn));
        }
        Object object = conn = connection == null ? this.gcm.getPMapper().getConnection() : connection;
        if (TraceEjb.genclass.isLoggable(BasicLevel.DEBUG)) {
            TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)"Load the genclass");
        }
        this.pb.bind(pn);
        this.pb.read(conn, (PAccessor)this, tx, this.selectForUpdate);
        this.isModified = false;
        if (connection == null) {
            this.gcm.getPMapper().closeConnection(conn);
        }
    }

    public void write(PName pn, Object connection) throws PException {
        if (pn == null || pn.isNull()) {
            throw new PExceptionProtocol("Impossible to write a persitent object with a null PName: " + pn);
        }
        if (TraceEjb.genclass.isLoggable(BasicLevel.DEBUG)) {
            TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.isModified) {
            Object conn;
            Object object = conn = connection == null ? this.gcm.getPMapper().getConnection() : connection;
            if (this.pb == null) {
                throw new PExceptionProtocol("Impossible to write a persitent object without PBinding");
            }
            if (TraceEjb.genclass.isLoggable(BasicLevel.DEBUG)) {
                TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)("Store the genclass " + pn));
            }
            this.pb.bind(pn);
            this.pb.write(conn, (PAccessor)this);
            this.isModified = false;
            int pos = 0;
            for (int i = 0; i < this.deletedLength.length; ++i) {
                this.pIndexedElems.remove(pos += this.deletedLength[i]);
            }
            this.deletedLength = new int[0];
            for (GenClassElement gce : this.pIndexedElems) {
                gce.status = (byte)4;
                gce.hasBeenCreated = false;
            }
            if (connection == null) {
                this.gcm.getPMapper().closeConnection(conn);
            }
        }
    }

    public Object getMemoryInstance() {
        return this;
    }

    public void paAdd(PIndexedElem elem, Object conn) throws PException {
        this.pIndexedElems.add(elem);
        ++this.size;
    }

    public PIndexedElem createPIndexedElem() {
        return new GenClassElement(this);
    }

    public boolean paDeltaSupported() {
        return true;
    }

    public int paGetNbElem() {
        return this.pIndexedElems.size();
    }

    public Iterator paIterator() {
        return this.pIndexedElems.iterator();
    }

    public void paSetNbElem(int nbelem) {
        if (TraceEjb.genclass.isLoggable(BasicLevel.DEBUG)) {
            TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)("nbElem: " + nbelem));
        }
        if (nbelem == -1) {
            this.pIndexedElems.clear();
        } else {
            this.pIndexedElems = new ArrayList(nbelem);
        }
        this.deletedLength = new int[0];
        this.size = 0;
    }

    protected int gcGetRealIndex(int idx) {
        int i;
        int a = idx;
        for (i = 0; i < this.deletedLength.length && (a -= this.deletedLength[i]) >= 0; ++i) {
        }
        return idx + i;
    }

    protected void gcAdd(PObject element, boolean callListener) {
        int i;
        int pos = 0;
        GenClassElement gce = null;
        this.ectx.setDirty(true);
        for (i = 0; i < this.deletedLength.length; ++i) {
            gce = (GenClassElement)this.pIndexedElems.get(pos += this.deletedLength[i]);
            if (gce.value == element) break;
            ++pos;
        }
        if (i < this.deletedLength.length) {
            if (gce.hasBeenCreated) {
                throw new EJBException("Internal error state: A deleted element has not been created");
            }
            if (TraceEjb.genclass.isLoggable(BasicLevel.DEBUG)) {
                TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)("The element added was previously removed. i: " + i + "gce.pname: " + gce.pname));
            }
            gce.status = (byte)4;
            if (this.deletedLength.length == 1) {
                this.deletedLength = new int[0];
            } else {
                int[] old = this.deletedLength;
                this.deletedLength = new int[this.deletedLength.length - 1];
                System.arraycopy(old, 0, this.deletedLength, 0, i);
                if (i < this.deletedLength.length) {
                    System.arraycopy(old, i + 1, this.deletedLength, i, old.length - 1 - i);
                    int n = i;
                    this.deletedLength[n] = this.deletedLength[n] + (old[i] + 1);
                }
            }
        } else {
            if (TraceEjb.genclass.isLoggable(BasicLevel.DEBUG)) {
                try {
                    TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)("Add the element '" + element.getPName().encodeString()));
                }
                catch (PExceptionNaming pExceptionNaming) {
                    // empty catch block
                }
            }
            gce = (GenClassElement)this.createPIndexedElem();
            gce.value = element;
            gce.status = 1;
            gce.hasBeenCreated = true;
            this.listener.isLegalElement(gce);
            this.pIndexedElems.add(gce);
        }
        this.isModified = true;
        ++this.size;
        if (callListener) {
            if (gce == null) {
                TraceEjb.genclass.log(BasicLevel.ERROR, (Object)"null gce");
                return;
            }
            this.listener.gcAdd(gce);
        }
    }

    protected Object gcRemove(Object element, boolean callListener) throws PException {
        int a;
        GenClassElement gce = null;
        boolean found = false;
        int b = 0;
        int i = 0;
        for (a = 0; a < this.pIndexedElems.size() && !found; ++a) {
            gce = (GenClassElement)this.pIndexedElems.get(a);
            if (gce.status == 2) {
                ++i;
                b = 0;
                continue;
            }
            ++b;
            if (gce.pname != null && gce.value == null) {
                gce.value = this.gcDeref(gce.pname);
            }
            found = element == null && gce.value == null || element != null && element.equals(gce.value);
        }
        if (!found) {
            if (TraceEjb.genclass.isLoggable(BasicLevel.DEBUG)) {
                TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)"Nothing to remove");
            }
            return null;
        }
        this.ectx.setDirty(true);
        if (callListener) {
            this.listener.gcRemove(gce, false);
        }
        if (gce.hasBeenCreated) {
            if (TraceEjb.genclass.isLoggable(BasicLevel.DEBUG)) {
                TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)"Remove permanantly the element");
            }
            this.pIndexedElems.remove(a - 1);
            if (i < this.deletedLength.length) {
                int n = i;
                this.deletedLength[n] = this.deletedLength[n] - 1;
            }
        } else {
            gce.status = (byte)2;
            if (TraceEjb.genclass.isLoggable(BasicLevel.DEBUG)) {
                TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)("Add the entry in the deletedLength array: i:" + i + " / b:" + b + ")"));
            }
            int[] old = this.deletedLength;
            this.deletedLength = new int[old.length + 1];
            System.arraycopy(old, 0, this.deletedLength, 0, i);
            this.deletedLength[i] = b - 1;
            if (i < old.length) {
                this.deletedLength[i + 1] = old[i] - b;
                System.arraycopy(old, i + 1, this.deletedLength, i + 2, old.length - i - 1);
            }
        }
        this.isModified = true;
        --this.size;
        return gce.value;
    }

    private static String toString(int[] t) {
        StringBuffer sb = new StringBuffer("[");
        int i = 0;
        while (i < t.length) {
            sb.append(t[i]);
            if (++i >= t.length) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    public int gcGetSize() {
        return this.size;
    }

    protected boolean gcContains(PObject element, Object connection) throws PException {
        Object conn = connection == null ? this.gcm.getPMapper().getConnection() : connection;
        boolean result = false;
        Iterator it = this.gcIterator(conn);
        while (!result && it.hasNext()) {
            Object o = it.next();
            result = element == null && o == null || element != null && element.equals(o);
        }
        if (connection == null) {
            this.gcm.getPMapper().closeConnection(conn);
        }
        if (TraceEjb.genclass.isLoggable(BasicLevel.DEBUG)) {
            try {
                TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)("Looking for the element '" + element.getPName().encodeString() + ". return " + result));
            }
            catch (PExceptionNaming pExceptionNaming) {
                // empty catch block
            }
        }
        return result;
    }

    protected Iterator gcIterator() throws PException {
        return this.gcIterator(null);
    }

    protected Iterator gcIterator(Object connection) throws PException {
        return new ElementIterator(this, connection);
    }

    protected PObject gcGetElement(GenClassElement gce, Object connection) throws PException {
        if (gce.pname != null && gce.value == null) {
            if (gce.pname == null || gce.pname.isNull()) {
                return null;
            }
            PName current = gce.pname;
            Object conn = connection == null ? this.gcm.getPMapper().getConnection() : connection;
            PName res = current.resolve(conn);
            while (res != null && res instanceof PName && !res.equals(current)) {
                current = res;
                res = current.resolve(conn);
            }
            if (connection == null) {
                this.gcm.getPMapper().closeConnection(conn);
            }
            gce.value = this.gcDeref(current);
        }
        return gce.value;
    }

    public void gcClear(boolean delete) {
        if (TraceEjb.genclass.isLoggable(BasicLevel.DEBUG)) {
            TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)"Clear the gc");
        }
        for (GenClassElement gce : this.pIndexedElems) {
            if (gce.status == 2) continue;
            if (gce.pname != null && gce.value == null) {
                gce.value = this.gcDeref(gce.pname);
            }
            if (TraceEjb.genclass.isLoggable(BasicLevel.DEBUG)) {
                TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)"listener.gcRemove");
            }
            this.listener.gcRemove(gce, delete);
        }
        Iterator it = this.pIndexedElems.iterator();
        while (it.hasNext()) {
            GenClassElement gce;
            gce = (GenClassElement)it.next();
            if (gce.status == 2) continue;
            gce.status = (byte)2;
            if (!gce.hasBeenCreated) continue;
            if (TraceEjb.genclass.isLoggable(BasicLevel.DEBUG)) {
                TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)"Clear permanantly an element");
            }
            it.remove();
        }
        this.size = 0;
        this.isModified = true;
        this.ectx.setDirty(true);
        this.deletedLength = new int[this.pIndexedElems.size()];
        Arrays.fill(this.deletedLength, 0);
    }

    protected PObject gcDeref(PName pn) {
        JEntityFactory f = (JEntityFactory)((PBinder)pn.getPNameManager()).getBinderClassMapping();
        if (f.getLocalHome() != null) {
            return ((PObjectHome)((Object)f.getLocalHome())).getPObject(pn);
        }
        return ((PObjectHome)((Object)f.getHome())).getPObject(pn);
    }

    protected PName gcObject2ref(PObject value) throws PException {
        if (value != null) {
            Object conn = this.gcm.getPMapper().getConnection();
            PNameManager pnm = (PNameManager)this.gcm.getPNameCoder();
            PName pn = pnm.export(conn, (Object)value.getPName(), null);
            this.gcm.getPMapper().closeConnection(conn);
            return pn;
        }
        return this.gcm.getPNameCoder().getNull();
    }

    public void printState() {
        if (!TraceEjb.genclass.isLoggable(BasicLevel.DEBUG)) {
            return;
        }
        TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)("deletedLength: " + GenClassImpl.toString(this.deletedLength)));
        TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)("pIndexedElems.size():" + this.pIndexedElems.size()));
        TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)("isModified: " + this.isModified));
        TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)("size:" + this.size));
        int i = 0;
        for (GenClassElement gce : this.pIndexedElems) {
            TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)("GCE:" + i + " / status:" + gce.status + " / hasBeenCreated:" + gce.hasBeenCreated));
            TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)("- pname:" + gce.pname));
            TraceEjb.genclass.log(BasicLevel.DEBUG, (Object)("- value:" + gce.value));
            ++i;
        }
    }

    protected class ElementIterator
    implements Iterator {
        private int cursor = 0;
        private int next = 0;
        private GenClassImpl gc;
        private Object conn;

        public ElementIterator(GenClassImpl gc, Object connection) {
            this.gc = gc;
            this.conn = connection;
            this.reset();
        }

        public void reset() {
            this.cursor = -1;
            this.next = this.nextExist(this.cursor);
        }

        private int nextExist(int pos) {
            for (int tmp = pos + 1; tmp < GenClassImpl.this.pIndexedElems.size(); ++tmp) {
                GenClassElement gce = (GenClassElement)GenClassImpl.this.pIndexedElems.get(tmp);
                if (gce == null) {
                    TraceEjb.genclass.log(BasicLevel.ERROR, (Object)"null GenClassElement");
                    return -1;
                }
                if (gce.status == 2) continue;
                return tmp;
            }
            return -1;
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public Object next() {
            if (this.next == -1) {
                throw new NoSuchElementException();
            }
            this.cursor = this.next;
            try {
                GenClassElement gce = (GenClassElement)GenClassImpl.this.pIndexedElems.get(this.cursor);
                this.gc.gcGetElement(gce, this.conn);
                this.next = this.nextExist(this.cursor);
                return gce.value;
            }
            catch (PException e) {
                this.next = -1;
                TraceEjb.genclass.log(BasicLevel.ERROR, (Object)"Impossible to obtain value:", (Throwable)e);
                throw new NoSuchElementException("Impossible to obtain value:" + (Object)((Object)e));
            }
        }

        public void remove() {
            try {
                GenClassImpl.this.gcRemove(((GenClassElement)GenClassImpl.this.pIndexedElems.get((int)this.cursor)).value, true);
            }
            catch (PException e) {
                throw new UnsupportedOperationException(e.getMessage());
            }
        }
    }
}

