/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.jorm;

import java.io.Serializable;
import java.util.Iterator;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import org.objectweb.jorm.api.PBinding;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PClassMappingCtrl;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PMapCluster;
import org.objectweb.jorm.api.PMapper;
import org.objectweb.jorm.api.PMappingCallback;
import org.objectweb.jorm.facility.naming.basidir.BasidBinder;
import org.objectweb.jorm.naming.api.PBinder;
import org.objectweb.jorm.naming.api.PExceptionNaming;
import org.objectweb.jorm.naming.api.PName;
import org.objectweb.jorm.naming.api.PNameCoder;
import org.objectweb.jorm.naming.api.PNamingContext;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.ejb.EjbRelationshipRoleDesc;
import org.ow2.jonas.deployment.ejb.EntityCmp2Desc;
import org.ow2.jonas.deployment.ejb.EntityDesc;
import org.ow2.jonas.lib.ejb21.JContainer;
import org.ow2.jonas.lib.ejb21.JEntityFactory;
import org.ow2.jonas.lib.ejb21.JEntitySwitch;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.ejb21.jorm.JEntityContext;
import org.ow2.jonas.lib.ejb21.jorm.JormType;

public abstract class JormFactory
extends JEntityFactory
implements PClassMapping,
PClassMappingCtrl {
    protected int relNonInit;
    protected boolean mapped;
    protected PMapper mapper = null;
    protected EntityCmp2Desc ecd = null;
    private Class bindingClass = null;

    protected abstract void setMapper(String var1) throws PException;

    public abstract Object getConnection(Object var1) throws PException;

    public abstract void releaseConnection(Object var1) throws PException;

    public void init(EntityDesc ed, JContainer c, String mapperName) {
        if (TraceEjb.isDebugFactory()) {
            TraceEjb.factory.log(BasicLevel.DEBUG, (Object)ed.getEjbName());
        }
        super.init(ed, c);
        this.ecd = (EntityCmp2Desc)ed;
        try {
            this.setMapper(mapperName);
        }
        catch (PException e) {
            throw new EJBException("JormFactory cannot create the mapper " + mapperName, (Exception)((Object)e));
        }
        if (TraceEjb.isDebugFactory()) {
            TraceEjb.factory.log(BasicLevel.DEBUG, (Object)"Jorm initialisation");
        }
        PBinder binder = null;
        Class<?> binderClass = null;
        short binderCT = 0;
        try {
            binderClass = c.getClassLoader().loadClass(this.ecd.getJormBinderClassName());
            binder = (PBinder)binderClass.newInstance();
            if (this.ecd.hasPrimaryKeyField()) {
                binderCT = JormType.getCodingType(this.ecd.getCmpFieldDesc(this.ecd.getPrimaryKeyFieldName()).getFieldType(), true);
                ((BasidBinder)binder).setCodingType((int)binderCT);
            }
            if (TraceEjb.isDebugFactory()) {
                TraceEjb.factory.log(BasicLevel.DEBUG, (Object)("binder " + this.ecd.getJormBinderClassName() + "instanciated"));
            }
            binder.setPClassMapping((PClassMapping)this);
            this.setPBinder(binder);
            this.setClassPNameCoder((PNameCoder)binder);
            if (TraceEjb.isDebugFactory()) {
                TraceEjb.factory.log(BasicLevel.DEBUG, (Object)"binder linked to the mapping");
            }
        }
        catch (Exception e) {
            TraceEjb.factory.log(BasicLevel.ERROR, (Object)"Impossible to create the binder", (Throwable)e);
            throw new EJBException("Impossible to create the binder: bean:" + this.ecd.getEjbName(), e);
        }
        this.relNonInit = 0;
        try {
            Iterator it = this.ecd.getEjbRelationshipRoleDescIterator();
            while (it.hasNext()) {
                String target;
                JormFactory pcm2;
                EjbRelationshipRoleDesc rsr = (EjbRelationshipRoleDesc)it.next();
                String source = rsr.getSourceBean().getEjbName();
                JormFactory jormFactory = pcm2 = source.equals(target = rsr.getTargetBean().getEjbName()) ? this : (JormFactory)c.getBeanFactory(target);
                if (TraceEjb.isDebugFactory()) {
                    TraceEjb.factory.log(BasicLevel.DEBUG, (Object)("treatement of the relation " + rsr.getRelation().getName() + ": current-bean=" + this.ecd.getEjbName() + ", source-bean=" + source + ", dest-bean=" + target + ", cmr-field=" + rsr.getCmrFieldName()));
                }
                if (rsr.hasCmrField()) {
                    PClassMapping gcm = null;
                    if (rsr.isTargetMultiple()) {
                        gcm = this.newGCMInstance(mapperName);
                        gcm.init((PMappingCallback)this.mapper, null);
                        this.setGenClassMapping(rsr.getCmrFieldName(), gcm);
                        if (TraceEjb.isDebugFactory()) {
                            TraceEjb.factory.log(BasicLevel.DEBUG, (Object)("assign a GenClassMapping for the CMR " + rsr.getCmrFieldName() + " / gcm=" + gcm));
                        }
                        PBinder gcmBinder = null;
                        try {
                            gcmBinder = (PBinder)binderClass.newInstance();
                        }
                        catch (Exception e) {
                            TraceEjb.factory.log(BasicLevel.ERROR, (Object)("Impossible to create the binder of the GCM bean: " + this.ecd.getEjbName() + " / CMR: " + rsr.getCmrFieldName()), (Throwable)e);
                            throw new EJBException("Impossible to create the binder of the GCM bean: " + this.ecd.getEjbName() + " / CMR: " + rsr.getCmrFieldName(), e);
                        }
                        if (this.ecd.hasPrimaryKeyField()) {
                            ((BasidBinder)gcmBinder).setCodingType((int)binderCT);
                        }
                        gcm.setPBinder(gcmBinder);
                        gcmBinder.setPClassMapping(gcm);
                        this.setPNameCoder(rsr.getCmrFieldName(), (PNameCoder)gcmBinder);
                    }
                    if (pcm2 != null) {
                        if (TraceEjb.isDebugFactory()) {
                            TraceEjb.factory.log(BasicLevel.DEBUG, (Object)"Pnc Assignement");
                        }
                        if (rsr.isTargetMultiple()) {
                            ((PClassMappingCtrl)gcm).setPNameCoder((PNameCoder)pcm2.getPBinder());
                        } else {
                            this.setPNameCoder(rsr.getCmrFieldName(), (PNameCoder)pcm2.getPBinder());
                        }
                        if (pcm2.isPrefetch()) {
                            this.initGenClassPrefetch(gcm, pcm2);
                        }
                    } else {
                        ++this.relNonInit;
                        if (TraceEjb.isDebugFactory()) {
                            TraceEjb.factory.log(BasicLevel.DEBUG, (Object)("the Pnc is not reachable currently. relNonInit=" + this.relNonInit));
                        }
                    }
                }
                EjbRelationshipRoleDesc rsr2 = rsr.getOppositeRelationshipRole();
                if (pcm2 == null || !rsr2.hasCmrField() || pcm2 == this) continue;
                if (TraceEjb.isDebugFactory()) {
                    TraceEjb.factory.log(BasicLevel.DEBUG, (Object)("later Pnc assignement of the opposite CMR field: " + rsr2.getCmrFieldName()));
                }
                pcm2.configurePnc(rsr2.getCmrFieldName(), (PNamingContext)this.getPBinder(), this, rsr2.isTargetMultiple());
            }
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            TraceEjb.factory.log(BasicLevel.ERROR, (Object)"Impossible to assign the naming context to the PClassMapping", (Throwable)e);
            throw new EJBException("Impossible to assign the naming context to the PClassMapping", e);
        }
        this.mapped = false;
        if (this.relNonInit == 0) {
            this.mapClass();
        }
        String cn = ((EntityCmp2Desc)this.dd).getJormBindingClassName();
        try {
            this.bindingClass = this.getContainer().getClassLoader().loadClass(cn);
        }
        catch (ClassNotFoundException e) {
            String err = "Impossible to load binding class '" + cn + "'.";
            TraceEjb.factory.log(BasicLevel.ERROR, (Object)err, (Throwable)e);
            throw new EJBException(err, (Exception)e);
        }
    }

    public PMapper getMapper() {
        return this.mapper;
    }

    public void configurePnc(String n, PNamingContext pnc, JormFactory target, boolean isMultiple) throws PException {
        if (isMultiple) {
            PClassMappingCtrl gcm = (PClassMappingCtrl)this.getGenClassMapping(n);
            gcm.setPNameCoder((PNameCoder)pnc);
            if (target.isPrefetch()) {
                this.initGenClassPrefetch((PClassMapping)gcm, target);
            }
        } else {
            this.setPNameCoder(n, (PNameCoder)pnc);
        }
        --this.relNonInit;
        if (TraceEjb.isDebugFactory()) {
            TraceEjb.factory.log(BasicLevel.DEBUG, (Object)("PNamingContext assigned, relNonInit=" + this.relNonInit));
        }
        if (this.relNonInit == 0) {
            this.mapClass();
        }
    }

    private void mapClass() {
        if (this.mapped) {
            throw new EJBException("The class is already mapped");
        }
        try {
            this.mapper.map((PClassMapping)this);
            PMapCluster pmapclust = this.mapper.getPMapCluster(this.getClassName());
            if (pmapclust.isDefined()) {
                switch (this.ecd.getCleanupPolicy()) {
                    case 2: {
                        pmapclust.createMappingStructures(false);
                        pmapclust.deleteData();
                        break;
                    }
                    case 3: {
                        pmapclust.deleteMappingStructures();
                        pmapclust.createMappingStructures(true);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 1: {
                        pmapclust.createMappingStructures(false);
                        break;
                    }
                    default: {
                        throw new EJBException("Unknown cleanup policy: " + this.ecd.getCleanupPolicy());
                    }
                }
            }
            this.mapped = true;
            if (TraceEjb.isDebugFactory()) {
                TraceEjb.factory.log(BasicLevel.DEBUG, (Object)(this.getClassName() + " is mapped"));
            }
        }
        catch (PException pe) {
            Throwable e = pe;
            while (e instanceof PException && e.getNestedException() != null) {
                e = e.getNestedException();
            }
            TraceEjb.factory.log(BasicLevel.ERROR, (Object)"Impossible to map the class on the rdb mapper", e);
            throw new EJBException("Impossible to map the class on the rdb mapper", (Exception)e);
        }
    }

    public void stop() {
        super.stop();
        try {
            this.mapper.unmap(this.getClassName());
            this.mapped = false;
        }
        catch (PException e) {
            TraceEjb.factory.log(BasicLevel.ERROR, (Object)("Impossible to unmap the class " + this.getClassName()), (Throwable)e);
        }
    }

    protected org.ow2.jonas.lib.ejb21.JEntityContext createNewContext(EntityBean bean) {
        return new JEntityContext(this, bean);
    }

    public JEntitySwitch getJEntitySwitch() {
        Object result = null;
        try {
            result = this.bindingClass.newInstance();
        }
        catch (Exception e) {
            TraceEjb.factory.log(BasicLevel.ERROR, (Object)("Impossible to create a new JEntitySwitch as specified in BeanNaming: " + this.bindingClass.getName()), (Throwable)e);
            return super.getJEntitySwitch();
        }
        try {
            ((PBinding)result).init((PClassMapping)this);
        }
        catch (PException e) {
            TraceEjb.factory.log(BasicLevel.ERROR, (Object)("Impossible to initialized the new JEntitySwitch as specified in BeanNaming: " + this.bindingClass.getName()), (Throwable)e);
        }
        return result;
    }

    protected PClassMapping newGCMInstance(String mapperName) throws Exception {
        int idx = mapperName.indexOf(".");
        String mn = idx != -1 ? mapperName.substring(0, idx) : mapperName;
        return (PClassMapping)Class.forName("org.objectweb.jorm.mapper." + mn + ".genclass." + Character.toUpperCase(mn.charAt(0)) + mn.substring(1, mn.length()) + "GenClassMapping").newInstance();
    }

    public Serializable encodePK(Serializable pk) {
        try {
            return ((PName)pk).encodeString();
        }
        catch (PExceptionNaming e) {
            TraceEjb.factory.log(BasicLevel.ERROR, (Object)("impossible to serialize PK" + (Object)((Object)e)));
            return pk;
        }
    }

    public Serializable decodePK(Serializable strpk) {
        try {
            return this.getPBinder().decodeString((String)((Object)strpk));
        }
        catch (PExceptionNaming e) {
            TraceEjb.factory.log(BasicLevel.ERROR, (Object)("impossible to deserialize PK" + (Object)((Object)e)));
            return strpk;
        }
    }

    protected abstract void initGenClassPrefetch(PClassMapping var1, PClassMapping var2);
}

