/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.sql;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.jorm.lib.ClassExtent;
import org.objectweb.medor.query.jorm.lib.PNameField;
import org.objectweb.medor.query.jorm.lib.QueryBuilder;
import org.objectweb.medor.query.lib.QueryTreePrinter;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.ejb.DeploymentDescEjb2;
import org.ow2.jonas.deployment.ejb.ejbql.ASTAbstractSchemaName;
import org.ow2.jonas.deployment.ejb.ejbql.ASTAggregateSelectExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTArithmeticExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTArithmeticFactor;
import org.ow2.jonas.deployment.ejb.ejbql.ASTArithmeticTerm;
import org.ow2.jonas.deployment.ejb.ejbql.ASTBetweenExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTBooleanExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTCmpPathExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTCollectionMemberDeclaration;
import org.ow2.jonas.deployment.ejb.ejbql.ASTCollectionMemberExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTCollectionValuedPathExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTComparisonExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTConditionalExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTConditionalFactor;
import org.ow2.jonas.deployment.ejb.ejbql.ASTConditionalTerm;
import org.ow2.jonas.deployment.ejb.ejbql.ASTDatetimeExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTEJBQL;
import org.ow2.jonas.deployment.ejb.ejbql.ASTEmptyCollectionComparisonExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTEntityBeanExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTFromClause;
import org.ow2.jonas.deployment.ejb.ejbql.ASTFunctionsReturningNumerics;
import org.ow2.jonas.deployment.ejb.ejbql.ASTFunctionsReturningStrings;
import org.ow2.jonas.deployment.ejb.ejbql.ASTIdentificationVariable;
import org.ow2.jonas.deployment.ejb.ejbql.ASTIdentifier;
import org.ow2.jonas.deployment.ejb.ejbql.ASTInExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTLikeExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTNullComparisonExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTOrderByClause;
import org.ow2.jonas.deployment.ejb.ejbql.ASTOrderByItem;
import org.ow2.jonas.deployment.ejb.ejbql.ASTPath;
import org.ow2.jonas.deployment.ejb.ejbql.ASTRangeVariableDeclaration;
import org.ow2.jonas.deployment.ejb.ejbql.ASTSelectClause;
import org.ow2.jonas.deployment.ejb.ejbql.ASTSelectExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTSingleValuedCmrPathExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTSingleValuedPathExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTStringExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTWhereClause;
import org.ow2.jonas.deployment.ejb.ejbql.ParseException;
import org.ow2.jonas.deployment.ejb.ejbql.SimpleNode;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.ejb21.sql.EjbqlAbstractVisitor;

public class EjbqlVariableVisitor
extends EjbqlAbstractVisitor {
    private Manager manager;
    private DeploymentDescEjb2 dd;
    private HashMap ids = new HashMap();
    private HashMap fields = new HashMap();
    private QueryBuilder qb = new QueryBuilder();
    private HashSet collections = new HashSet();

    public EjbqlVariableVisitor(ASTEJBQL ejbql, DeploymentDescEjb2 dd, QueryBuilder qb, Manager mgr) throws Exception {
        this.dd = dd;
        this.qb = qb;
        this.manager = mgr;
        this.visit((SimpleNode)ejbql);
        for (String id : this.ids.keySet()) {
            EjbqlAbstractVisitor.IdValue idv = (EjbqlAbstractVisitor.IdValue)this.ids.get(id);
            this.fields.put(id + "." + "_PName", qb.project(this.define(id)));
            for (int i = 0; i < idv.getDeclaredPathLength(); ++i) {
                String path = idv.getMergedPath(i);
                if (this.collections.contains(path)) continue;
                this.fields.put(path, qb.project(this.define(path)));
            }
        }
    }

    private QueryTreeField define(String id) throws ParseException, MedorException {
        String[] path = this.splitPath(id);
        if (!this.qb.contains(path[0])) {
            EjbqlAbstractVisitor.IdValue idv = (EjbqlAbstractVisitor.IdValue)this.ids.get(path[0]);
            String[] name = idv.getName();
            PNameField pnf = name.length == 1 ? this.extent(name[0], path[0]) : (PNameField)this.define(this.mergePath(name));
            this.qb.define(path[0], (QueryTreeField)pnf);
        }
        return this.qb.navigate(path);
    }

    private PNameField extent(String schema, String alias) throws ParseException, MedorException {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        String cn = this.dd.asn2BeanDesc(schema).getJormClassName();
        Class theClass = this.manager.getClass(cn);
        if (theClass == null) {
            throw new ParseException("Abstract schema name \"" + schema + "\" has not been declared in the jorm meta information");
        }
        ClassExtent ext = new ClassExtent(theClass, alias, "_PName", false);
        return (PNameField)ext.getField(ext.getPNameFieldName());
    }

    public Map getFields() {
        return this.fields;
    }

    public void traceIds(HashMap idsM) {
        if (TraceEjb.isDebugQuery()) {
            TraceEjb.query.log(BasicLevel.DEBUG, (Object)"Begin of IDS structure:");
            for (String id : idsM.keySet()) {
                EjbqlAbstractVisitor.IdValue idv = (EjbqlAbstractVisitor.IdValue)idsM.get(id);
                TraceEjb.query.log(BasicLevel.DEBUG, (Object)("ids[" + id + "]=" + idv));
                if (idv.getQueryTree() == null) continue;
                QueryTreePrinter.printQueryTree((QueryTree)idv.getQueryTree(), (Logger)TraceEjb.query, (int)BasicLevel.DEBUG);
            }
            TraceEjb.query.log(BasicLevel.DEBUG, (Object)"End of IDS structure:");
        }
    }

    public Object visit(ASTFromClause node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTCollectionMemberDeclaration node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTRangeVariableDeclaration node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTCollectionValuedPathExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTAbstractSchemaName node, Object data) {
        ((Stack)data).push(node.value);
        return null;
    }

    public Object visit(ASTIdentifier node, Object data) {
        String id = (String)node.value;
        String name = (String)((Stack)data).pop();
        EjbqlAbstractVisitor.IdValue iv = (EjbqlAbstractVisitor.IdValue)this.ids.get(id);
        if (iv == null) {
            iv = new EjbqlAbstractVisitor.IdValue(name);
            this.ids.put(id, iv);
        } else {
            iv.setName(this.splitPath(name));
        }
        return null;
    }

    public Object visit(ASTPath node, Object data) {
        ((Stack)data).push(node.value);
        return null;
    }

    private void processVariable(String path) {
        String id = this.splitPath(path)[0];
        EjbqlAbstractVisitor.IdValue iv = (EjbqlAbstractVisitor.IdValue)this.ids.get(id);
        if (iv == null) {
            iv = new EjbqlAbstractVisitor.IdValue();
            this.ids.put(id, iv);
        }
        iv.addPath(path);
    }

    public Object visit(ASTSelectClause node, Object data) {
        this.visit((SimpleNode)node, data);
        Stack st = (Stack)data;
        if (!st.empty()) {
            this.processVariable((String)st.pop());
        }
        return null;
    }

    public Object visit(ASTSelectExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTAggregateSelectExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTIdentificationVariable node, Object data) {
        String vName = ((String)node.value).toLowerCase();
        node.value = vName;
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTSingleValuedPathExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTSingleValuedCmrPathExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTCmpPathExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTWhereClause node, Object data) {
        this.visit((SimpleNode)node, data);
        Stack st = (Stack)data;
        while (!st.empty()) {
            this.processVariable((String)st.pop());
        }
        return null;
    }

    public Object visit(ASTConditionalExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTConditionalTerm node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTConditionalFactor node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTBetweenExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTInExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTLikeExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTNullComparisonExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTEmptyCollectionComparisonExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        Stack st = (Stack)data;
        String path = (String)st.peek();
        this.collections.add(path);
        return null;
    }

    public Object visit(ASTCollectionMemberExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        Stack st = (Stack)data;
        String path = (String)st.peek();
        this.collections.add(path);
        return null;
    }

    public Object visit(ASTComparisonExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTArithmeticExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTArithmeticTerm node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTArithmeticFactor node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTStringExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTDatetimeExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTBooleanExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTEntityBeanExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTFunctionsReturningStrings node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTFunctionsReturningNumerics node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTOrderByClause node, Object data) {
        this.visit((SimpleNode)node, data);
        Stack st = (Stack)data;
        while (!st.empty()) {
            this.processVariable((String)st.pop());
        }
        return null;
    }

    public Object visit(ASTOrderByItem node, Object data) {
        return this.visit((SimpleNode)node, data);
    }
}

