/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.protocols.TP;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.RouterStub;
import org.jgroups.util.Util;

public class TUNNEL
extends TP {
    private String router_host = null;
    private int router_port = 0;
    private RouterStub stub;
    long reconnect_interval = 5000L;
    private Future reconnectorFuture = null;
    private final Lock reconnectorLock = new ReentrantLock();

    public String toString() {
        return "Protocol TUNNEL(local_addr=" + this.local_addr + ')';
    }

    public String getName() {
        return "TUNNEL";
    }

    public void init() throws Exception {
        super.init();
        if (this.stack == null || this.stack.timer == null) {
            throw new Exception("TUNNEL.init(): timer cannot be retrieved from protocol stack");
        }
        this.timer = this.stack.timer;
    }

    public void start() throws Exception {
        this.loopback = true;
        this.stub = new RouterStub(this.router_host, this.router_port, this.bind_addr);
        this.stub.setConnectionListener(new StubConnectionListener());
        this.local_addr = this.stub.getLocalAddress();
        if (this.additional_data != null && this.local_addr instanceof IpAddress) {
            ((IpAddress)this.local_addr).setAdditionalData(this.additional_data);
        }
        super.start();
    }

    public void stop() {
        super.stop();
        this.teardownTunnel();
        this.local_addr = null;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("router_host");
        if (str != null) {
            this.router_host = str;
            props.remove("router_host");
        }
        if ((str = props.getProperty("router_port")) != null) {
            this.router_port = Integer.parseInt(str);
            props.remove("router_port");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("router_host=" + this.router_host + ";router_port=" + this.router_port));
        }
        if ((this.router_host == null || this.router_port == 0) && this.log.isErrorEnabled()) {
            this.log.error((Object)"both router_host and router_port have to be set !");
            return false;
        }
        str = props.getProperty("reconnect_interval");
        if (str != null) {
            this.reconnect_interval = Long.parseLong(str);
            props.remove("reconnect_interval");
        }
        if (!props.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                sb.append(e.nextElement().toString());
                if (!e.hasMoreElements()) continue;
                sb.append(", ");
            }
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("The following properties are not recognized: " + sb));
            }
            return false;
        }
        return true;
    }

    void teardownTunnel() {
        this.stopReconnecting();
        this.stub.disconnect();
    }

    public Object handleDownEvent(Event evt) {
        Object retEvent = super.handleDownEvent(evt);
        switch (evt.getType()) {
            case 2: 
            case 80: {
                try {
                    this.stub.connect(this.channel_name);
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break;
                    this.log.error((Object)("failed connecting to GossipRouter at " + this.router_host + ":" + this.router_port));
                }
                break;
            }
            case 4: {
                this.teardownTunnel();
            }
        }
        return retEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReconnecting() {
        this.reconnectorLock.lock();
        try {
            if (this.reconnectorFuture == null || this.reconnectorFuture.isDone()) {
                Runnable reconnector = new Runnable(){

                    public void run() {
                        block2: {
                            try {
                                TUNNEL.this.stub.connect(TUNNEL.this.channel_name);
                            }
                            catch (Exception ex) {
                                if (!TUNNEL.this.log.isTraceEnabled()) break block2;
                                TUNNEL.this.log.trace((Object)"failed reconnecting", (Throwable)ex);
                            }
                        }
                    }
                };
                this.reconnectorFuture = this.timer.scheduleWithFixedDelay(reconnector, 0L, this.reconnect_interval, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.reconnectorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReconnecting() {
        this.reconnectorLock.lock();
        try {
            if (this.reconnectorFuture != null) {
                this.reconnectorFuture.cancel(true);
                this.reconnectorFuture = null;
            }
        }
        finally {
            this.reconnectorLock.unlock();
        }
    }

    public void sendToAllMembers(byte[] data, int offset, int length) throws Exception {
        this.stub.sendToAllMembers(data, offset, length);
    }

    public void sendToSingleMember(Address dest, byte[] data, int offset, int length) throws Exception {
        this.stub.sendToSingleMember(dest, data, offset, length);
    }

    public String getInfo() {
        if (this.stub != null) {
            return this.stub.toString();
        }
        return "RouterStub not yet initialized";
    }

    public void postUnmarshalling(Message msg, Address dest, Address src, boolean multicast) {
        msg.setDest(dest);
    }

    public void postUnmarshallingList(Message msg, Address dest, boolean multicast) {
        msg.setDest(dest);
    }

    private class TunnelReceiver
    implements Runnable {
        private TunnelReceiver() {
        }

        public void run() {
            while (TUNNEL.this.stub.isConnected()) {
                Address dest = null;
                Address src = null;
                byte[] data = null;
                DataInputStream input = null;
                try {
                    input = TUNNEL.this.stub.getInputStream();
                    dest = Util.readAddress(input);
                    int len = input.readInt();
                    if (len <= 0) continue;
                    data = new byte[len];
                    input.readFully(data, 0, len);
                    TUNNEL.this.receive(dest, src, data, 0, len);
                }
                catch (SocketException se) {
                }
                catch (IOException ioe) {
                }
                catch (Exception e) {
                    if (!TUNNEL.this.log.isWarnEnabled()) continue;
                    TUNNEL.this.log.warn((Object)"failure in TUNNEL receiver thread", (Throwable)e);
                }
            }
        }
    }

    private class StubConnectionListener
    implements RouterStub.ConnectionListener {
        private volatile int currentState = 1;

        private StubConnectionListener() {
        }

        public void connectionStatusChange(int newState) {
            if (this.currentState == 0 && newState == 2) {
                TUNNEL.this.startReconnecting();
            } else if (this.currentState != 0 && newState == 0) {
                TUNNEL.this.stopReconnecting();
                Thread receiver = new Thread(Util.getGlobalThreadGroup(), new TunnelReceiver(), "TUNNEL receiver");
                receiver.setDaemon(true);
                receiver.start();
            }
            this.currentState = newState;
        }
    }
}

