/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Digest;
import org.jgroups.util.Promise;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FLUSH
extends Protocol {
    public static final String NAME = "FLUSH";
    private View currentView;
    private Address localAddress;
    private Address flushCoordinator;
    private final List<Address> flushMembers;
    private final Map<Address, Digest> flushCompletedMap;
    private final Set<Address> stopFlushOkSet;
    private final Set<Address> suspected;
    private final Object sharedLock = new Object();
    private final Object blockMutex = new Object();
    private volatile boolean isBlockingFlushDown = true;
    private long timeout = 8000L;
    private long start_flush_timeout = 6000L;
    private boolean enable_reconciliation = true;
    private boolean receivedFirstView = false;
    private boolean receivedMoreThanOneView = false;
    private volatile boolean allowMessagesToPassUp = false;
    private long startFlushTime;
    private long totalTimeInFlush;
    private int numberOfFlushes;
    private double averageFlushDuration;
    private final Promise<Boolean> flush_promise = new Promise();
    private final AtomicBoolean flushInProgress = new AtomicBoolean(false);
    private final List<Address> reconcileOks = new ArrayList<Address>();

    public FLUSH() {
        this.currentView = new View(new ViewId(), new Vector<Address>());
        this.flushCompletedMap = new HashMap<Address, Digest>();
        this.stopFlushOkSet = new TreeSet<Address>();
        this.flushMembers = new ArrayList<Address>();
        this.suspected = new TreeSet<Address>();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        this.timeout = Util.parseLong(props, "timeout", this.timeout);
        this.start_flush_timeout = Util.parseLong(props, "start_flush_timeout", this.start_flush_timeout);
        this.enable_reconciliation = Util.parseBoolean(props, "enable_reconciliation", this.enable_reconciliation);
        String str = props.getProperty("auto_flush_conf");
        if (str != null) {
            this.log.warn((Object)"auto_flush_conf has been deprecated and its value will be ignored");
            props.remove("auto_flush_conf");
        }
        if (!props.isEmpty()) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("flush_supported", Boolean.TRUE);
        this.up_prot.up(new Event(56, map));
        this.down_prot.down(new Event(56, map));
        Object object = this.sharedLock;
        synchronized (object) {
            this.receivedFirstView = false;
            this.receivedMoreThanOneView = false;
        }
        object = this.blockMutex;
        synchronized (object) {
            this.isBlockingFlushDown = true;
        }
        this.allowMessagesToPassUp = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.sharedLock;
        synchronized (object) {
            this.currentView = new View(new ViewId(), new Vector<Address>());
            this.flushCompletedMap.clear();
            this.stopFlushOkSet.clear();
            this.flushMembers.clear();
            this.suspected.clear();
            this.flushCoordinator = null;
        }
    }

    public double getAverageFlushDuration() {
        return this.averageFlushDuration;
    }

    public long getTotalTimeInFlush() {
        return this.totalTimeInFlush;
    }

    public int getNumberOfFlushes() {
        return this.numberOfFlushes;
    }

    public boolean startFlush() {
        return this.startFlush(new Event(68), 3, false);
    }

    private boolean startFlush(Event evt, int numberOfAttempts, boolean isRetry) {
        boolean successfulFlush;
        block8: {
            successfulFlush = false;
            if (!this.flushInProgress.get() || isRetry) {
                this.flush_promise.reset();
                if (this.log.isDebugEnabled()) {
                    if (isRetry) {
                        this.log.debug((Object)("Retrying FLUSH at " + this.localAddress + ", " + evt + ". Attempts left " + numberOfAttempts));
                    } else {
                        this.log.debug((Object)("Received " + evt + " at " + this.localAddress + ". Running FLUSH..."));
                    }
                }
                this.onSuspend((View)evt.getArg());
                try {
                    Boolean r = this.flush_promise.getResultWithTimeout(this.start_flush_timeout);
                    successfulFlush = r;
                }
                catch (TimeoutException e) {
                    if (!this.log.isDebugEnabled()) break block8;
                    this.log.debug((Object)("At " + this.localAddress + " timed out waiting for flush responses after " + this.start_flush_timeout + " msec"));
                }
            }
        }
        if (!successfulFlush && numberOfAttempts > 0) {
            long backOffSleepTime = Util.random(5L);
            long l = backOffSleepTime = backOffSleepTime < 2L ? backOffSleepTime + 2L : backOffSleepTime;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("At " + this.localAddress + ". Backing off for " + backOffSleepTime + " sec. Attempts left " + numberOfAttempts));
            }
            Util.sleep(backOffSleepTime * 1000L);
            successfulFlush = this.startFlush(evt, --numberOfAttempts, true);
        }
        return successfulFlush;
    }

    public void stopFlush() {
        this.down(new Event(70));
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                if (dest == null || dest.isMulticastAddress()) {
                    FlushHeader fh = (FlushHeader)msg.getHeader(this.getName());
                    if (fh != null && fh.type == 6) {
                        return this.down_prot.down(evt);
                    }
                    this.blockMessageDuringFlush();
                    break;
                }
                return this.down_prot.down(evt);
            }
            case 2: 
            case 80: {
                this.sendBlockUpToChannel();
                break;
            }
            case 68: {
                return this.startFlush(evt, 3, false);
            }
            case 70: {
                this.onResume();
                return null;
            }
        }
        return this.down_prot.down(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockMessageDuringFlush() {
        boolean shouldSuspendByItself = false;
        long start = 0L;
        long stop = 0L;
        Object object = this.blockMutex;
        synchronized (object) {
            while (this.isBlockingFlushDown) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("FLUSH block at " + this.localAddress + " for " + (this.timeout <= 0L ? "ever" : this.timeout + "ms")));
                }
                try {
                    start = System.currentTimeMillis();
                    if (this.timeout <= 0L) {
                        this.blockMutex.wait();
                    } else {
                        this.blockMutex.wait(this.timeout);
                    }
                    stop = System.currentTimeMillis();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (!this.isBlockingFlushDown) continue;
                this.isBlockingFlushDown = false;
                shouldSuspendByItself = true;
                this.blockMutex.notifyAll();
            }
        }
        if (shouldSuspendByItself) {
            this.log.warn((Object)("unblocking FLUSH.down() at " + this.localAddress + " after timeout of " + (stop - start) + "ms"));
            this.flush_promise.setResult(Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                FlushHeader fh = (FlushHeader)msg.getHeader(this.getName());
                if (fh != null) {
                    switch (fh.type) {
                        case 6: {
                            return this.up_prot.up(evt);
                        }
                        case 0: {
                            this.handleStartFlush(msg, fh);
                            break;
                        }
                        case 7: {
                            this.handleFlushReconcile(msg, fh);
                            break;
                        }
                        case 8: {
                            this.onFlushReconcileOK(msg);
                            break;
                        }
                        case 2: {
                            this.onStopFlush();
                            break;
                        }
                        case 5: {
                            Object object = this.sharedLock;
                            synchronized (object) {
                                this.flushCompletedMap.clear();
                            }
                            this.flush_promise.setResult(Boolean.FALSE);
                            break;
                        }
                        case 3: {
                            if (!this.isCurrentFlushMessage(fh)) break;
                            this.onFlushCompleted(msg.getSrc(), fh.digest);
                        }
                    }
                    return null;
                }
                if (this.allowMessagesToPassUp) break;
                return null;
            }
            case 6: {
                boolean singletonMember;
                this.up_prot.up(evt);
                View newView = (View)evt.getArg();
                boolean firstView = this.onViewChange(newView);
                boolean bl = singletonMember = newView.size() == 1 && newView.containsMember(this.localAddress);
                if (firstView && singletonMember) {
                    Object object = this.blockMutex;
                    synchronized (object) {
                        this.isBlockingFlushDown = false;
                        this.blockMutex.notifyAll();
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("At " + this.localAddress + " unblocking FLUSH.down() and sending UNBLOCK up"));
                    }
                    this.allowMessagesToPassUp = true;
                    this.up_prot.up(new Event(75));
                }
                return null;
            }
            case 15: {
                View tmpView = (View)evt.getArg();
                if (tmpView.containsMember(this.localAddress)) break;
                this.onViewChange(tmpView);
                break;
            }
            case 8: {
                this.localAddress = (Address)evt.getArg();
                break;
            }
            case 9: {
                this.onSuspect((Address)evt.getArg());
                break;
            }
            case 68: {
                return this.startFlush(evt, 3, false);
            }
            case 70: {
                this.onResume();
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFlushReconcileOK(Message msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.localAddress + " received reconcile ok from " + msg.getSrc()));
        }
        Object object = this.sharedLock;
        synchronized (object) {
            this.reconcileOks.add(msg.getSrc());
            if (this.reconcileOks.size() >= this.flushMembers.size()) {
                this.flush_promise.setResult(Boolean.TRUE);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("All FLUSH_RECONCILE_OK received at " + this.localAddress));
                }
            }
        }
    }

    private void handleFlushReconcile(Message msg, FlushHeader fh) {
        Address requester = msg.getSrc();
        Digest reconcileDigest = fh.digest;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received FLUSH_RECONCILE at " + this.localAddress + " passing digest to NAKACK " + reconcileDigest));
        }
        this.down_prot.down(new Event(78, reconcileDigest));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Returned from FLUSH_RECONCILE at " + this.localAddress + " Sending RECONCILE_OK to " + requester + ", thread " + Thread.currentThread()));
        }
        Message reconcileOk = new Message(requester);
        reconcileOk.setFlag((byte)1);
        reconcileOk.putHeader(this.getName(), new FlushHeader(8));
        this.down_prot.down(new Event(1, reconcileOk));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStartFlush(Message msg, FlushHeader fh) {
        Address coordinator = null;
        boolean proceed = false;
        Address flushRequester = msg.getSrc();
        Object object = this.sharedLock;
        synchronized (object) {
            proceed = this.flushInProgress.compareAndSet(false, true);
            if (proceed) {
                this.flushCoordinator = flushRequester;
            } else {
                coordinator = this.flushCoordinator != null ? this.flushCoordinator : flushRequester;
            }
        }
        if (proceed) {
            this.sendBlockUpToChannel();
            this.onStartFlush(flushRequester, fh);
        } else if (flushRequester.compareTo(coordinator) < 0) {
            this.rejectFlush(fh.viewID, coordinator);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Rejecting flush at " + this.localAddress + " to current flush coordinator " + coordinator + " and switching flush coordinator to " + flushRequester));
            }
            this.onStartFlush(flushRequester, fh);
        } else if (flushRequester.compareTo(coordinator) > 0) {
            this.rejectFlush(fh.viewID, flushRequester);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Rejecting flush at " + this.localAddress + " to flush requester " + flushRequester + " coordinator is " + coordinator));
            }
            this.onStartFlush(coordinator, fh);
        } else if (flushRequester.equals(coordinator)) {
            this.rejectFlush(fh.viewID, flushRequester);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Rejecting flush at " + this.localAddress + ", previous flush has to finish first"));
            }
        }
    }

    @Override
    public Vector<Integer> providedDownServices() {
        Vector<Integer> retval = new Vector<Integer>(2);
        retval.addElement(new Integer(68));
        retval.addElement(new Integer(70));
        return retval;
    }

    private void rejectFlush(long viewId, Address flushRequester) {
        Message reject = new Message(flushRequester, this.localAddress, null);
        reject.putHeader(this.getName(), new FlushHeader(5, viewId));
        this.down_prot.down(new Event(1, reject));
    }

    private void sendBlockUpToChannel() {
        this.up_prot.up(new Event(10));
    }

    private boolean isCurrentFlushMessage(FlushHeader fh) {
        return fh.viewID == this.currentViewId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long currentViewId() {
        long viewId = -1L;
        Object object = this.sharedLock;
        synchronized (object) {
            ViewId view = this.currentView.getVid();
            if (view != null) {
                viewId = view.getId();
            }
        }
        return viewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onViewChange(View view) {
        boolean amINewCoordinator = false;
        boolean isThisOurFirstView = false;
        Object object = this.sharedLock;
        synchronized (object) {
            boolean coordinatorLeft;
            if (this.receivedFirstView) {
                this.receivedMoreThanOneView = true;
            }
            if (!this.receivedFirstView) {
                this.receivedFirstView = true;
            }
            isThisOurFirstView = !this.receivedMoreThanOneView;
            this.suspected.retainAll(view.getMembers());
            this.currentView = view;
            boolean bl = coordinatorLeft = this.flushCoordinator != null && !view.containsMember(this.flushCoordinator);
            if (coordinatorLeft) {
                this.flushCoordinator = view.getMembers().get(0);
                amINewCoordinator = this.localAddress.equals(this.flushCoordinator);
            }
        }
        if (amINewCoordinator) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Coordinator left, " + this.localAddress + " will complete flush"));
            }
            this.onResume();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Installing view at  " + this.localAddress + " view is " + view));
        }
        return isThisOurFirstView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStopFlush() {
        if (this.stats) {
            long stopFlushTime = System.currentTimeMillis();
            this.totalTimeInFlush += stopFlushTime - this.startFlushTime;
            if (this.numberOfFlushes > 0) {
                this.averageFlushDuration = (double)this.totalTimeInFlush / (double)this.numberOfFlushes;
            }
        }
        boolean amISurvivingMember = false;
        Object object = this.sharedLock;
        synchronized (object) {
            amISurvivingMember = this.currentView.containsMember(this.localAddress);
            this.flushCompletedMap.clear();
            this.stopFlushOkSet.clear();
            this.flushMembers.clear();
            this.suspected.clear();
            this.flushCoordinator = null;
            this.allowMessagesToPassUp = true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("At " + this.localAddress + " received STOP_FLUSH, unblocking FLUSH.down() and sending UNBLOCK up"));
        }
        object = this.blockMutex;
        synchronized (object) {
            this.isBlockingFlushDown = false;
            this.blockMutex.notifyAll();
        }
        if (amISurvivingMember) {
            this.up_prot.up(new Event(75));
        }
        this.flushInProgress.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSuspend(View view) {
        Message msg = null;
        ArrayList<Address> participantsInFlush = null;
        Object object = this.sharedLock;
        synchronized (object) {
            if (view != null) {
                participantsInFlush = new ArrayList<Address>(view.getMembers());
                participantsInFlush.retainAll(this.currentView.getMembers());
            } else {
                participantsInFlush = new ArrayList<Address>(this.currentView.getMembers());
            }
            msg = new Message(null, this.localAddress, null);
            msg.putHeader(this.getName(), new FlushHeader(0, this.currentViewId(), participantsInFlush));
        }
        if (participantsInFlush.isEmpty()) {
            this.flush_promise.setResult(Boolean.TRUE);
        } else {
            this.down_prot.down(new Event(1, msg));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Flush coordinator " + this.localAddress + " is starting FLUSH with participants " + participantsInFlush));
            }
        }
    }

    private void onResume() {
        long viewID = this.currentViewId();
        Message msg = new Message(null, this.localAddress, null);
        msg.putHeader(this.getName(), new FlushHeader(2, viewID));
        this.down_prot.down(new Event(1, msg));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received RESUME at " + this.localAddress + ", sent STOP_FLUSH to all"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStartFlush(Address flushStarter, FlushHeader fh) {
        Object object = this.blockMutex;
        synchronized (object) {
            this.isBlockingFlushDown = true;
        }
        if (this.stats) {
            this.startFlushTime = System.currentTimeMillis();
            ++this.numberOfFlushes;
        }
        boolean amIParticipant = false;
        Object object2 = this.sharedLock;
        synchronized (object2) {
            this.flushCoordinator = flushStarter;
            this.flushMembers.clear();
            if (fh.flushParticipants != null) {
                this.flushMembers.addAll(fh.flushParticipants);
            }
            this.flushMembers.removeAll(this.suspected);
            amIParticipant = this.flushMembers.contains(this.localAddress);
        }
        if (amIParticipant) {
            Digest digest = (Digest)this.down_prot.down(new Event(39));
            FlushHeader fhr = new FlushHeader(3, fh.viewID);
            fhr.addDigest(digest);
            Message msg = new Message(flushStarter);
            msg.putHeader(this.getName(), fhr);
            this.down_prot.down(new Event(1, msg));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Received START_FLUSH at " + this.localAddress + " responded with FLUSH_OK"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFlushCompleted(Address address, Digest digest) {
        boolean flushCompleted = false;
        Message msg = null;
        boolean needsReconciliationPhase = false;
        Object object = this.sharedLock;
        synchronized (object) {
            this.flushCompletedMap.put(address, digest);
            if (this.flushCompletedMap.size() >= this.flushMembers.size()) {
                flushCompleted = this.flushCompletedMap.keySet().containsAll(this.flushMembers);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("At " + this.localAddress + " FLUSH_COMPLETED from " + address + ",completed " + flushCompleted + ",flushCompleted " + this.flushCompletedMap.keySet()));
            }
            boolean bl = needsReconciliationPhase = this.enable_reconciliation && flushCompleted && this.hasVirtualSynchronyGaps();
            if (needsReconciliationPhase) {
                Digest d = this.findHighestSequences();
                msg = new Message();
                msg.setFlag((byte)1);
                FlushHeader fh = new FlushHeader(7, this.currentViewId(), this.flushMembers);
                this.reconcileOks.clear();
                fh.addDigest(d);
                msg.putHeader(this.getName(), fh);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Reconciling flush mebers due to virtual synchrony gap, digest is " + d + " flush members are " + this.flushMembers));
                }
                this.flushCompletedMap.clear();
            }
        }
        if (needsReconciliationPhase) {
            this.down_prot.down(new Event(1, msg));
        } else if (flushCompleted) {
            this.flush_promise.setResult(Boolean.TRUE);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("All FLUSH_COMPLETED received at " + this.localAddress));
            }
        }
    }

    private boolean hasVirtualSynchronyGaps() {
        ArrayList<Digest> digests = new ArrayList<Digest>();
        digests.addAll(this.flushCompletedMap.values());
        Digest firstDigest = (Digest)digests.get(0);
        List remainingDigests = digests.subList(1, digests.size());
        for (Digest digest : remainingDigests) {
            Digest diff = firstDigest.difference(digest);
            if (diff == Digest.EMPTY_DIGEST) continue;
            return true;
        }
        return false;
    }

    private Digest findHighestSequences() {
        Digest result = null;
        ArrayList<Digest> digests = new ArrayList<Digest>(this.flushCompletedMap.values());
        result = (Digest)digests.get(0);
        List remainingDigests = digests.subList(1, digests.size());
        for (Digest digestG : remainingDigests) {
            result = result.highestSequence(digestG);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSuspect(Address address) {
        boolean flushOkCompleted = false;
        Message m = null;
        long viewID = 0L;
        Object object = this.sharedLock;
        synchronized (object) {
            this.suspected.add(address);
            this.flushMembers.removeAll(this.suspected);
            viewID = this.currentViewId();
            boolean bl = flushOkCompleted = !this.flushCompletedMap.isEmpty() && this.flushCompletedMap.keySet().containsAll(this.flushMembers);
            if (flushOkCompleted) {
                m = new Message(this.flushCoordinator, this.localAddress, null);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Suspect is " + address + ",completed " + flushOkCompleted + ",  flushOkSet " + this.flushCompletedMap + " flushMembers " + this.flushMembers));
            }
        }
        if (flushOkCompleted) {
            Digest digest = (Digest)this.down_prot.down(new Event(39));
            FlushHeader fh = new FlushHeader(3, viewID);
            fh.addDigest(digest);
            m.putHeader(this.getName(), fh);
            this.down_prot.down(new Event(1, m));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this.localAddress + " sent FLUSH_COMPLETED message to " + this.flushCoordinator));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FlushHeader
    extends Header
    implements Streamable {
        public static final byte START_FLUSH = 0;
        public static final byte STOP_FLUSH = 2;
        public static final byte FLUSH_COMPLETED = 3;
        public static final byte ABORT_FLUSH = 5;
        public static final byte FLUSH_BYPASS = 6;
        public static final byte FLUSH_RECONCILE = 7;
        public static final byte FLUSH_RECONCILE_OK = 8;
        byte type;
        long viewID;
        Collection<Address> flushParticipants;
        Digest digest = null;
        private static final long serialVersionUID = -6248843990215637687L;

        public FlushHeader() {
            this(0, 0L);
        }

        public FlushHeader(byte type) {
            this(type, 0L);
        }

        public FlushHeader(byte type, long viewID) {
            this(type, viewID, null);
        }

        public FlushHeader(byte type, long viewID, Collection<Address> flushView) {
            this.type = type;
            this.viewID = viewID;
            this.flushParticipants = flushView;
        }

        public void addDigest(Digest digest) {
            this.digest = digest;
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 0: {
                    return "FLUSH[type=START_FLUSH,viewId=" + this.viewID + ",members=" + this.flushParticipants + "]";
                }
                case 2: {
                    return "FLUSH[type=STOP_FLUSH,viewId=" + this.viewID + "]";
                }
                case 5: {
                    return "FLUSH[type=ABORT_FLUSH,viewId=" + this.viewID + "]";
                }
                case 3: {
                    return "FLUSH[type=FLUSH_COMPLETED,viewId=" + this.viewID + "]";
                }
                case 6: {
                    return "FLUSH[type=FLUSH_BYPASS,viewId=" + this.viewID + "]";
                }
                case 7: {
                    return "FLUSH[type=FLUSH_RECONCILE,viewId=" + this.viewID + ",digest=" + this.digest + "]";
                }
                case 8: {
                    return "FLUSH[type=FLUSH_RECONCILE_OK,viewId=" + this.viewID + "]";
                }
            }
            return "[FLUSH: unknown type (" + this.type + ")]";
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.viewID);
            out.writeObject(this.flushParticipants);
            out.writeObject(this.digest);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.viewID = in.readLong();
            this.flushParticipants = (Collection)in.readObject();
            this.digest = (Digest)in.readObject();
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.viewID);
            if (this.flushParticipants != null && !this.flushParticipants.isEmpty()) {
                out.writeShort(this.flushParticipants.size());
                for (Address address : this.flushParticipants) {
                    Util.writeAddress(address, out);
                }
            } else {
                out.writeShort(0);
            }
            if (this.digest != null) {
                out.writeBoolean(true);
                Util.writeStreamable(this.digest, out);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            boolean hasDigest;
            this.type = in.readByte();
            this.viewID = in.readLong();
            int flushParticipantsSize = in.readShort();
            if (flushParticipantsSize > 0) {
                this.flushParticipants = new ArrayList<Address>(flushParticipantsSize);
                for (int i = 0; i < flushParticipantsSize; ++i) {
                    this.flushParticipants.add(Util.readAddress(in));
                }
            }
            if (hasDigest = in.readBoolean()) {
                this.digest = (Digest)Util.readStreamable(Digest.class, in);
            }
        }
    }
}

