/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.debug.Simulator;
import org.jgroups.protocols.BARRIER;
import org.jgroups.protocols.PING;
import org.jgroups.protocols.VIEW_SYNC;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class BARRIERTest
extends TestCase {
    IpAddress a1;
    Vector members;
    View v;
    Simulator s;
    BARRIER barrier_prot = new BARRIER();
    PING bottom_prot;

    public BARRIERTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.a1 = new IpAddress(1111);
        this.members = new Vector();
        this.members.add(this.a1);
        this.v = new View(this.a1, 1L, this.members);
        this.s = new Simulator();
        this.s.setLocalAddress(this.a1);
        this.s.setView(this.v);
        this.s.addMember(this.a1);
        this.bottom_prot = new PING();
        Protocol[] stack = new Protocol[]{new VIEW_SYNC(), this.barrier_prot, this.bottom_prot};
        this.s.setProtocolStack(stack);
        this.s.start();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.s.stop();
    }

    public void testBlocking() {
        BARRIERTest.assertFalse((boolean)this.barrier_prot.isClosed());
        this.s.send(new Event(76));
        BARRIERTest.assertTrue((boolean)this.barrier_prot.isClosed());
        this.s.send(new Event(77));
        BARRIERTest.assertFalse((boolean)this.barrier_prot.isClosed());
    }

    public void testThreadsBlockedOnBarrier() {
        MyReceiver receiver = new MyReceiver();
        this.s.setReceiver(receiver);
        this.s.send(new Event(76));
        for (int i = 0; i < 5; ++i) {
            new Thread(){

                public void run() {
                    BARRIERTest.this.bottom_prot.up(new Event(1, new Message(null, null, null)));
                }
            }.start();
        }
        Util.sleep(500L);
        int num_in_flight_threads = this.barrier_prot.getNumberOfInFlightThreads();
        BARRIERTest.assertEquals((int)5, (int)num_in_flight_threads);
        this.s.send(new Event(77));
        Util.sleep(500L);
        num_in_flight_threads = this.barrier_prot.getNumberOfInFlightThreads();
        BARRIERTest.assertEquals((int)0, (int)num_in_flight_threads);
        BARRIERTest.assertEquals((int)5, (int)receiver.getNumberOfReceivedMessages());
    }

    public static Test suite() {
        return new TestSuite(BARRIERTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)BARRIERTest.suite());
    }

    static class MyReceiver
    implements Simulator.Receiver {
        int num_mgs_received = 0;

        MyReceiver() {
        }

        public void receive(Event evt) {
            if (evt.getType() == 1) {
                ++this.num_mgs_received;
                if (this.num_mgs_received % 1000 == 0) {
                    System.out.println("<== " + this.num_mgs_received);
                }
            }
        }

        public int getNumberOfReceivedMessages() {
            return this.num_mgs_received;
        }
    }
}

