/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Vector;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.protocols.MERGE2;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Util;

public class ConnectStressTest
extends TestCase {
    static CyclicBarrier start_connecting = null;
    static CyclicBarrier connected = null;
    static CyclicBarrier received_all_views = null;
    static CyclicBarrier start_disconnecting = null;
    static CyclicBarrier disconnected = null;
    static final int NUM = 20;
    static final MyThread[] threads = new MyThread[20];
    static JChannel channel = null;
    static String groupname = "ConcurrentTestDemo";
    static String props = "udp.xml";

    public ConnectStressTest(String name) {
        super(name);
    }

    static void log(String msg) {
        System.out.println("-- [" + Thread.currentThread().getName() + "] " + msg);
    }

    public void testConcurrentJoinsAndLeaves() throws Exception {
        View v;
        int i;
        start_connecting = new CyclicBarrier(21);
        connected = new CyclicBarrier(21);
        received_all_views = new CyclicBarrier(21);
        start_disconnecting = new CyclicBarrier(21);
        disconnected = new CyclicBarrier(21);
        channel = new JChannel(props);
        channel.setOpt(5, Boolean.TRUE);
        ConnectStressTest.changeProperties(channel);
        long start = System.currentTimeMillis();
        channel.connect(groupname);
        long stop = System.currentTimeMillis();
        ConnectStressTest.log(channel.getLocalAddress() + " connected in " + (stop - start) + " msecs (" + channel.getView().getMembers().size() + " members). VID=" + channel.getView().getVid());
        ConnectStressTest.assertEquals((String)"view should have size == 1 after initial connect ", (int)1, (int)channel.getView().getMembers().size());
        for (int i2 = 0; i2 < threads.length; ++i2) {
            ConnectStressTest.threads[i2] = new MyThread(i2);
            threads[i2].start();
        }
        start_connecting.await();
        start = System.currentTimeMillis();
        try {
            connected.await();
            stop = System.currentTimeMillis();
            System.out.println("-- took " + (stop - start) + " msecs for all " + 20 + " threads to connect");
            int num_members = -1;
            for (i = 0; i < 10; ++i) {
                v = channel.getView();
                num_members = v.getMembers().size();
                System.out.println("*--* number of members connected: " + num_members + ", (expected: " + 21 + "), v=" + v);
                if (num_members == 21) break;
                Util.sleep(5000L);
            }
            ConnectStressTest.assertEquals((String)"coordinator unable to obtain complete view", (int)21, (int)num_members);
            received_all_views.await();
            stop = System.currentTimeMillis();
            System.out.println("-- took " + (stop - start) + " msecs for all " + 20 + " threads to see all views");
        }
        catch (Exception ex) {
            ConnectStressTest.fail((String)ex.toString());
        }
        start_disconnecting.await();
        start = System.currentTimeMillis();
        disconnected.await();
        stop = System.currentTimeMillis();
        System.out.println("-- took " + (stop - start) + " msecs for " + 20 + " threads to disconnect");
        int num_members = 0;
        for (i = 0; i < 10; ++i) {
            Vector<Address> mbrs;
            v = channel.getView();
            Vector<Address> vector = mbrs = v != null ? v.getMembers() : null;
            if (mbrs != null) {
                num_members = mbrs.size();
                System.out.println("*--* number of members connected: " + num_members + ", (expected: 1), view=" + v);
                if (num_members <= 1) break;
            }
            Util.sleep(3000L);
        }
        ConnectStressTest.assertEquals((String)"view should have size == 1 after disconnect ", (int)1, (int)num_members);
        ConnectStressTest.log("closing all channels");
        for (i = 0; i < threads.length; ++i) {
            MyThread t = threads[i];
            t.closeChannel();
        }
        channel.close();
    }

    private static void changeProperties(JChannel ch) {
        MERGE2 merge;
        ProtocolStack stack = ch.getProtocolStack();
        GMS gms = (GMS)stack.findProtocol("GMS");
        if (gms != null) {
            gms.setViewBundling(true);
            gms.setMaxBundlingTime(300L);
        }
        if ((merge = (MERGE2)stack.findProtocol("MERGE2")) != null) {
            merge.setMinInterval(5000L);
            merge.setMaxInterval(10000L);
        }
    }

    public static Test suite() {
        TestSuite s = new TestSuite();
        s.addTest((Test)new ConnectStressTest("testConcurrentJoinsAndLeaves"));
        return s;
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{ConnectStressTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    public static class MyThread
    extends Thread {
        int index = -1;
        long total_connect_time = 0L;
        long total_disconnect_time = 0L;
        private JChannel ch = null;
        private Address my_addr = null;

        public MyThread(int i) {
            super("thread #" + i);
            this.index = i;
        }

        public void closeChannel() {
            if (this.ch != null) {
                this.ch.close();
            }
        }

        public void run() {
            try {
                this.ch = new JChannel(props);
                ConnectStressTest.changeProperties(this.ch);
                this.ch.setOpt(5, true);
                start_connecting.await();
                long start = System.currentTimeMillis();
                this.ch.connect(groupname);
                long stop = System.currentTimeMillis();
                this.total_connect_time = stop - start;
                View view = this.ch.getView();
                this.my_addr = this.ch.getLocalAddress();
                ConnectStressTest.log(this.my_addr + " connected in " + this.total_connect_time + " msecs (" + view.getMembers().size() + " members). VID=" + view.getVid());
                connected.await();
                int num_members = 0;
                while (true) {
                    View v;
                    Vector<Address> mbrs;
                    Vector<Address> vector = mbrs = (v = this.ch.getView()) != null ? v.getMembers() : null;
                    if (mbrs == null) {
                        System.err.println("mbrs is null, v=" + v);
                    } else {
                        num_members = mbrs.size();
                        ConnectStressTest.log("num_members=" + num_members);
                        if (num_members == 21) break;
                    }
                    Util.sleep(2000L);
                }
                ConnectStressTest.log("reached " + num_members + " members");
                received_all_views.await();
                start_disconnecting.await();
                start = System.currentTimeMillis();
                this.ch.disconnect();
                stop = System.currentTimeMillis();
                ConnectStressTest.log(this.my_addr + " disconnected in " + (stop - start) + " msecs");
                disconnected.await();
            }
            catch (BrokenBarrierException e) {
                e.printStackTrace();
            }
            catch (ChannelException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

