/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain.cluster.logical;

import java.util.Collection;
import java.util.HashMap;
import javax.management.JMException;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.management.domain.DomainMonitor;
import org.ow2.jonas.lib.management.domain.cluster.BaseCluster;
import org.ow2.jonas.lib.management.domain.cluster.ClusterFactory;
import org.ow2.jonas.lib.management.domain.cluster.logical.LogicalCluster;
import org.ow2.jonas.lib.management.domain.proxy.server.ServerProxy;

public class LogicalClusterFactory
extends ClusterFactory {
    private HashMap myclusters = new HashMap();

    public LogicalClusterFactory(DomainMonitor dm) {
        super(dm);
    }

    public BaseCluster getCluster(String name) {
        return (BaseCluster)this.myclusters.get(name);
    }

    public boolean notifyServer(ServerProxy proxy) {
        String serverName = proxy.getServerName();
        logger.log(BasicLevel.DEBUG, (Object)serverName);
        LogicalCluster domaincluster = (LogicalCluster)this.myclusters.get(this.domainName);
        if (domaincluster == null && (domaincluster = this.createLogicalCluster(this.domainName)) == null) {
            return false;
        }
        return domaincluster.addServer(serverName, proxy);
    }

    public Collection getClusterList() {
        return this.myclusters.values();
    }

    public LogicalCluster createLogicalCluster(String name) {
        LogicalCluster cluster = null;
        ObjectName clon = null;
        try {
            cluster = new LogicalCluster(this);
            clon = cluster.setName(name);
        }
        catch (JMException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot create LogicalCluster:" + e));
            return null;
        }
        if (!this.mbeanServer.isRegistered(clon)) {
            try {
                logger.log(BasicLevel.DEBUG, (Object)("Resister Cluster MBean : " + clon));
                this.mbeanServer.registerMBean(cluster, clon);
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot register cluster:" + e));
                return null;
            }
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Adding cluster : " + name));
        }
        this.myclusters.put(name, cluster);
        return cluster;
    }
}

