/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain.proxy;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.carol.util.configuration.Protocol;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.management.domain.DomainMonitor;
import org.ow2.jonas.lib.management.domain.proxy.ConnectorUtils;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.util.Log;

public abstract class JMXProxy {
    protected static Logger logger = Log.getLogger((String)"org.ow2.jonas.management.domain");
    protected String name = null;
    private String domain;
    protected String objectName = null;
    protected ArrayList urls;
    private String connectionUrl = null;
    protected MBeanServerConnection connection = null;
    protected JMXConnector connector = null;
    protected Map env = new HashMap();
    protected JmxService jmx = null;
    protected ObjectName serverOn = null;
    protected DomainMonitor dm;
    protected int state = 0;
    public static final int INITIAL = 0;
    public static final int UNREACHABLE = 1;
    public static final int RUNNING = 2;
    public static final int STOPPED = 3;
    public static final int FAILED = 4;
    public static final int UNKNOWN = 5;
    public static final int STARTING = 6;
    public static final int STOPPING = 7;

    public JMXProxy(DomainMonitor dm, String name, Collection urls) {
        this.dm = dm;
        this.name = name;
        logger.log(BasicLevel.DEBUG, (Object)name);
        this.jmx = dm.getJmxService();
        this.domain = dm.getDomainName();
        this.serverOn = J2eeObjectName.J2EEServer((String)this.domain, (String)name);
        logger.log(BasicLevel.DEBUG, (Object)this.serverOn);
        if (urls != null && this.connect(urls)) {
            this.state = 2;
        }
    }

    public int getServerState() {
        return this.state;
    }

    public String getState() {
        switch (this.state) {
            case 0: {
                return "INIT";
            }
            case 1: {
                return "UNREACHABLE";
            }
            case 2: {
                return "RUNNING";
            }
            case 3: {
                return "STOPPED";
            }
            case 4: {
                return "FAILED";
            }
            case 6: {
                return "STARTING";
            }
            case 7: {
                return "STOPPING";
            }
        }
        return "UNKNOWN";
    }

    public void disconnect() {
        if (this.connector != null) {
            this.connection = null;
            try {
                this.connector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean connect(Collection urls) {
        logger.log(BasicLevel.DEBUG, (Object)this.name);
        this.urls = new ArrayList(urls);
        String urlstr = (String)urls.iterator().next();
        JMXServiceURL url = null;
        try {
            url = new JMXServiceURL(urlstr);
        }
        catch (MalformedURLException e) {
            logger.log(BasicLevel.ERROR, (Object)("Malformed URL:" + urlstr));
            return false;
        }
        if (url.getProtocol().equals("iiop")) {
            try {
                this.env.put("java.naming.corba.orb", new InitialContext().lookup("java:comp/ORB"));
            }
            catch (NamingException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot get InitialContext: " + e));
            }
        }
        String initCtxClass = null;
        String providerUrl = null;
        try {
            String urlPath = url.getURLPath();
            String protocol = ConnectorUtils.getProtocolFromJmxConnectorUrl(urlPath);
            Protocol p = ConfigurationRepository.getProtocol((String)protocol);
            initCtxClass = p.getInitialContextFactoryClassName();
            providerUrl = ConnectorUtils.getProviderUrlFromJmxConnectorUrl(urlPath);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Unable to get the InitialContext from the protocol '" + url.getProtocol() + "'"));
        }
        if (initCtxClass != null) {
            this.env.put("java.naming.factory.initial", initCtxClass);
            this.env.put("java.naming.provider.url", providerUrl);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Setting the InitialContext to " + initCtxClass));
            }
        }
        this.disconnect();
        try {
            final JMXServiceURL myUrl = url;
            final Map myEnv = this.env;
            IExecution<JMXConnector> exec = new IExecution<JMXConnector>(){

                public JMXConnector execute() throws Exception {
                    return JMXConnectorFactory.connect(myUrl, myEnv);
                }
            };
            ClassLoader cl = JMXProxy.class.getClassLoader();
            ExecutionResult res = RunnableHelper.execute((ClassLoader)cl, (IExecution)exec);
            if (res.hasException()) {
                throw res.getException();
            }
            this.connector = (JMXConnector)res.getResult();
            this.connection = this.connector.getMBeanServerConnection();
        }
        catch (IOException e) {
            logger.log(BasicLevel.DEBUG, (Object)("JMXConnectorFactory error: " + e));
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("JMXConnectorFactory error: " + e));
        }
        if (this.connection == null) {
            this.connectionUrl = null;
            return false;
        }
        if (this.checkConnection(this.connection)) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("connected to server " + this.name + " using URL: " + urlstr));
            }
            this.connectionUrl = urlstr;
            return true;
        }
        this.connectionUrl = null;
        return false;
    }

    private boolean checkConnection(MBeanServerConnection connection) {
        try {
            int nb = connection.getMBeanCount();
            return true;
        }
        catch (IOException e) {
            logger.log(BasicLevel.DEBUG, (Object)(this.name + " : IOException"));
            return false;
        }
    }

    protected boolean checkConnection() {
        if (this.connection == null) {
            logger.log(BasicLevel.DEBUG, (Object)(this.name + " : null connection"));
            return this.connect(this.urls);
        }
        try {
            int nb = this.connection.getMBeanCount();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this.name + ": mbeans nb =" + nb));
            }
            return true;
        }
        catch (IOException e) {
            logger.log(BasicLevel.DEBUG, (Object)(this.name + " : IOException"));
            return false;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String on) {
        this.objectName = on;
        this.jmx.registerMBean((Object)this, on);
    }

    public MBeanServerConnection getConnection() {
        return this.connection;
    }

    public boolean isRegistered(ObjectName on) {
        if (!this.checkConnection()) {
            logger.log(BasicLevel.ERROR, (Object)"Not yet connected!");
            return false;
        }
        try {
            return this.connection.isRegistered(on);
        }
        catch (IOException e) {
            logger.log(BasicLevel.ERROR, (Object)"IO ERROR", (Throwable)e);
            return false;
        }
    }

    public Object getAttribute(ObjectName on, String attribute) {
        if (!this.checkConnection()) {
            logger.log(BasicLevel.ERROR, (Object)"Not yet connected!");
            return null;
        }
        try {
            return this.connection.getAttribute(on, attribute);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot get attribute", (Throwable)e);
            return null;
        }
    }

    public AttributeList getAttributes(ObjectName on, String[] attributes) {
        if (!this.checkConnection()) {
            logger.log(BasicLevel.ERROR, (Object)"Not yet connected!");
            return null;
        }
        try {
            return this.connection.getAttributes(on, attributes);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot get attribute", (Throwable)e);
            return null;
        }
    }

    public Set queryNames(ObjectName on) {
        if (!this.checkConnection()) {
            logger.log(BasicLevel.ERROR, (Object)"Not yet connected!");
            return null;
        }
        try {
            return this.connection.queryNames(on, null);
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot get attribute", (Throwable)e);
            return null;
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public ArrayList getUrls() {
        return this.urls;
    }
}

