/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant.cluster;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.ow2.jonas.ant.cluster.ClusterTasks;
import org.ow2.jonas.ant.jonasbase.BaseTaskItf;
import org.ow2.jonas.ant.jonasbase.Carol;

public class CarolCluster
extends ClusterTasks {
    private static final String INFO = "[CarolCluster] ";
    private String[] portRange = null;
    private String protocols = null;
    private boolean jrmpOptimization = false;

    public void setProtocols(String protocols) {
        this.protocols = protocols;
    }

    public void setPortRange(String portRange) {
        this.portRange = portRange.split(",");
    }

    public void setJrmpOptimization(boolean jrmpOptimization) {
        this.jrmpOptimization = jrmpOptimization;
    }

    /*
     * WARNING - void declaration
     */
    public void generatesTasks() {
        int portInd = 0;
        for (int i = this.getDestDirSuffixIndFirst(); i <= this.getDestDirSuffixIndLast(); ++i) {
            String destDir = CarolCluster.getDestDir(this.getDestDirPrefix(), i);
            Carol carol = new Carol();
            this.log("[CarolCluster] tasks generation for " + destDir);
            carol.setDefaultPort(this.portRange[portInd]);
            carol.setProtocols(this.protocols);
            carol.setJrmpOptimization(this.jrmpOptimization);
            carol.setCmiStarted(true);
            int webIstNb = this.getWebInstNb();
            if (this.getArch().equals("diffWebEjb") && i <= webIstNb) {
                void var7_10;
                int ejbInstNb = this.getEjbInstNb();
                String string = "";
                for (String protocol : this.protocols.split(",")) {
                    void var7_12;
                    if (var7_10 != "") {
                        String string2 = (String)var7_10 + ";";
                    }
                    String string3 = (String)var7_12 + protocol + "::";
                    if (protocol.equals("jrmp") || protocol.equals("irmi")) {
                        String string4 = string3 + "rmi://";
                    } else if (protocol.equals("iiop")) {
                        String string5 = string3 + "iiop://";
                    } else {
                        this.log("[CarolCluster] Unknown protocol: " + protocol);
                        throw new BuildException("Unknown protocol: " + protocol);
                    }
                    for (int j = webIstNb; j < webIstNb + ejbInstNb; ++j) {
                        void var7_19;
                        if (j != webIstNb) {
                            void var7_17;
                            String string6 = (String)var7_17 + ",";
                        }
                        String string7 = (String)var7_19 + "localhost:" + this.portRange[j];
                    }
                }
                carol.setClusterViewProviderUrls((String)var7_10);
            }
            for (BaseTaskItf baseTaskItf : carol.getTasks()) {
                baseTaskItf.setDestDir(new File(destDir));
            }
            this.addTasks(carol);
            ++portInd;
        }
    }
}

