/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant.jonasbase;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.ow2.jonas.ant.jonasbase.JReplace;
import org.ow2.jonas.ant.jonasbase.Tasks;
import org.ow2.jonas.ant.jonasbase.XMLSerializerTask;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Discovery
extends Tasks {
    private static final String INFO = "[Discovery] ";
    private static final String DEFAULT_DISCOVERY_MCASTADDR = "224.224.224.224";
    private static final String DEFAULT_DISCOVERY_MCASTPORT = "9080";
    private static final String DEFAULT_DISCOVERY_GREETING_PORT = "9899";
    private static final String DEFAULT_DISCOVERY_SOURCE_PORT = "9888";
    private static final String DEFAULT_DISCOVERY_TTL = "1";
    private static final String DISCOVERY_MCASTADDR_PROPERTY = "jonas.service.discovery.multicast.address";
    private static final String DISCOVERY_MCASTPORT_PROPERTY = "jonas.service.discovery.multicast.port";
    private static final String DISCOVERY_MASTER_PROPERTY = "jonas.service.discovery.master";
    private static final String DISCOVERY_GREETING_PORT_PROPERTY = "jonas.service.discovery.greeting.port";
    private static final String DISCOVERY_GREETING_TIMEOUT_PROPERTY = "jonas.service.discovery.greeting.timeout";
    private static final String DISCOVERY_SOURCE_PORT_PROPERTY = "jonas.service.discovery.source.port";
    private static final String DISCOVERY_TTL_PROPERTY = "jonas.service.discovery.ttl";
    private static final String DOMAIN_MNGT_CONF_FILE = "domain.xml";
    private Document domainDoc = null;
    private boolean domainDocLoaded = false;
    private String jonasRoot = null;

    public void setSourcePort(String portNumber) {
        int pn = new Integer(portNumber);
        if (pn != -1) {
            this.enableMaster();
            String token = "jonas.service.discovery.source.port=9888";
            String value = "jonas.service.discovery.source.port=" + portNumber;
            JReplace propertyReplace = new JReplace();
            propertyReplace.setLogInfo("[Discovery] Setting source port for discovery");
            propertyReplace.setConfigurationFile("jonas.properties");
            propertyReplace.setToken(token);
            propertyReplace.setValue(value);
            this.addTask((Task)propertyReplace);
        }
    }

    private void enableMaster() {
        String token1 = "#jonas.service.discovery.master";
        String value1 = DISCOVERY_MASTER_PROPERTY;
        JReplace propertyReplace1 = new JReplace();
        propertyReplace1.setLogInfo("[Discovery] Enable master node for discovery");
        propertyReplace1.setConfigurationFile("jonas.properties");
        propertyReplace1.setToken(token1);
        propertyReplace1.setValue(value1);
        this.addTask((Task)propertyReplace1);
        String token2 = "#jonas.service.discovery.source.port";
        String value2 = DISCOVERY_SOURCE_PORT_PROPERTY;
        JReplace propertyReplace2 = new JReplace();
        propertyReplace2.setLogInfo("[Discovery] Enable greeting timeout for discovery");
        propertyReplace2.setConfigurationFile("jonas.properties");
        propertyReplace2.setToken(token2);
        propertyReplace2.setValue(value2);
        this.addTask((Task)propertyReplace2);
    }

    private void enableGreeting() {
        String token1 = "#jonas.service.discovery.greeting.port";
        String value1 = DISCOVERY_GREETING_PORT_PROPERTY;
        JReplace propertyReplace1 = new JReplace();
        propertyReplace1.setLogInfo("[Discovery] Enable greeting port for discovery");
        propertyReplace1.setConfigurationFile("jonas.properties");
        propertyReplace1.setToken(token1);
        propertyReplace1.setValue(value1);
        this.addTask((Task)propertyReplace1);
        String token2 = "#jonas.service.discovery.greeting.timeout";
        String value2 = DISCOVERY_GREETING_TIMEOUT_PROPERTY;
        JReplace propertyReplace2 = new JReplace();
        propertyReplace2.setLogInfo("[Discovery] Enable greeting timeout for discovery");
        propertyReplace2.setConfigurationFile("jonas.properties");
        propertyReplace2.setToken(token2);
        propertyReplace2.setValue(value2);
        this.addTask((Task)propertyReplace2);
    }

    public void setGreetingPort(String portNumber) {
        this.enableGreeting();
        String token = "jonas.service.discovery.greeting.port=9899";
        String value = "jonas.service.discovery.greeting.port=" + portNumber;
        JReplace propertyReplace = new JReplace();
        propertyReplace.setLogInfo("[Discovery] Setting greeting port for discovery");
        propertyReplace.setConfigurationFile("jonas.properties");
        propertyReplace.setToken(token);
        propertyReplace.setValue(value);
        this.addTask((Task)propertyReplace);
    }

    public void setMcastAddr(String mcastAddr) {
        String token = "jonas.service.discovery.multicast.address=224.224.224.224";
        String value = "jonas.service.discovery.multicast.address=" + mcastAddr;
        JReplace propertyReplace = new JReplace();
        propertyReplace.setLogInfo("[Discovery] Setting mcastaddr for discovery");
        propertyReplace.setConfigurationFile("jonas.properties");
        propertyReplace.setToken(token);
        propertyReplace.setValue(value);
        this.addTask((Task)propertyReplace);
    }

    public void setMcastPort(String mcastPort) {
        String token = "jonas.service.discovery.multicast.port=9080";
        String value = "jonas.service.discovery.multicast.port=" + mcastPort;
        JReplace propertyReplace = new JReplace();
        propertyReplace.setLogInfo("[Discovery] Setting mcastport for discovery");
        propertyReplace.setConfigurationFile("jonas.properties");
        propertyReplace.setToken(token);
        propertyReplace.setValue(value);
        this.addTask((Task)propertyReplace);
    }

    public void setTtl(String ttl) {
        String token = "jonas.service.discovery.ttl=1";
        String value = "jonas.service.discovery.ttl=" + ttl;
        JReplace propertyReplace = new JReplace();
        propertyReplace.setLogInfo("[Discovery] Setting ttl for discovery");
        propertyReplace.setConfigurationFile("jonas.properties");
        propertyReplace.setToken(token);
        propertyReplace.setValue(value);
        this.addTask((Task)propertyReplace);
    }

    private void loadDomainXmlDoc() {
        if (!this.domainDocLoaded) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            try {
                docBuilder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new BuildException("[Discovery] Exception during setDomainName", (Throwable)e);
            }
            try {
                this.domainDoc = docBuilder.parse(this.jonasRoot + File.separator + "conf" + File.separator + DOMAIN_MNGT_CONF_FILE);
            }
            catch (SAXException e) {
                throw new BuildException("[Discovery] Error during parsing of the file domain.xml", (Throwable)e);
            }
            catch (IOException e) {
                throw new BuildException("[Discovery] Error during parsing of the file domain.xml", (Throwable)e);
            }
            Element root = this.domainDoc.getDocumentElement();
            NodeList serverNodeL = root.getElementsByTagName("server");
            for (int i = 0; i < serverNodeL.getLength(); ++i) {
                Node n = serverNodeL.item(i);
                root.removeChild(n);
            }
            XMLSerializerTask xmlSerTask = new XMLSerializerTask();
            xmlSerTask.setXmlDoc(this.domainDoc);
            xmlSerTask.setXmlFileName(DOMAIN_MNGT_CONF_FILE);
            this.addTask(xmlSerTask);
            this.domainDocLoaded = true;
        }
    }

    public void setDomainName(String domainName) {
        this.loadDomainXmlDoc();
        Element root = this.domainDoc.getDocumentElement();
        NodeList nameNodeL = root.getElementsByTagName("name");
        nameNodeL.item(0).getFirstChild().setNodeValue(domainName);
    }

    public void setDomainDesc(String domainDesc) {
        this.loadDomainXmlDoc();
        Element root = this.domainDoc.getDocumentElement();
        NodeList nameNodeL = root.getElementsByTagName("description");
        nameNodeL.item(0).getFirstChild().setNodeValue(domainDesc);
    }

    public void setDomainCluster(String clusterName, String clusterDesc, String nodesName, int nodesNb, String protocol, String[] portRange, String cdName, String cdUrl) {
        this.loadDomainXmlDoc();
        Element root = this.domainDoc.getDocumentElement();
        Element dnc = this.domainDoc.createElement("cluster-daemon");
        root.appendChild(dnc);
        Element dncn = this.domainDoc.createElement("name");
        dnc.appendChild(dncn);
        Text dtncn = this.domainDoc.createTextNode(cdName);
        dncn.appendChild(dtncn);
        Element dncd = this.domainDoc.createElement("description");
        dnc.appendChild(dncd);
        Text dtncd = this.domainDoc.createTextNode("");
        dncd.appendChild(dtncd);
        Element dncl = this.domainDoc.createElement("location");
        dnc.appendChild(dncl);
        Element dncu = this.domainDoc.createElement("url");
        dncl.appendChild(dncu);
        Text dtncu = this.domainDoc.createTextNode(cdUrl);
        dncu.appendChild(dtncu);
        Element cnc = this.domainDoc.createElement("cluster");
        root.appendChild(cnc);
        Element cncn = this.domainDoc.createElement("name");
        cnc.appendChild(cncn);
        Text ctncn = this.domainDoc.createTextNode(clusterName);
        cncn.appendChild(ctncn);
        Element cncd = this.domainDoc.createElement("description");
        cnc.appendChild(cncd);
        Text ctncd = this.domainDoc.createTextNode(clusterDesc);
        cncd.appendChild(ctncd);
        for (int i = 1; i <= nodesNb; ++i) {
            String scheme;
            Element cncs = this.domainDoc.createElement("server");
            cnc.appendChild(cncs);
            Element cncsn = this.domainDoc.createElement("name");
            cncs.appendChild(cncsn);
            Text ctncsn = this.domainDoc.createTextNode(nodesName + i);
            cncsn.appendChild(ctncsn);
            Element cncsl = this.domainDoc.createElement("location");
            cncs.appendChild(cncsl);
            Element cncsu = this.domainDoc.createElement("url");
            cncsl.appendChild(cncsu);
            if (protocol.equals("jrmp") || protocol.equals("irmi")) {
                scheme = "rmi";
            } else if (protocol.equals("iiop")) {
                scheme = "iiop";
            } else {
                throw new BuildException("[Discovery] Unknown protocol '" + protocol + "' for node '" + i + "'.");
            }
            String url = "service:jmx:" + scheme + "://localhost/jndi/" + scheme + "://localhost:" + portRange[i - 1] + "/" + protocol + "connector_node" + i;
            Text ctncsu = this.domainDoc.createTextNode(url);
            cncsu.appendChild(ctncsu);
            Element cncscd = this.domainDoc.createElement("cluster-daemon");
            cncs.appendChild(cncscd);
            Text ctncscd = this.domainDoc.createTextNode(cdName);
            cncscd.appendChild(ctncscd);
        }
    }

    public void setJonasRoot(String jonasRoot) {
        this.jonasRoot = jonasRoot;
    }
}

