/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.osgi.core;

import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.component.api.EZBComponent;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.osgi.archive.BundleArchiveFactory;
import org.ow2.easybeans.osgi.extension.EasyBeansOSGiExtension;
import org.ow2.easybeans.server.EasyBeansConfigurationExtension;
import org.ow2.easybeans.server.Embedded;
import org.ow2.easybeans.server.ServerConfig;
import org.ow2.util.ee.deploy.api.archive.ArchiveFactory;
import org.ow2.util.ee.deploy.impl.archive.ArchiveManager;
import org.ow2.util.execution.ExecutionResult;
import org.ow2.util.execution.IExecution;
import org.ow2.util.execution.helper.RunnableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class EZBCoreService {
    private static Log logger = LogFactory.getLog(EZBCoreService.class);
    private Embedded embedded = null;
    private ServiceRegistration sr = null;
    private ArchiveFactory<BundleContext> factory = null;
    private List<EZBContainer> containers = new ArrayList<EZBContainer>();
    private List<EZBComponent> components = new ArrayList<EZBComponent>();
    private ComponentContext componentContext = null;

    public EZBCoreService() {
        this.embedded = new Embedded();
    }

    public void start() throws Exception {
        RunnableHelper runner = new RunnableHelper();
        ExecutionResult result = runner.execute(this.getClass().getClassLoader(), (IExecution)new IExecution<Embedded>(){

            public Embedded execute() throws Exception {
                ArchiveManager am = ArchiveManager.getInstance();
                EZBCoreService.this.factory = new BundleArchiveFactory();
                am.addFactory(EZBCoreService.this.factory);
                ServerConfig sc = new ServerConfig();
                sc.setShouldWait(false);
                sc.setDirectoryScanningEnabled(false);
                sc.setAddEmbeddedComponents(false);
                sc.setAutoConfigureComponents(false);
                EasyBeansOSGiExtension extension = new EasyBeansOSGiExtension();
                extension.setBundleContext(EZBCoreService.this.componentContext.getBundleContext());
                sc.addExtensionFactory((EasyBeansConfigurationExtension)extension);
                EZBCoreService.this.embedded.setServerConfig(sc);
                EZBCoreService.this.embedded.start();
                return EZBCoreService.this.embedded;
            }
        });
        if (result.getException() != null) {
            throw result.getException();
        }
        this.sr = this.componentContext.getBundleContext().registerService(Embedded.class.getName(), (Object)this.embedded, null);
    }

    public void stop() throws Exception {
        RunnableHelper runner = new RunnableHelper();
        ExecutionResult result = runner.execute(this.getClass().getClassLoader(), (IExecution)new IExecution<Embedded>(){

            public Embedded execute() throws Exception {
                if (EZBCoreService.this.factory != null) {
                    ArchiveManager am = ArchiveManager.getInstance();
                    am.removeFactory(EZBCoreService.this.factory);
                }
                if (EZBCoreService.this.sr != null) {
                    EZBCoreService.this.sr.unregister();
                }
                if (EZBCoreService.this.embedded != null) {
                    EZBCoreService.this.removeContainers();
                    EZBCoreService.this.removeComponents();
                    EZBCoreService.this.embedded.stop();
                }
                return EZBCoreService.this.embedded;
            }
        });
        if (result.getException() != null) {
            throw result.getException();
        }
        if (result.getResult() != null) {
            this.embedded = new Embedded();
        }
    }

    protected void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
        try {
            logger.info((Object)"Activating EasyBeans/OSGi/Core ", new Object[0]);
            this.start();
        }
        catch (Exception e) {
            logger.error((Object)"Cannot start the EasyBeans core", new Object[]{e});
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        this.componentContext = componentContext;
        try {
            logger.info((Object)"Deactivating EasyBeans/OSGi/Core ", new Object[0]);
            this.stop();
        }
        catch (Exception e) {
            logger.error((Object)"Cannot stop the EasyBeans core", new Object[]{e});
        }
    }

    public void removeContainer(EZBContainer container) {
        if (this.containers.contains(container)) {
            this.containers.remove(container);
            this.embedded.removeContainer(container);
        }
    }

    public void addContainer(EZBContainer container) {
        this.containers.add(container);
        this.embedded.addContainer(container);
    }

    public void addComponent(EZBComponent component) throws EZBComponentException {
        this.embedded.getComponentManager().addComponent(component);
        this.components.add(component);
    }

    public void removeComponent(EZBComponent component) {
        if (this.components.contains(component)) {
            this.components.remove(component);
            try {
                this.embedded.getComponentManager().removeComponent(component);
            }
            catch (EZBComponentException e) {
                logger.error((Object)"Cannot remove the component {0}", new Object[]{component, e});
            }
        }
    }

    private void removeContainers() {
        while (!this.containers.isEmpty()) {
            EZBContainer container = this.containers.get(0);
            this.removeContainer(container);
        }
    }

    private void removeComponents() throws EZBComponentException {
        while (!this.components.isEmpty()) {
            EZBComponent component = this.components.get(0);
            this.removeComponent(component);
        }
    }
}

