/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.ant.archive.exploded;

import java.io.File;
import java.util.List;
import org.apache.tools.ant.Project;
import org.ow2.easybeans.ant.archive.AbsArchive;
import org.ow2.easybeans.ant.archive.Ejb;
import org.ow2.easybeans.ant.archive.War;
import org.ow2.easybeans.ant.archive.api.IEar;
import org.ow2.easybeans.ant.archive.exploded.AbsExplodedArchive;
import org.ow2.easybeans.ant.archive.info.EarInfo;

public class EarExploded
extends AbsExplodedArchive
implements IEar {
    private static final String DEPLOYMENT_DESCRIPTOR = "META-INF/application.xml";
    private EarInfo earInfo = null;

    public EarExploded(Project p) {
        super(p);
    }

    public void setEarInfo(EarInfo earInfo) {
        this.setArchiveInfo(earInfo);
        this.earInfo = earInfo;
    }

    public String getDDStandardName() {
        return DEPLOYMENT_DESCRIPTOR;
    }

    public void execute() {
        this.earInfo.getDest().mkdirs();
        super.execute();
        List<Ejb> ejbs = this.earInfo.getEjbs();
        List<War> wars = this.earInfo.getWars();
        if (ejbs != null) {
            for (Ejb ejb : ejbs) {
                this.updateArchive(ejb);
                ejb.execute();
            }
        }
        if (wars != null) {
            for (War war : wars) {
                this.updateArchive(war);
                war.execute();
            }
        }
    }

    void updateArchive(AbsArchive archive) {
        archive.setDest(new File(this.earInfo.getDest(), archive.getDest().getName()));
    }
}

