/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ear.internal;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.deployment.InjectionHolder;
import org.ow2.easybeans.deployment.api.EZBInjectionHolder;
import org.ow2.easybeans.loader.EasyBeansClassLoader;
import org.ow2.easybeans.naming.context.ContextImpl;
import org.ow2.easybeans.persistence.PersistenceUnitManager;
import org.ow2.easybeans.persistence.api.EZBPersistenceUnitManager;
import org.ow2.easybeans.persistence.xml.PersistenceXmlFileAnalyzer;
import org.ow2.easybeans.persistence.xml.PersistenceXmlFileAnalyzerException;
import org.ow2.jonas.deployment.client.wrapper.ClientManagerWrapper;
import org.ow2.jonas.deployment.ear.EarDeploymentDesc;
import org.ow2.jonas.deployment.ear.EarDeploymentDescException;
import org.ow2.jonas.deployment.ear.wrapper.EarManagerWrapper;
import org.ow2.jonas.deployment.ejb.wrapper.EjbManagerWrapper;
import org.ow2.jonas.deployment.web.wrapper.WebManagerWrapper;
import org.ow2.jonas.ear.EarServiceException;
import org.ow2.jonas.ear.internal.EARModule;
import org.ow2.jonas.ejb.EJBService;
import org.ow2.jonas.generators.wsgen.wrapper.WsGenWrapper;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;
import org.ow2.jonas.lib.util.ModuleNamingUtils;
import org.ow2.jonas.resource.ResourceService;
import org.ow2.jonas.resource.ResourceServiceException;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.web.JWebContainerService;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.jonas.ws.WebServicesService;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.ee.deploy.api.deployable.CARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJB21Deployable;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.LibDeployable;
import org.ow2.util.ee.deploy.api.deployable.RARDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;
import org.ow2.util.url.URLUtilsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarDeployer
implements IDeployer {
    public static final String DEFAULT_FOLDER = "JOnAS-Deployer";
    private Log logger = LogFactory.getLog(EarDeployer.class);
    private WebServicesService wsService = null;
    private JmxService jmxService = null;
    private ResourceService resourceService = null;
    private EJBService ejb21Service = null;
    private JWebContainerService webContainerService = null;
    private ClassLoader appsClassLoader;
    private Map<URL, EARDeployable> ears = new HashMap<URL, EARDeployable>();
    private EZBServer embedded = null;

    public EZBServer getEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(EZBServer embedded) {
        this.embedded = embedded;
    }

    public void deploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof EARDeployable) {
            EARDeployable earDeployable = (EARDeployable)UnpackDeployableHelper.unpack((IDeployable)((EARDeployable)deployable), (String)"ear-deployer");
            this.deployEAR(earDeployable);
        }
    }

    protected void applyWSGenIfNeeded(IArchive archive) throws DeployerException {
        if (this.wsService == null) {
            this.logger.debug((Object)"The WS service is not present, no need to call WSGen", new Object[0]);
            return;
        }
        if (!this.wsService.isAutoWsGenEngaged()) {
            this.logger.debug((Object)"Automatic WsGen is not enabled, no need to call WSGen", new Object[0]);
            return;
        }
        WsGenWrapper wsgen = new WsGenWrapper();
        File earFile = null;
        try {
            earFile = URLUtils.urlToFile2((URL)archive.getURL());
        }
        catch (URLUtilsException e) {
            throw new DeployerException("Cannot get File from archive '" + archive + "'", (Throwable)e);
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get URL from archive '" + archive + "'", (Throwable)e);
        }
        try {
            wsgen.callWsGenExecute(earFile.getPath(), Boolean.valueOf(earFile.isDirectory()));
        }
        catch (Exception e) {
            throw new DeployerException("Cannot execute WSGen on archive '" + archive + "'", (Throwable)e);
        }
        try {
            if (wsgen.callWsGenIsInputModifed()) {
                this.logger.debug((Object)"The archive ''{0}'' has been modified by WSGen", new Object[]{archive});
            }
        }
        catch (Exception e) {
            throw new DeployerException("Cannot detect if the archive '" + archive + "' has been modified", (Throwable)e);
        }
    }

    protected void deployEAR(EARDeployable earDeployable) throws DeployerException {
        URL earURL;
        IArchive earArchive = earDeployable.getArchive();
        this.applyWSGenIfNeeded(earArchive);
        try {
            earURL = earArchive.getURL();
        }
        catch (ArchiveException e1) {
            throw new DeployerException("Cannot get URL from archive '" + earArchive + "'");
        }
        URLClassLoader loaderCls = new URLClassLoader(new URL[]{earURL}, this.appsClassLoader);
        EarDeploymentDesc earDD = null;
        URL applicationXML = null;
        try {
            applicationXML = earArchive.getResource("META-INF/application.xml");
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get resource META-INF/application.xml", (Throwable)e);
        }
        if (applicationXML != null) {
            try {
                earDD = EarManagerWrapper.getDeploymentDesc((EARDeployable)earDeployable, (ClassLoader)loaderCls);
            }
            catch (EarDeploymentDescException e) {
                String err = "Error in the Deployment descriptor '" + earDeployable.getOriginalDeployable() + "': " + (Object)((Object)e);
                this.logger.error((Object)err, new Object[0]);
                throw new EarServiceException(err, (Throwable)e);
            }
        }
        String[] securityRoles = new String[]{};
        if (earDD != null) {
            securityRoles = earDD.getSecurityRolesNames();
        }
        this.logger.debug((Object)"Creating the EAR classLoader", new Object[0]);
        JClassLoader earClassLoader = new JClassLoader(earURL.toExternalForm(), new URL[0], this.appsClassLoader);
        String[] roleNames = new String[securityRoles.length];
        String affRoleNames = "";
        for (int i = 0; i < securityRoles.length; ++i) {
            roleNames[i] = securityRoles[i];
            affRoleNames = affRoleNames + roleNames[i] + ";";
        }
        this.logger.debug((Object)"role names = ''{0}''", new Object[]{affRoleNames});
        ArrayList<URL> urlsEJB = new ArrayList<URL>();
        ArrayList<URL> urlsAltDDEJB = new ArrayList<URL>();
        Object path = null;
        for (EJBDeployable ejb : earDeployable.getEJBDeployables()) {
            try {
                urlsEJB.add(ejb.getArchive().getURL());
                urlsAltDDEJB.add(earDeployable.getAltDDURL((IDeployable)ejb));
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the archive '" + ejb.getArchive() + "'", (Throwable)e);
            }
        }
        ArrayList<URL> urlsWAR = new ArrayList<URL>();
        ArrayList<URL> urlslAtDDWAR = new ArrayList<URL>();
        for (WARDeployable war : earDeployable.getWARDeployables()) {
            try {
                urlsWAR.add(war.getArchive().getURL());
                urlslAtDDWAR.add(earDeployable.getAltDDURL((IDeployable)war));
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the archive '" + war.getArchive() + "'", (Throwable)e);
            }
        }
        ArrayList<URL> urlsRAR = new ArrayList<URL>();
        ArrayList<URL> urlsAtDDRAR = new ArrayList<URL>();
        for (RARDeployable rar : earDeployable.getRARDeployables()) {
            try {
                urlsRAR.add(rar.getArchive().getURL());
                urlsAtDDRAR.add(earDeployable.getAltDDURL((IDeployable)rar));
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the archive '" + rar.getArchive() + "'", (Throwable)e);
            }
        }
        ArrayList<URL> urlsClient = new ArrayList<URL>();
        ArrayList<URL> urlsAtDDClient = new ArrayList<URL>();
        for (CARDeployable car : earDeployable.getCARDeployables()) {
            try {
                urlsClient.add(car.getArchive().getURL());
                urlsAtDDClient.add(earDeployable.getAltDDURL((IDeployable)car));
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the archive '" + car.getArchive() + "'", (Throwable)e);
            }
        }
        EjbManagerWrapper.setAvailableEjbJarsAndAltDDs((URLClassLoader)earClassLoader, (URL[])urlsEJB.toArray(new URL[urlsEJB.size()]), (URL[])urlsAltDDEJB.toArray(new URL[urlsAltDDEJB.size()]));
        WebManagerWrapper.setAltDD((URLClassLoader)earClassLoader, (URL[])urlsWAR.toArray(new URL[urlsWAR.size()]), (URL[])urlslAtDDWAR.toArray(new URL[urlslAtDDWAR.size()]));
        ClientManagerWrapper.setAltDD((URLClassLoader)earClassLoader, (URL[])urlsClient.toArray(new URL[urlsClient.size()]), (URL[])urlsAtDDClient.toArray(new URL[urlsAtDDClient.size()]));
        this.deployRARs(earDeployable, earURL, (ClassLoader)earClassLoader);
        List ejb3s = earDeployable.getEJB3Deployables();
        List ejbs = earDeployable.getEJBDeployables();
        List libs = earDeployable.getLibDeployables();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (EJBDeployable ejb : ejbs) {
            try {
                urls.add(ejb.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the Archive '" + ejb.getArchive() + "'.", (Throwable)e);
            }
        }
        for (LibDeployable lib : libs) {
            try {
                urls.add(lib.getArchive().getURL());
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get the URL for the Archive '" + lib.getArchive() + "'.", (Throwable)e);
            }
        }
        URL[] arrayURLs = urls.toArray(new URL[urls.size()]);
        EasyBeansClassLoader ejbClassLoader = new EasyBeansClassLoader(arrayURLs, (ClassLoader)earClassLoader);
        List<IArchive> libArchives = this.getLibArchives(earDeployable);
        EZBPersistenceUnitManager persistenceUnitManager = this.getPersistenceUnitManager(earDeployable, (ClassLoader)ejbClassLoader);
        this.addEjbContextIdToList(earDeployable, new ArrayList<String>(), true);
        ArrayList<EZBContainer> containers = new ArrayList<EZBContainer>();
        for (EJB3Deployable ejb : ejb3s) {
            if (this.getEmbedded() == null) {
                throw new DeployerException("No EJB3 service, but there are EJB3s in the given EAR archive '" + earDeployable.getArchive() + "'.");
            }
            EZBContainer container = this.getEmbedded().createContainer(ejb.getArchive());
            container.setApplicationName(ModuleNamingUtils.fromURL((URL)earURL));
            container.setExtraArchives(libArchives);
            containers.add(container);
        }
        for (EZBContainer container : containers) {
            container.setClassLoader((ClassLoader)ejbClassLoader);
            container.setPersistenceUnitManager(persistenceUnitManager);
        }
        InjectionHolder ejbInjectionHolder = new InjectionHolder();
        ejbInjectionHolder.setPersistenceUnitManager(persistenceUnitManager);
        for (EZBContainer container : containers) {
            try {
                container.start();
            }
            catch (Exception e) {
                this.logger.error((Object)"Cannot start container {0}", new Object[]{container.getName(), e});
                try {
                    container.stop();
                    this.getEmbedded().removeContainer(container);
                }
                catch (Exception se) {
                    this.logger.error((Object)"Cannot stop failing container {0}", new Object[]{container.getName(), se});
                }
                throw new DeployerException("Container '" + container.getName() + "' has failed", (Throwable)e);
            }
        }
        this.deployEJB21s(earDeployable, earURL, (URLClassLoader)earClassLoader, (ClassLoader)ejbClassLoader, roleNames);
        this.linkPolicyObjects(earDeployable);
        this.commitEJBPolicyObjects(earDeployable);
        this.deployWARs(earDeployable, earURL, (ClassLoader)earClassLoader, (ClassLoader)ejbClassLoader, (EZBInjectionHolder)ejbInjectionHolder);
        this.commitWebBPolicyObjects(earDeployable);
        EARModule earModule = new EARModule(earDeployable, "");
        try {
            this.jmxService.registerMBean((Object)earModule);
        }
        catch (Exception e) {
            throw new DeployerException("Cannot register the MBean for the EAR Module of EARDeployable '" + earDeployable.getOriginalDeployable() + "'.", (Throwable)e);
        }
        if (this.ejb21Service != null) {
            this.ejb21Service.removeCache((ClassLoader)earClassLoader);
        }
        if (this.webContainerService != null) {
            this.webContainerService.removeCache((ClassLoader)earClassLoader);
        }
        if (this.wsService != null) {
            this.wsService.removeCache((ClassLoader)earClassLoader);
        }
        try {
            URL initialurl = ((EARDeployable)earDeployable.getOriginalDeployable()).getArchive().getURL();
            this.ears.put(initialurl, earDeployable);
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get  the url of the initial deployable for the EAR Module '" + earDeployable.getOriginalDeployable() + "'.", (Throwable)e);
        }
        this.logger.info((Object)"''{0}'' EAR Deployable is now deployed", new Object[]{earDeployable.getOriginalDeployable()});
    }

    protected EZBPersistenceUnitManager getPersistenceUnitManager(EARDeployable earDeployable, ClassLoader appClassLoader) {
        List libs = earDeployable.getLibDeployables();
        PersistenceUnitManager persistenceUnitManager = null;
        for (LibDeployable lib : libs) {
            PersistenceUnitManager builtPersistenceUnitManager = null;
            try {
                builtPersistenceUnitManager = PersistenceXmlFileAnalyzer.analyzePersistenceXmlFile((IArchive)lib.getArchive(), (ClassLoader)appClassLoader);
            }
            catch (PersistenceXmlFileAnalyzerException e) {
                throw new IllegalStateException("Failure when analyzing the persistence.xml file", e);
            }
            if (persistenceUnitManager != null) {
                if (builtPersistenceUnitManager == null) continue;
                persistenceUnitManager.addExtraPersistenceUnitInfos(builtPersistenceUnitManager.getPersistenceUnitInfos());
                continue;
            }
            persistenceUnitManager = builtPersistenceUnitManager;
        }
        return persistenceUnitManager;
    }

    protected void undeployEAR(EARDeployable tmpEARDeployable) throws DeployerException {
        List ejb21Deployables;
        URL earURL;
        this.logger.info((Object)"Undeploying {0}", new Object[]{tmpEARDeployable});
        EARDeployable earDeployable = tmpEARDeployable;
        try {
            earURL = earDeployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the URL on the EAR deployable '" + earDeployable + "'.", (Throwable)e);
        }
        EARDeployable unpackedDeployable = (EARDeployable)earDeployable.getUnpackedDeployable();
        if (unpackedDeployable != null) {
            earDeployable = unpackedDeployable;
        } else if (this.ears.containsKey(earURL)) {
            earDeployable = this.ears.get(earURL);
        }
        List warDeployables = earDeployable.getWARDeployables();
        if (warDeployables != null && this.webContainerService != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (WARDeployable warDeployable : warDeployables) {
                try {
                    urls.add(warDeployable.getArchive().getURL());
                }
                catch (ArchiveException e) {
                    this.logger.error((Object)"Cannot get the URL from the Deployable ''{0}''", new Object[]{warDeployable, e});
                }
            }
            URL[] warURLs = urls.toArray(new URL[urls.size()]);
            this.webContainerService.unDeployWars(warURLs);
        }
        if ((ejb21Deployables = earDeployable.getEJB21Deployables()) != null && this.ejb21Service != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (EJB21Deployable ejbDeployable : ejb21Deployables) {
                try {
                    urls.add(ejbDeployable.getArchive().getURL());
                }
                catch (ArchiveException e) {
                    this.logger.error((Object)"Cannot get the URL from the Deployable ''{0}''", new Object[]{ejbDeployable, e});
                }
            }
            URL[] ejbJarURLs = urls.toArray(new URL[urls.size()]);
            this.ejb21Service.unDeployJars(ejbJarURLs);
        }
        this.undeployEJB3FromEAR(earDeployable);
        List rarDeployables = earDeployable.getRARDeployables();
        if (rarDeployables != null && this.resourceService != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (RARDeployable rarDeployable : rarDeployables) {
                try {
                    urls.add(rarDeployable.getArchive().getURL());
                }
                catch (ArchiveException e) {
                    this.logger.error((Object)"Cannot get the URL from the Deployable ''{0}''", new Object[]{rarDeployable, e});
                }
            }
            URL[] rarURLs = urls.toArray(new URL[urls.size()]);
            this.resourceService.unDeployRars(rarURLs, earURL);
        }
        EARModule earModule = new EARModule(earDeployable, "");
        try {
            this.jmxService.unregisterMBean((Object)earModule);
        }
        catch (Exception e) {
            throw new DeployerException("Cannot unregister the MBean for the EAR Module of EARDeployable '" + earDeployable + "'.", (Throwable)e);
        }
        this.ears.remove(earURL);
        this.logger.info((Object)"''{0}'' EAR Deployable is now undeployed", new Object[]{tmpEARDeployable});
    }

    protected void undeployEJB3FromEAR(EARDeployable earDeployable) throws DeployerException {
        EARDeployable workingDeployable = earDeployable;
        EARDeployable unpackedDeployable = (EARDeployable)earDeployable.getUnpackedDeployable();
        if (unpackedDeployable != null) {
            workingDeployable = unpackedDeployable;
        }
        ArrayList<EZBContainer> containers = new ArrayList<EZBContainer>();
        for (EJB3Deployable ejb3 : workingDeployable.getEJB3Deployables()) {
            EZBContainer container = this.getEmbedded().findContainer(ejb3.getArchive());
            if (container == null) {
                this.logger.warn((Object)"No container found for the archive ''{0}'', creation has maybe failed", new Object[]{ejb3.getArchive()});
                continue;
            }
            containers.add(container);
        }
        for (EZBContainer container : containers) {
            container.stop();
            this.getEmbedded().removeContainer(container);
        }
    }

    private void check(IDeployable<?> deployable) throws DeployerException {
        if (!this.supports(deployable)) {
            throw new DeployerException("The deployment of the deployable'" + deployable + "' is not supported by this deployer.");
        }
    }

    public void undeploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof EARDeployable) {
            this.undeployEAR((EARDeployable)deployable);
        }
    }

    public boolean isDeployed(IDeployable<?> deployable) throws DeployerException {
        throw new UnsupportedOperationException("IsDeployed not yet supported");
    }

    public boolean supports(IDeployable<?> deployable) {
        return deployable instanceof EARDeployable;
    }

    protected void deployWARs(EARDeployable earDeployable, URL earURL, ClassLoader earClassLoader, ClassLoader parentClassLoader, EZBInjectionHolder ejbInjectionHolder) throws DeployerException {
        List wars = earDeployable.getWARDeployables();
        if (wars.size() > 0) {
            if (this.webContainerService == null) {
                this.logger.warn((Object)"There are WAR files in the EAR ''{0}'' but the 'web' service is not available", new Object[]{earDeployable});
                return;
            }
            ContextImpl ctx = new ContextImpl(earURL.toExternalForm());
            try {
                ctx.rebind("earURL", (Object)earURL);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the EAR URL parameter '" + earURL + "'", (Throwable)e);
            }
            LinkedList<URL> urls = new LinkedList<URL>();
            LinkedList<String> ctxRoots = new LinkedList<String>();
            for (WARDeployable warDeployable : wars) {
                URL url = null;
                try {
                    url = warDeployable.getArchive().getURL();
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get the URL for the archive '" + warDeployable.getArchive() + "'", (Throwable)e);
                }
                urls.add(url);
                ctxRoots.add(warDeployable.getContextRoot());
            }
            try {
                ctx.rebind("urls", (Object)urls.toArray(new URL[urls.size()]));
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the urls parameter '" + urls + "'", (Throwable)e);
            }
            try {
                ctx.rebind("parentClassLoader", (Object)parentClassLoader);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the parentClassLoader parameter '" + parentClassLoader + "'", (Throwable)e);
            }
            try {
                ctx.rebind("earClassLoader", (Object)earClassLoader);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the earClassLoader parameter '" + earClassLoader + "'", (Throwable)e);
            }
            try {
                ctx.rebind("altDDs", (Object)new URL[urls.size()]);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the altDDs parameter.'", (Throwable)e);
            }
            try {
                ctx.rebind("contextRoots", (Object)ctxRoots.toArray(new String[ctxRoots.size()]));
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the contextRoots parameter '" + urls + "'", (Throwable)e);
            }
            try {
                ctx.rebind(EZBInjectionHolder.class.getName(), (Object)ejbInjectionHolder);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the ejb injection holder parameter '" + ejbInjectionHolder + "'", (Throwable)e);
            }
            try {
                this.webContainerService.deployWars((Context)ctx);
            }
            catch (JWebContainerServiceException e) {
                throw new DeployerException("Cannot deploy the WARs.'", (Throwable)e);
            }
        }
    }

    protected void deployEJB21s(EARDeployable earDeployable, URL earURL, URLClassLoader earClassLoader, ClassLoader ejbClassLoader, String[] roleNames) throws DeployerException {
        List ejbs = earDeployable.getEJB21Deployables();
        if (ejbs.size() > 0) {
            if (this.ejb21Service == null) {
                this.logger.warn((Object)"There are EJB 2.1 files in the EAR ''{0}'' but the EJB 2.1 service is not available", new Object[]{earDeployable});
                return;
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            for (EJB21Deployable ejb21Deployable : ejbs) {
                try {
                    urls.add(ejb21Deployable.getArchive().getURL());
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get the URL for the archive '" + ejb21Deployable.getArchive() + "'", (Throwable)e);
                }
            }
            URL[] compilationURLs = null;
            URL[] myApplicationJars = earClassLoader.getURLs();
            URL[] appsJars = ((URLClassLoader)earClassLoader.getParent()).getURLs();
            compilationURLs = new URL[myApplicationJars.length + appsJars.length + urls.size()];
            System.arraycopy(urls.toArray(new URL[urls.size()]), 0, compilationURLs, 0, urls.size());
            System.arraycopy(appsJars, 0, compilationURLs, urls.size(), appsJars.length);
            System.arraycopy(myApplicationJars, 0, compilationURLs, urls.size() + appsJars.length, myApplicationJars.length);
            for (EJB21Deployable ejb : ejbs) {
                URL ejbURL = null;
                try {
                    ejbURL = ejb.getArchive().getURL();
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get the URL on the deployable '" + ejb + "'", (Throwable)e);
                }
                this.logger.debug((Object)"Calling GenIC on the EJB ''{0}'' with compilation URL ''{1}''.", new Object[]{ejbURL, Arrays.asList(compilationURLs)});
                this.ejb21Service.checkGenIC(ejbURL.getFile(), compilationURLs);
            }
            ContextImpl ctx = new ContextImpl(earURL.toExternalForm());
            try {
                ctx.rebind("earUrl", (Object)earURL);
                ctx.rebind("earRootUrl", (Object)earURL);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the EAR URL parameter '" + earURL + "'", (Throwable)e);
            }
            try {
                ctx.rebind("jarURLs", (Object)urls.toArray(new URL[urls.size()]));
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the urls parameter '" + urls + "'", (Throwable)e);
            }
            try {
                ctx.rebind("earClassLoader", (Object)earClassLoader);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the earClassLoader parameter '" + earClassLoader + "'", (Throwable)e);
            }
            try {
                ctx.rebind("ejbClassLoader", (Object)ejbClassLoader);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the ejbClassLoader parameter '" + ejbClassLoader + "'", (Throwable)e);
            }
            try {
                ctx.rebind("roleNames", (Object)roleNames);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the altDDs parameter.'", (Throwable)e);
            }
            try {
                this.ejb21Service.deployJars((Context)ctx);
            }
            catch (ServiceException e) {
                throw new DeployerException("Cannot deploy the EJB 2.1'", (Throwable)e);
            }
        }
    }

    protected void deployRARs(EARDeployable earDeployable, URL earURL, ClassLoader earClassLoader) throws DeployerException {
        List rars = earDeployable.getRARDeployables();
        if (rars.size() > 0) {
            if (this.resourceService == null) {
                this.logger.warn((Object)"There are RAR files in the EAR ''{0}'' but the resource service is not available", new Object[]{earDeployable});
                return;
            }
            ContextImpl ctx = new ContextImpl(earURL.toExternalForm());
            try {
                ctx.rebind("earUrl", (Object)earURL);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the EAR URL parameter '" + earURL + "'", (Throwable)e);
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            for (RARDeployable rarDeployable : rars) {
                try {
                    urls.add(rarDeployable.getArchive().getURL());
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get the URL for the archive '" + rarDeployable.getArchive() + "'", (Throwable)e);
                }
            }
            try {
                ctx.rebind("urls", (Object)urls.toArray(new URL[urls.size()]));
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the urls parameter '" + urls + "'", (Throwable)e);
            }
            try {
                ctx.rebind("earClassLoader", (Object)earClassLoader);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the earClassLoader parameter '" + earClassLoader + "'", (Throwable)e);
            }
            try {
                ctx.rebind("altDDs", (Object)new URL[urls.size()]);
            }
            catch (NamingException e) {
                throw new DeployerException("Cannot add the altDDs parameter.'", (Throwable)e);
            }
            try {
                this.resourceService.deployRars((Context)ctx);
            }
            catch (ResourceServiceException e) {
                throw new DeployerException("Cannot deploy the RARs.'", (Throwable)e);
            }
        }
    }

    private void linkPolicyObjects(EARDeployable earDeployable) throws DeployerException {
        LinkedList<String> ctxIDs = new LinkedList<String>();
        this.addEjbContextIdToList(earDeployable, ctxIDs, false);
        this.addWebBContextIdToList(earDeployable, ctxIDs, true);
        try {
            for (String toBeLinkedCtxId : ctxIDs) {
                PolicyConfiguration toBeLinkedPC = this.getPolicyConfigurationFactory().getPolicyConfiguration(toBeLinkedCtxId, false);
                for (String linkedCtxId : ctxIDs) {
                    if (toBeLinkedCtxId.equals(linkedCtxId)) continue;
                    PolicyConfiguration linkedPC = this.getPolicyConfigurationFactory().getPolicyConfiguration(linkedCtxId, false);
                    toBeLinkedPC.linkConfiguration(linkedPC);
                }
            }
        }
        catch (PolicyContextException pce) {
            throw new DeployerException("Cannot retrieve a policy configuration", (Throwable)pce);
        }
    }

    private void addEjbContextIdToList(EARDeployable earDeployable, List<String> contextIDs, boolean resetPolicyConfiguration) throws DeployerException {
        List ejbDeployables = earDeployable.getEJBDeployables();
        ArrayList<URL> urls = new ArrayList<URL>();
        if (ejbDeployables != null) {
            for (EJBDeployable ejbDeployable : ejbDeployables) {
                try {
                    urls.add(ejbDeployable.getArchive().getURL());
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get URL on the deployable '" + ejbDeployable + "'.", (Throwable)e);
                }
            }
        }
        URL[] jarUrls = urls.toArray(new URL[urls.size()]);
        for (int u = 0; u < jarUrls.length; ++u) {
            String ctxId = jarUrls[u].getPath();
            if (resetPolicyConfiguration) {
                try {
                    this.getPolicyConfigurationFactory().getPolicyConfiguration(ctxId, true);
                }
                catch (PolicyContextException pce) {
                    throw new DeployerException("Cannot retrieve a policy configuration", (Throwable)pce);
                }
            }
            contextIDs.add(ctxId);
        }
    }

    private void addWebBContextIdToList(EARDeployable earDeployable, List<String> contextIDs, boolean resetPolicyConfiguration) throws DeployerException {
        List warDeployables = earDeployable.getWARDeployables();
        if (warDeployables != null) {
            for (WARDeployable warDeployable : warDeployables) {
                URL warURL = null;
                try {
                    warURL = warDeployable.getArchive().getURL();
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get URL on the deployable '" + warDeployable + "'.", (Throwable)e);
                }
                String ctxId = warURL.getFile() + warDeployable.getContextRoot();
                if (resetPolicyConfiguration) {
                    try {
                        this.getPolicyConfigurationFactory().getPolicyConfiguration(ctxId, true);
                    }
                    catch (PolicyContextException pce) {
                        throw new DeployerException("Cannot retrieve a policy configuration", (Throwable)pce);
                    }
                }
                contextIDs.add(ctxId);
            }
        }
    }

    private void commitEJBPolicyObjects(EARDeployable earDeployable) throws DeployerException {
        LinkedList<String> ctxIDs = new LinkedList<String>();
        this.addEjbContextIdToList(earDeployable, ctxIDs, false);
        this.commitPolicyObjects(ctxIDs);
    }

    private void commitWebBPolicyObjects(EARDeployable earDeployable) throws DeployerException {
        LinkedList<String> ctxIDs = new LinkedList<String>();
        this.addWebBContextIdToList(earDeployable, ctxIDs, false);
        this.commitPolicyObjects(ctxIDs);
    }

    private PolicyConfigurationFactory getPolicyConfigurationFactory() throws DeployerException {
        PolicyConfigurationFactory pcFactory = null;
        try {
            pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        }
        catch (Exception cnfe) {
            throw new DeployerException("Cannot retrieve current policy configuration factory", (Throwable)cnfe);
        }
        return pcFactory;
    }

    private void commitPolicyObjects(List<String> ctxIDs) throws DeployerException {
        String ctxId2 = null;
        try {
            for (String ctxId2 : ctxIDs) {
                PolicyConfiguration pc = this.getPolicyConfigurationFactory().getPolicyConfiguration(ctxId2, false);
                pc.commit();
            }
        }
        catch (PolicyContextException pce) {
            throw new DeployerException("Cannot commit policy configuration with Id '" + ctxId2 + "'", (Throwable)pce);
        }
        Policy.getPolicy().refresh();
    }

    public void setWsService(WebServicesService wsService) {
        this.wsService = wsService;
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public void setEjb21Service(EJBService ejb21Service) {
        this.ejb21Service = ejb21Service;
    }

    public void setJMXService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setWebContainerService(JWebContainerService webContainerService) {
        this.webContainerService = webContainerService;
    }

    public void setAppsClassLoader(ClassLoader appsClassLoader) {
        this.appsClassLoader = appsClassLoader;
    }

    protected List<IArchive> getLibArchives(EARDeployable earDeployable) {
        ArrayList<IArchive> libArchives = new ArrayList<IArchive>();
        for (LibDeployable lib : earDeployable.getLibDeployables()) {
            libArchives.add(lib.getArchive());
        }
        return libArchives;
    }
}

