/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ear.internal.mbean;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jonas.ear.internal.EARModule;
import org.ow2.jonas.lib.management.javaee.J2EEDeployedObjectMBean;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.util.ModuleNamingUtils;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EARModuleMBean
extends J2EEDeployedObjectMBean<EARModule> {
    private String[] modules = null;

    private void initModules() {
        ArrayList<String> modulesList = new ArrayList<String>();
        ObjectName objectName = null;
        try {
            objectName = ObjectName.getInstance(this.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Cannot get ObjectName on '" + this.getObjectName() + "'", e);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Cannot get ObjectName on '" + this.getObjectName() + "'", e);
        }
        String domain = objectName.getDomain();
        String serverName = objectName.getKeyProperty("J2EEServer");
        String appName = objectName.getKeyProperty("name");
        ObjectName modulesOn = null;
        modulesOn = J2eeObjectName.getEJBModules((String)domain, (String)serverName, (String)appName);
        this.addModuleObjectNames(modulesList, modulesOn);
        modulesOn = J2eeObjectName.getWebModules((String)domain, (String)serverName, (String)appName);
        this.addModuleObjectNames(modulesList, modulesOn);
        modulesOn = J2eeObjectName.getResourceAdapterModules((String)domain, (String)serverName, (String)appName);
        this.addModuleObjectNames(modulesList, modulesOn);
        modulesOn = J2eeObjectName.getAppClientModules((String)domain, (String)serverName, (String)appName);
        this.addModuleObjectNames(modulesList, modulesOn);
        this.modules = modulesList.toArray(new String[modulesList.size()]);
    }

    private void addModuleObjectNames(List<String> modulesList, ObjectName objectName) {
        Iterator<ObjectName> itNames = this.getRegistry().getMBeanServer().queryNames(objectName, null).iterator();
        while (itNames.hasNext()) {
            modulesList.add(itNames.next().toString());
        }
    }

    public String getName() {
        try {
            return ModuleNamingUtils.fromURL((URL)((EARModule)this.getManagedComponent()).getEARDeployable().getArchive().getURL());
        }
        catch (ArchiveException e) {
            throw new IllegalArgumentException("Cannot get Name from deployable '" + ((EARModule)this.getManagedComponent()).getEARDeployable() + "'.", e);
        }
    }

    public URL getEarUrl() {
        try {
            return ((EARDeployable)((EARModule)this.getManagedComponent()).getEARDeployable().getOriginalDeployable()).getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new IllegalArgumentException("Cannot get URL from deployable '" + ((EARModule)this.getManagedComponent()).getEARDeployable() + "'.", e);
        }
    }

    public String[] getModules() {
        if (this.modules == null) {
            this.initModules();
        }
        return this.modules;
    }
}

