/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.mux;

import java.io.Serializable;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.StateTransferException;
import org.jgroups.View;
import org.jgroups.mux.Multiplexer;
import org.jgroups.mux.MuxHeader;
import org.jgroups.stack.ProtocolStack;

public class MuxChannel
extends JChannel {
    private static final String name = "MUX";
    private final String id;
    private final String stack_name;
    private final MuxHeader hdr;
    private final Multiplexer mux;

    MuxChannel(String id, String stack_name, Multiplexer mux) {
        super(false);
        this.stack_name = stack_name;
        this.id = id;
        this.hdr = new MuxHeader(id);
        this.mux = mux;
        this.closed = !mux.isOpen();
    }

    public String getStackName() {
        return this.stack_name;
    }

    public String getId() {
        return this.id;
    }

    public Multiplexer getMultiplexer() {
        return this.mux;
    }

    public String getChannelName() {
        return this.mux.getChannel().getClusterName();
    }

    public String getClusterName() {
        return this.mux.getChannel().getClusterName();
    }

    public Address getLocalAddress() {
        return this.mux != null ? this.mux.getLocalAddress() : null;
    }

    public JChannel getChannel() {
        return this.mux.getChannel();
    }

    public View getView() {
        return this.closed || !this.connected ? null : this.mux.getServiceView(this.id);
    }

    public View getClusterView() {
        return this.mux != null ? this.mux.getChannel().getView() : null;
    }

    public ProtocolStack getProtocolStack() {
        return this.mux != null ? this.mux.getChannel().getProtocolStack() : null;
    }

    public Map dumpStats() {
        return this.mux.getChannel().dumpStats();
    }

    protected void setClosed(boolean f) {
        this.closed = f;
    }

    protected void setConnected(boolean f) {
        this.connected = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect(String channel_name) throws ChannelException, ChannelClosedException {
        this.checkClosed();
        if (this.connected) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("already connected to " + channel_name));
            }
            return;
        }
        this.mux.addServiceIfNotPresent(this.getId(), this);
        if (!this.mux.isConnected()) {
            this.mux.connect(this.getStackName());
        }
        try {
            boolean successfulFlush;
            if (this.mux.flushSupported() && !(successfulFlush = this.mux.startFlush(false)) && this.log.isWarnEnabled()) {
                this.log.warn((Object)("Flush failed at " + this.mux.getLocalAddress() + ":" + this.getId()));
            }
            this.mux.sendServiceUpMessage(this.getId(), this.mux.getLocalAddress(), true);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"failed sending SERVICE_UP message", (Throwable)e);
            }
        }
        finally {
            if (this.mux.flushSupported()) {
                this.mux.stopFlush();
            }
        }
        this.setClosed(false);
        this.setConnected(true);
        this.notifyChannelConnected(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect(String cluster_name, Address target, String state_id, long timeout) throws ChannelException {
        this.checkClosed();
        if (this.connected) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("already connected to " + cluster_name));
            }
            return;
        }
        this.mux.addServiceIfNotPresent(this.getId(), this);
        if (!this.mux.isConnected()) {
            this.mux.connect(this.getStackName());
        }
        try {
            boolean fetchState;
            block11: {
                boolean successfulFlush;
                if (this.mux.flushSupported() && !(successfulFlush = this.mux.startFlush(false)) && this.log.isWarnEnabled()) {
                    this.log.warn((Object)("Flush failed at " + this.mux.getLocalAddress() + ":" + this.getId()));
                }
                try {
                    this.mux.sendServiceUpMessage(this.getId(), this.mux.getLocalAddress(), true);
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block11;
                    this.log.error((Object)"failed sending SERVICE_UP message", (Throwable)e);
                }
            }
            View serviceView = this.mux.getServiceView(this.getId());
            boolean stateTransferOk = false;
            boolean bl = fetchState = serviceView != null && serviceView.size() > 1;
            if (fetchState && !(stateTransferOk = this.getState(target, state_id, timeout, false))) {
                throw new StateTransferException("Could not retrieve state " + state_id + " from " + target);
            }
        }
        finally {
            if (this.mux.flushSupported()) {
                this.mux.stopFlush();
            }
        }
        this.setClosed(false);
        this.setConnected(true);
        this.notifyChannelConnected(this);
    }

    public synchronized void disconnect() {
        if (!this.connected) {
            return;
        }
        this.setClosed(false);
        this.setConnected(false);
        this.notifyServiceDown();
        this.mux.disconnect();
        this.notifyChannelDisconnected(this);
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (this.isConnected()) {
            this.notifyServiceDown();
            this.setConnected(false);
        }
        this.setClosed(true);
        this.closeMessageQueue(true);
        this.notifyChannelClosed(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyServiceDown() {
        try {
            boolean successfulFlush;
            if (this.mux.flushSupported() && !(successfulFlush = this.mux.startFlush(false)) && this.log.isWarnEnabled()) {
                this.log.warn((Object)("Flush failed at " + this.mux.getLocalAddress() + ":" + this.getId()));
            }
            try {
                this.mux.sendServiceDownMessage(this.getId(), this.mux.getLocalAddress(), true);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"failed sending SERVICE_DOWN message", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"closing channel failed", t);
        }
        finally {
            if (this.mux.flushSupported()) {
                this.mux.stopFlush();
            }
        }
    }

    public synchronized void open() throws ChannelException {
        if (!this.mux.isOpen()) {
            this.mux.open();
        }
        this.setClosed(false);
        this.setConnected(false);
    }

    protected void _close(boolean disconnect, boolean close_mq) {
        super._close(disconnect, close_mq);
        this.setClosed(!this.mux.isOpen());
        this.setConnected(this.mux.isConnected());
        this.notifyChannelClosed(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (this.closed) {
            return;
        }
        this.setClosed(true);
        this.setConnected(false);
        try {
            boolean successfulFlush;
            if (this.mux.flushSupported() && !(successfulFlush = this.mux.startFlush(false)) && this.log.isWarnEnabled()) {
                this.log.warn((Object)("Flush failed at " + this.mux.getLocalAddress() + ":" + this.getId()));
            }
            try {
                this.mux.sendServiceDownMessage(this.getId(), this.mux.getLocalAddress(), true);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"failed sending SERVICE_DOWN message", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"shutdown channel failed", t);
        }
        finally {
            if (this.mux.flushSupported()) {
                this.mux.stopFlush();
            }
        }
        this.closeMessageQueue(true);
        this.notifyChannelClosed(this);
    }

    public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
        msg.putHeader(name, this.hdr);
        this.mux.getChannel().send(msg);
    }

    public void send(Address dst, Address src, Serializable obj) throws ChannelNotConnectedException, ChannelClosedException {
        this.send(new Message(dst, src, obj));
    }

    public void down(Event evt) {
        if (evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            msg.putHeader(name, this.hdr);
        }
        this.mux.getChannel().down(evt);
    }

    public Object downcall(Event evt) {
        if (evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            msg.putHeader(name, this.hdr);
        }
        return this.mux.getChannel().downcall(evt);
    }

    public boolean getState(Address target, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        return this.getState(target, null, timeout);
    }

    public boolean getState(Address target, String state_id, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        return this.getState(target, state_id, timeout, true);
    }

    public boolean getState(Address target, String state_id, long timeout, boolean useFlushIfPresent) throws ChannelNotConnectedException, ChannelClosedException {
        String my_id = this.id;
        if (state_id != null) {
            my_id = my_id + "::" + state_id;
        }
        Address service_view_coordinator = this.mux.getStateProvider(target, this.id);
        Address tmp = this.getLocalAddress();
        if (service_view_coordinator != null) {
            target = service_view_coordinator;
        }
        if (tmp != null && tmp.equals(target)) {
            target = null;
        }
        if (!this.mux.stateTransferListenersPresent()) {
            return this.mux.getChannel().getState(target, my_id, timeout, useFlushIfPresent);
        }
        return this.mux.getState(target, my_id, timeout);
    }

    public void returnState(byte[] state) {
        this.mux.getChannel().returnState(state, this.id);
    }

    public void returnState(byte[] state, String state_id) {
        String my_id = this.id;
        if (state_id != null) {
            my_id = my_id + "::" + state_id;
        }
        this.mux.getChannel().returnState(state, my_id);
    }
}

