/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.launcher.felix.util;

import java.io.File;
import java.io.IOException;

public final class IOUtils {
    private IOUtils() {
    }

    public static boolean deleteDir(File dir) {
        File candir;
        if (!dir.isDirectory()) {
            return false;
        }
        try {
            candir = dir.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        if (!candir.equals(dir.getAbsoluteFile())) {
            return false;
        }
        File[] files = candir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                boolean deleted = file.delete();
                if (deleted || !file.isDirectory()) continue;
                IOUtils.deleteDir(file);
            }
        }
        return dir.delete();
    }

    public static String getSystemPath(File base, String relative) {
        return IOUtils.getSystemFile(base, relative).getPath();
    }

    public static File getSystemFile(File base, String relative) {
        return new File(base, relative.replace('/', File.separatorChar));
    }
}

