/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.discovery.jgroups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.discovery.base.BaseDiscovery;
import org.ow2.jonas.discovery.jgroups.JgroupsDiscoveryServiceImplMBean;
import org.ow2.jonas.discovery.jgroups.comm.exception.StopDiscException;
import org.ow2.jonas.discovery.jgroups.manager.DiscoveryManager;
import org.ow2.jonas.discovery.jgroups.utils.JGroupsDiscoveryUtils;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.service.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JgroupsDiscoveryServiceImpl
extends BaseDiscovery
implements JgroupsDiscoveryServiceImplMBean,
Pojo {
    private InstanceManager _cm;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.discovery");
    private boolean _FgroupName;
    private String groupName;
    private boolean _Fconf;
    private String conf;
    private boolean _Fdm;
    private DiscoveryManager dm;
    private boolean _FmulticastAddress;
    String multicastAddress;
    private boolean _FmulticastPort;
    String multicastPort;
    private boolean _M$initorg_apache_felix_ipojo_InstanceManager;
    private boolean _MdoStart;
    private boolean _MstartDomainMonitorjava_lang_String;
    private boolean _Mstartjava_util_HashMapjavax_management_MBeanServerjava_lang_String;
    private boolean _MdoStop;
    private boolean _MgetDiscoveryProtocolVersion;
    private boolean _MgetDiscoveryTtl;
    private boolean _MstartDiscoveryMaster;
    private boolean _MgetJonasName;
    private boolean _MgetMbeanServer;
    private boolean _MgetMyOn;
    private boolean _MgetServerId;
    private boolean _MgetUrls;
    private boolean _MsetDomainNamejava_lang_String;
    private boolean _MsetJonasNamejava_lang_String;
    private boolean _MsetMbeanServerjavax_management_MBeanServer;
    private boolean _MsetMyOnjavax_management_ObjectName;
    private boolean _MsetServerIdjava_lang_String;
    private boolean _MsetTtlint;
    private boolean _MsetUrlsjava_lang_String$;
    private boolean _MtoArrayListjava_lang_String$;
    private boolean _Mstart;
    private boolean _Mstop;
    private boolean _MgetGroupName;
    private boolean _MsetGroupNamejava_lang_String;
    private boolean _MgetJgroupsConf;
    private boolean _MsetJgroupsConfjava_lang_String;
    private boolean _MsetMasterboolean;
    private boolean _MgetGreetingTimeout;
    private boolean _MgetJmxService;
    private boolean _MgetListeningIp;
    private boolean _MgetListeningPort;
    private boolean _MgetTtl;
    private boolean _MgetUrlsList;
    private boolean _MisDiscoveryMaster;
    private boolean _MsetJmxServiceorg_ow2_jonas_jmx_JmxService;
    private boolean _MsetListeningIpjava_lang_String;
    private boolean _MsetListeningPortint;
    private boolean _MsetUrlsListjava_util_ArrayList;
    private boolean _MgetGreetingListeningPort;
    private boolean _MsetTimeToLiveint;
    private boolean _MsetGreetingTimeoutint;
    private boolean _MgetIsDiscoveryMaster;
    private boolean _MgetMulticastAddress;
    private boolean _MgetMulticastPort;
    private boolean _MisMulticast;

    private String _getgroupName() {
        if (!this._FgroupName) {
            return this.groupName;
        }
        return (String)this._cm.getterCallback("groupName");
    }

    private void _setgroupName(String string) {
        if (!this._FgroupName) {
            this.groupName = string;
            return;
        }
        this._cm.setterCallback("groupName", (Object)string);
    }

    private String _getconf() {
        if (!this._Fconf) {
            return this.conf;
        }
        return (String)this._cm.getterCallback("conf");
    }

    private void _setconf(String string) {
        if (!this._Fconf) {
            this.conf = string;
            return;
        }
        this._cm.setterCallback("conf", (Object)string);
    }

    private DiscoveryManager _getdm() {
        if (!this._Fdm) {
            return this.dm;
        }
        return (DiscoveryManager)this._cm.getterCallback("dm");
    }

    private void _setdm(DiscoveryManager discoveryManager) {
        if (!this._Fdm) {
            this.dm = discoveryManager;
            return;
        }
        this._cm.setterCallback("dm", (Object)discoveryManager);
    }

    private String _getmulticastAddress() {
        if (!this._FmulticastAddress) {
            return this.multicastAddress;
        }
        return (String)this._cm.getterCallback("multicastAddress");
    }

    private void _setmulticastAddress(String string) {
        if (!this._FmulticastAddress) {
            this.multicastAddress = string;
            return;
        }
        this._cm.setterCallback("multicastAddress", (Object)string);
    }

    private String _getmulticastPort() {
        if (!this._FmulticastPort) {
            return this.multicastPort;
        }
        return (String)this._cm.getterCallback("multicastPort");
    }

    private void _setmulticastPort(String string) {
        if (!this._FmulticastPort) {
            this.multicastPort = string;
            return;
        }
        this._cm.setterCallback("multicastPort", (Object)string);
    }

    public JgroupsDiscoveryServiceImpl(InstanceManager _manager) {
        this._setComponentManager(_manager);
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.entryCallback("$initorg_apache_felix_ipojo_InstanceManager");
        }
        this._setdm(null);
        this._setmulticastAddress(null);
        this._setmulticastPort(null);
        Object var3_2 = null;
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.exitCallback("$initorg_apache_felix_ipojo_InstanceManager", var3_2);
        }
    }

    public void doStart() throws ServiceException {
        if (this._MdoStart) {
            this._cm.entryCallback("doStart");
        }
        String discoveryType = "SLAVE";
        this.isDiscoveryMaster = this.getServerProperties().isMaster();
        if (this.isDiscoveryMaster) {
            discoveryType = "MASTER";
        }
        logger.log(BasicLevel.DEBUG, (Object)("Starting discovery " + discoveryType + "on " + this.jmxService.getDomainName() + "for " + this.jmxService.getJonasServerName() + " server.\n"));
        logger = Log.getLogger((String)"org.ow2.jonas.discovery");
        String domainName = this.jmxService.getDomainName();
        JMXServiceURL[] connectorServerURLs = this.jmxService.getConnectorServerURLs();
        this.urlsList = new ArrayList();
        for (int i = 0; i < connectorServerURLs.length; ++i) {
            if (connectorServerURLs[i] == null) continue;
            this.urlsList.add(connectorServerURLs[i].toString());
        }
        String[] urls = new String[this.urlsList.size()];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = (String)this.urlsList.get(i);
        }
        try {
            JGroupsDiscoveryUtils.init(this.jmxService.getJonasServerName(), this.jmxService.getDomainName(), discoveryType, this._getconf(), this._getgroupName(), this.jmxService.getJmxServer(), urls);
        }
        catch (Throwable e) {
            ServiceException serviceException = new ServiceException(e.getMessage());
            if (this._MdoStart) {
                this._cm.exitCallback("doStart", (Object)serviceException);
            }
            throw serviceException;
        }
        this.startDomainMonitor(discoveryType);
        try {
            this._setmulticastAddress(JGroupsDiscoveryUtils.getMulticastAddress());
            this._setmulticastPort(JGroupsDiscoveryUtils.getMulticastPort());
        }
        catch (Exception e1) {
            logger.log(BasicLevel.DEBUG, (Object)"Cannot retrieve multicast address. Communication protocol is not multicast \n");
        }
        try {
            this.jmxService.registerMBean((Object)this, JonasObjectName.discoveryService((String)domainName));
        }
        catch (Exception e) {
            logger.log(BasicLevel.DEBUG, (Object)" Unable to register discovery MBean: ", (Throwable)e);
        }
        logger.log(BasicLevel.INFO, (Object)("JGroups based Discovery service started from " + this._getconf() + " Stack file \n"));
        Object var7_11 = null;
        if (this._MdoStart) {
            this._cm.exitCallback("doStart", var7_11);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void startDomainMonitor(String string) throws ServiceException {
        void discoveryType;
        if (this._MstartDomainMonitorjava_lang_String) {
            this._cm.entryCallback("startDomainMonitorjava_lang_String");
        }
        this.ttl = JGroupsDiscoveryUtils.getInstance().getTtl();
        this._setdm(new DiscoveryManager((String)discoveryType));
        try {
            this._getdm().start();
        }
        catch (StopDiscException e) {
            logger.log(BasicLevel.DEBUG, (Object)"Discovery manager failed to start due to a pre-existing server in the domain with the same name.", (Throwable)e);
            ServiceException serviceException = new ServiceException("Problem when starting the Discovery Service: ", (Throwable)e);
            if (this._MstartDomainMonitorjava_lang_String) {
                this._cm.exitCallback("startDomainMonitorjava_lang_String", (Object)serviceException);
            }
            throw serviceException;
        }
        Object var4_4 = null;
        if (this._MstartDomainMonitorjava_lang_String) {
            this._cm.exitCallback("startDomainMonitorjava_lang_String", var4_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void start(HashMap<String, Object> hashMap, MBeanServer mBeanServer, String string) throws Exception {
        void discoveryType;
        if (this._Mstartjava_util_HashMapjavax_management_MBeanServerjava_lang_String) {
            this._cm.entryCallback("startjava_util_HashMapjavax_management_MBeanServerjava_lang_String");
        }
        if (discoveryType.equals("CLUSTERD")) {
            void env;
            this.isDiscoveryMaster = false;
            this._setgroupName((String)env.get("group.name"));
            this._setconf((String)env.get("jgroups.conf"));
            String hostName = (String)env.get("host.name");
            String domainName = (String)env.get("domain.name");
            logger.log(BasicLevel.DEBUG, (Object)(" Cluster daemon named " + hostName + " is starting discovery on domain " + domainName + ".\n"));
            String[] urls = null;
            if (this.urlsList == null) {
                this.urlsList = new ArrayList();
                try {
                    urls = (String[])env.get("connector.urls");
                    for (int i = 0; i < urls.length; ++i) {
                        this.urlsList.add(urls[i]);
                    }
                }
                catch (Exception e) {
                    logger.log(BasicLevel.DEBUG, (Object)(" Exception occurred while getting connector urls for host named " + hostName + " in JGrpups discovery \n"));
                    Exception exception = new Exception(e.getMessage() + " Exception occurred while getting connector urls for host named " + hostName + " in JGrpups discovery \n");
                    if (this._Mstartjava_util_HashMapjavax_management_MBeanServerjava_lang_String) {
                        this._cm.exitCallback("startjava_util_HashMapjavax_management_MBeanServerjava_lang_String", (Object)exception);
                    }
                    throw exception;
                }
            }
            try {
                void mbeanSrv;
                JGroupsDiscoveryUtils.init(hostName, domainName, "CLUSTERD", this._getconf(), this._getgroupName(), (MBeanServer)mbeanSrv, urls);
            }
            catch (Throwable e) {
                ServiceException serviceException = new ServiceException(e.getMessage());
                if (this._Mstartjava_util_HashMapjavax_management_MBeanServerjava_lang_String) {
                    this._cm.exitCallback("startjava_util_HashMapjavax_management_MBeanServerjava_lang_String", (Object)serviceException);
                }
                throw serviceException;
            }
            this.startDomainMonitor((String)discoveryType);
        } else {
            logger.log(BasicLevel.DEBUG, (Object)" JOnAS instance should not use this method");
        }
        Object var10_12 = null;
        if (this._Mstartjava_util_HashMapjavax_management_MBeanServerjava_lang_String) {
            this._cm.exitCallback("startjava_util_HashMapjavax_management_MBeanServerjava_lang_String", var10_12);
        }
    }

    public void doStop() throws ServiceException {
        if (this._MdoStop) {
            this._cm.entryCallback("doStop");
        }
        this._getdm().stop();
        if (JGroupsDiscoveryUtils.isRegistered(JonasObjectName.discoveryService((String)JGroupsDiscoveryUtils.getInstance().getDomainName()))) {
            logger.log(BasicLevel.DEBUG, (Object)" Discovery MBean is unregistered from the host MBean server\n");
            try {
                JGroupsDiscoveryUtils.unRegisterMBean(JonasObjectName.discoveryService((String)JGroupsDiscoveryUtils.getInstance().getDomainName()));
            }
            catch (InstanceNotFoundException e) {
                ServiceException serviceException = new ServiceException(e.getMessage());
                if (this._MdoStop) {
                    this._cm.exitCallback("doStop", (Object)serviceException);
                }
                throw serviceException;
            }
            catch (MBeanRegistrationException e) {
                ServiceException serviceException = new ServiceException(e.getMessage());
                if (this._MdoStop) {
                    this._cm.exitCallback("doStop", (Object)serviceException);
                }
                throw serviceException;
            }
        }
        Object var4_5 = null;
        if (this._MdoStop) {
            this._cm.exitCallback("doStop", var4_5);
        }
    }

    public String getDiscoveryProtocolVersion() {
        if (this._MgetDiscoveryProtocolVersion) {
            this._cm.entryCallback("getDiscoveryProtocolVersion");
        }
        String string = "1.3";
        if (this._MgetDiscoveryProtocolVersion) {
            this._cm.exitCallback("getDiscoveryProtocolVersion", (Object)string);
        }
        return string;
    }

    public String getDiscoveryTtl() {
        if (this._MgetDiscoveryTtl) {
            this._cm.entryCallback("getDiscoveryTtl");
        }
        String string = new Integer(this.ttl).toString();
        if (this._MgetDiscoveryTtl) {
            this._cm.exitCallback("getDiscoveryTtl", (Object)string);
        }
        return string;
    }

    public void startDiscoveryMaster() throws JMException {
        if (this._MstartDiscoveryMaster) {
            this._cm.entryCallback("startDiscoveryMaster");
        }
        Object var1_1 = null;
        if (this._MstartDiscoveryMaster) {
            this._cm.exitCallback("startDiscoveryMaster", var1_1);
        }
    }

    public String getJonasName() {
        if (this._MgetJonasName) {
            this._cm.entryCallback("getJonasName");
        }
        String string = JGroupsDiscoveryUtils.getInstance().getJonasName();
        if (this._MgetJonasName) {
            this._cm.exitCallback("getJonasName", (Object)string);
        }
        return string;
    }

    public MBeanServer getMbeanServer() {
        if (this._MgetMbeanServer) {
            this._cm.entryCallback("getMbeanServer");
        }
        MBeanServer mBeanServer = this.jmxService.getJmxServer();
        if (this._MgetMbeanServer) {
            this._cm.exitCallback("getMbeanServer", (Object)mBeanServer);
        }
        return mBeanServer;
    }

    public ObjectName getMyOn() {
        if (this._MgetMyOn) {
            this._cm.entryCallback("getMyOn");
        }
        ObjectName objectName = JonasObjectName.discoveryService((String)JGroupsDiscoveryUtils.getInstance().getDomainName());
        if (this._MgetMyOn) {
            this._cm.exitCallback("getMyOn", (Object)objectName);
        }
        return objectName;
    }

    public String getServerId() {
        if (this._MgetServerId) {
            this._cm.entryCallback("getServerId");
        }
        String string = JGroupsDiscoveryUtils.getInstance().getServerId();
        if (this._MgetServerId) {
            this._cm.exitCallback("getServerId", (Object)string);
        }
        return string;
    }

    public String[] getUrls() {
        if (this._MgetUrls) {
            this._cm.entryCallback("getUrls");
        }
        String[] stringArray = (String[])this.urlsList.toArray();
        if (this._MgetUrls) {
            this._cm.exitCallback("getUrls", (Object)stringArray);
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    public void setDomainName(String string) {
        void domainName;
        if (this._MsetDomainNamejava_lang_String) {
            this._cm.entryCallback("setDomainNamejava_lang_String");
        }
        JGroupsDiscoveryUtils.getInstance().setDomainName((String)domainName);
        Object var2_2 = null;
        if (this._MsetDomainNamejava_lang_String) {
            this._cm.exitCallback("setDomainNamejava_lang_String", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setJonasName(String string) {
        void jonasName;
        if (this._MsetJonasNamejava_lang_String) {
            this._cm.entryCallback("setJonasNamejava_lang_String");
        }
        JGroupsDiscoveryUtils.getInstance().setJonasName((String)jonasName);
        Object var2_2 = null;
        if (this._MsetJonasNamejava_lang_String) {
            this._cm.exitCallback("setJonasNamejava_lang_String", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setMbeanServer(MBeanServer mBeanServer) {
        void mbeanServer;
        if (this._MsetMbeanServerjavax_management_MBeanServer) {
            this._cm.entryCallback("setMbeanServerjavax_management_MBeanServer");
        }
        JGroupsDiscoveryUtils.getInstance().setMbeanServer((MBeanServer)mbeanServer);
        Object var2_2 = null;
        if (this._MsetMbeanServerjavax_management_MBeanServer) {
            this._cm.exitCallback("setMbeanServerjavax_management_MBeanServer", var2_2);
        }
    }

    public void setMyOn(ObjectName objectName) {
        if (this._MsetMyOnjavax_management_ObjectName) {
            this._cm.entryCallback("setMyOnjavax_management_ObjectName");
        }
        Object var2_2 = null;
        if (this._MsetMyOnjavax_management_ObjectName) {
            this._cm.exitCallback("setMyOnjavax_management_ObjectName", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setServerId(String string) {
        void serverId;
        if (this._MsetServerIdjava_lang_String) {
            this._cm.entryCallback("setServerIdjava_lang_String");
        }
        JGroupsDiscoveryUtils.getInstance().setServerId((String)serverId);
        Object var2_2 = null;
        if (this._MsetServerIdjava_lang_String) {
            this._cm.exitCallback("setServerIdjava_lang_String", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTtl(int n) {
        void ttl;
        if (this._MsetTtlint) {
            this._cm.entryCallback("setTtlint");
        }
        this.ttl = ttl;
        Object var2_2 = null;
        if (this._MsetTtlint) {
            this._cm.exitCallback("setTtlint", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setUrls(String[] stringArray) {
        void urls;
        if (this._MsetUrlsjava_lang_String$) {
            this._cm.entryCallback("setUrlsjava_lang_String$");
        }
        this.urlsList = this.toArrayList((String[])urls);
        Object var2_2 = null;
        if (this._MsetUrlsjava_lang_String$) {
            this._cm.exitCallback("setUrlsjava_lang_String$", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList toArrayList(String[] stringArray) throws NullPointerException {
        if (this._MtoArrayListjava_lang_String$) {
            this._cm.entryCallback("toArrayListjava_lang_String$");
        }
        ArrayList<void> ret = new ArrayList<void>();
        try {
            void urls;
            for (int i = 0; i < ((void)urls).length; ++i) {
                ret.add(urls[i]);
            }
        }
        catch (NullPointerException e) {
            NullPointerException nullPointerException = new NullPointerException("NullPointerException occurred in JgroupsDiscoveryServiceImpl. Urls list must not be null in toArrayList method \n" + e);
            if (this._MtoArrayListjava_lang_String$) {
                this._cm.exitCallback("toArrayListjava_lang_String$", (Object)nullPointerException);
            }
            throw nullPointerException;
        }
        ArrayList<void> arrayList = ret;
        if (this._MtoArrayListjava_lang_String$) {
            this._cm.exitCallback("toArrayListjava_lang_String$", arrayList);
        }
        return arrayList;
    }

    public void start() throws ServiceException {
        if (this._Mstart) {
            this._cm.entryCallback("start");
        }
        this.doStart();
        Object var1_1 = null;
        if (this._Mstart) {
            this._cm.exitCallback("start", var1_1);
        }
    }

    public void stop() {
        if (this._Mstop) {
            this._cm.entryCallback("stop");
        }
        try {
            this.doStop();
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Unable to stop discovery service \n" + e));
        }
        logger.log(BasicLevel.INFO, (Object)"Discovery servive stopped \n");
        Object var2_2 = null;
        if (this._Mstop) {
            this._cm.exitCallback("stop", var2_2);
        }
    }

    public String getGroupName() {
        if (this._MgetGroupName) {
            this._cm.entryCallback("getGroupName");
        }
        String string = this._getgroupName();
        if (this._MgetGroupName) {
            this._cm.exitCallback("getGroupName", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public void setGroupName(String string) {
        void groupName;
        if (this._MsetGroupNamejava_lang_String) {
            this._cm.entryCallback("setGroupNamejava_lang_String");
        }
        this._setgroupName((String)groupName);
        Object var2_2 = null;
        if (this._MsetGroupNamejava_lang_String) {
            this._cm.exitCallback("setGroupNamejava_lang_String", var2_2);
        }
    }

    public String getJgroupsConf() {
        if (this._MgetJgroupsConf) {
            this._cm.entryCallback("getJgroupsConf");
        }
        String string = this._getconf();
        if (this._MgetJgroupsConf) {
            this._cm.exitCallback("getJgroupsConf", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public void setJgroupsConf(String string) {
        void conf;
        if (this._MsetJgroupsConfjava_lang_String) {
            this._cm.entryCallback("setJgroupsConfjava_lang_String");
        }
        this._setconf((String)conf);
        Object var2_2 = null;
        if (this._MsetJgroupsConfjava_lang_String) {
            this._cm.exitCallback("setJgroupsConfjava_lang_String", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setMaster(boolean bl) {
        void isMaster;
        if (this._MsetMasterboolean) {
            this._cm.entryCallback("setMasterboolean");
        }
        this.isDiscoveryMaster = isMaster;
        Object var2_2 = null;
        if (this._MsetMasterboolean) {
            this._cm.exitCallback("setMasterboolean", var2_2);
        }
    }

    public int getGreetingTimeout() {
        if (this._MgetGreetingTimeout) {
            this._cm.entryCallback("getGreetingTimeout");
        }
        Integer n = new Integer(this.greetingAckTimeOut);
        if (this._MgetGreetingTimeout) {
            this._cm.exitCallback("getGreetingTimeout", (Object)n);
        }
        return ((Number)n).intValue();
    }

    public JmxService getJmxService() {
        if (this._MgetJmxService) {
            this._cm.entryCallback("getJmxService");
        }
        JmxService jmxService = this.jmxService;
        if (this._MgetJmxService) {
            this._cm.exitCallback("getJmxService", (Object)jmxService);
        }
        return jmxService;
    }

    public String getListeningIp() {
        if (this._MgetListeningIp) {
            this._cm.entryCallback("getListeningIp");
        }
        String string = JGroupsDiscoveryUtils.getInstance().getLocalAddress().getIpAddress().toString();
        if (this._MgetListeningIp) {
            this._cm.exitCallback("getListeningIp", (Object)string);
        }
        return string;
    }

    public int getListeningPort() {
        if (this._MgetListeningPort) {
            this._cm.entryCallback("getListeningPort");
        }
        Integer n = new Integer(JGroupsDiscoveryUtils.getInstance().getDiscPort());
        if (this._MgetListeningPort) {
            this._cm.exitCallback("getListeningPort", (Object)n);
        }
        return ((Number)n).intValue();
    }

    public int getTtl() {
        if (this._MgetTtl) {
            this._cm.entryCallback("getTtl");
        }
        Integer n = new Integer(this.ttl);
        if (this._MgetTtl) {
            this._cm.exitCallback("getTtl", (Object)n);
        }
        return ((Number)n).intValue();
    }

    public ArrayList getUrlsList() {
        if (this._MgetUrlsList) {
            this._cm.entryCallback("getUrlsList");
        }
        ArrayList arrayList = this.urlsList;
        if (this._MgetUrlsList) {
            this._cm.exitCallback("getUrlsList", (Object)arrayList);
        }
        return arrayList;
    }

    public boolean isDiscoveryMaster() {
        if (this._MisDiscoveryMaster) {
            this._cm.entryCallback("isDiscoveryMaster");
        }
        Boolean bl = new Boolean(new Boolean(this.isDiscoveryMaster));
        if (this._MisDiscoveryMaster) {
            this._cm.exitCallback("isDiscoveryMaster", (Object)bl);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void setJmxService(JmxService jmxService) {
        void jmxService2;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.entryCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService");
        }
        this.jmxService = jmxService2;
        Object var2_2 = null;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.exitCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService", var2_2);
        }
    }

    public void setListeningIp(String string) {
        if (this._MsetListeningIpjava_lang_String) {
            this._cm.entryCallback("setListeningIpjava_lang_String");
        }
        Object var2_2 = null;
        if (this._MsetListeningIpjava_lang_String) {
            this._cm.exitCallback("setListeningIpjava_lang_String", var2_2);
        }
    }

    public void setListeningPort(int n) {
        if (this._MsetListeningPortint) {
            this._cm.entryCallback("setListeningPortint");
        }
        Object var2_2 = null;
        if (this._MsetListeningPortint) {
            this._cm.exitCallback("setListeningPortint", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setUrlsList(ArrayList arrayList) {
        void urlsList;
        if (this._MsetUrlsListjava_util_ArrayList) {
            this._cm.entryCallback("setUrlsListjava_util_ArrayList");
        }
        logger.log(BasicLevel.DEBUG, (Object)"Setting urls \n");
        this.urlsList = urlsList;
        Object var2_2 = null;
        if (this._MsetUrlsListjava_util_ArrayList) {
            this._cm.exitCallback("setUrlsListjava_util_ArrayList", var2_2);
        }
    }

    public int getGreetingListeningPort() {
        if (this._MgetGreetingListeningPort) {
            this._cm.entryCallback("getGreetingListeningPort");
        }
        logger.log(BasicLevel.DEBUG, (Object)"Getting listening port \n");
        Integer n = new Integer(JGroupsDiscoveryUtils.getInstance().getDiscPort());
        if (this._MgetGreetingListeningPort) {
            this._cm.exitCallback("getGreetingListeningPort", (Object)n);
        }
        return ((Number)n).intValue();
    }

    public void setTimeToLive(int n) {
        if (this._MsetTimeToLiveint) {
            this._cm.entryCallback("setTimeToLiveint");
        }
        logger.log(BasicLevel.DEBUG, (Object)"Setting ttl: not yet implemented \n");
        Object var2_2 = null;
        if (this._MsetTimeToLiveint) {
            this._cm.exitCallback("setTimeToLiveint", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setGreetingTimeout(int n) {
        void greetingAckTimeOut;
        if (this._MsetGreetingTimeoutint) {
            this._cm.entryCallback("setGreetingTimeoutint");
        }
        logger.log(BasicLevel.DEBUG, (Object)"Setting greeting timeout \n");
        this.greetingAckTimeOut = greetingAckTimeOut;
        Object var2_2 = null;
        if (this._MsetGreetingTimeoutint) {
            this._cm.exitCallback("setGreetingTimeoutint", var2_2);
        }
    }

    public Boolean getIsDiscoveryMaster() {
        if (this._MgetIsDiscoveryMaster) {
            this._cm.entryCallback("getIsDiscoveryMaster");
        }
        logger.log(BasicLevel.DEBUG, (Object)"Checking if discovery is master \n");
        Boolean bl = new Boolean(this.isDiscoveryMaster);
        if (this._MgetIsDiscoveryMaster) {
            this._cm.exitCallback("getIsDiscoveryMaster", (Object)bl);
        }
        return bl;
    }

    public String getMulticastAddress() {
        if (this._MgetMulticastAddress) {
            this._cm.entryCallback("getMulticastAddress");
        }
        String string = this._getmulticastAddress();
        if (this._MgetMulticastAddress) {
            this._cm.exitCallback("getMulticastAddress", (Object)string);
        }
        return string;
    }

    public String getMulticastPort() {
        if (this._MgetMulticastPort) {
            this._cm.entryCallback("getMulticastPort");
        }
        String string = this._getmulticastPort();
        if (this._MgetMulticastPort) {
            this._cm.exitCallback("getMulticastPort", (Object)string);
        }
        return string;
    }

    public String isMulticast() {
        if (this._MisMulticast) {
            this._cm.entryCallback("isMulticast");
        }
        String string = new Boolean(JGroupsDiscoveryUtils.getInstance().isMulticast()).toString();
        if (this._MisMulticast) {
            this._cm.exitCallback("isMulticast", (Object)string);
        }
        return string;
    }

    private void _setComponentManager(InstanceManager instanceManager) {
        this._cm = instanceManager;
        Set set = this._cm.getRegistredFields();
        if (set != null) {
            if (set.contains("conf")) {
                this._Fconf = true;
            }
            if (set.contains("multicastAddress")) {
                this._FmulticastAddress = true;
            }
            if (set.contains("dm")) {
                this._Fdm = true;
            }
            if (set.contains("groupName")) {
                this._FgroupName = true;
            }
            if (set.contains("logger")) {
                this._Flogger = true;
            }
            if (set.contains("multicastPort")) {
                this._FmulticastPort = true;
            }
        }
        if ((set = this._cm.getRegistredMethods()) != null) {
            if (set.contains("$initorg_apache_felix_ipojo_InstanceManager")) {
                this._M$initorg_apache_felix_ipojo_InstanceManager = true;
            }
            if (set.contains("doStart")) {
                this._MdoStart = true;
            }
            if (set.contains("startDomainMonitorjava_lang_String")) {
                this._MstartDomainMonitorjava_lang_String = true;
            }
            if (set.contains("startjava_util_HashMapjavax_management_MBeanServerjava_lang_String")) {
                this._Mstartjava_util_HashMapjavax_management_MBeanServerjava_lang_String = true;
            }
            if (set.contains("doStop")) {
                this._MdoStop = true;
            }
            if (set.contains("getDiscoveryProtocolVersion")) {
                this._MgetDiscoveryProtocolVersion = true;
            }
            if (set.contains("getDiscoveryTtl")) {
                this._MgetDiscoveryTtl = true;
            }
            if (set.contains("startDiscoveryMaster")) {
                this._MstartDiscoveryMaster = true;
            }
            if (set.contains("getJonasName")) {
                this._MgetJonasName = true;
            }
            if (set.contains("getMbeanServer")) {
                this._MgetMbeanServer = true;
            }
            if (set.contains("getMyOn")) {
                this._MgetMyOn = true;
            }
            if (set.contains("getServerId")) {
                this._MgetServerId = true;
            }
            if (set.contains("getUrls")) {
                this._MgetUrls = true;
            }
            if (set.contains("setDomainNamejava_lang_String")) {
                this._MsetDomainNamejava_lang_String = true;
            }
            if (set.contains("setJonasNamejava_lang_String")) {
                this._MsetJonasNamejava_lang_String = true;
            }
            if (set.contains("setMbeanServerjavax_management_MBeanServer")) {
                this._MsetMbeanServerjavax_management_MBeanServer = true;
            }
            if (set.contains("setMyOnjavax_management_ObjectName")) {
                this._MsetMyOnjavax_management_ObjectName = true;
            }
            if (set.contains("setServerIdjava_lang_String")) {
                this._MsetServerIdjava_lang_String = true;
            }
            if (set.contains("setTtlint")) {
                this._MsetTtlint = true;
            }
            if (set.contains("setUrlsjava_lang_String$")) {
                this._MsetUrlsjava_lang_String$ = true;
            }
            if (set.contains("toArrayListjava_lang_String$")) {
                this._MtoArrayListjava_lang_String$ = true;
            }
            if (set.contains("start")) {
                this._Mstart = true;
            }
            if (set.contains("stop")) {
                this._Mstop = true;
            }
            if (set.contains("getGroupName")) {
                this._MgetGroupName = true;
            }
            if (set.contains("setGroupNamejava_lang_String")) {
                this._MsetGroupNamejava_lang_String = true;
            }
            if (set.contains("getJgroupsConf")) {
                this._MgetJgroupsConf = true;
            }
            if (set.contains("setJgroupsConfjava_lang_String")) {
                this._MsetJgroupsConfjava_lang_String = true;
            }
            if (set.contains("setMasterboolean")) {
                this._MsetMasterboolean = true;
            }
            if (set.contains("getGreetingTimeout")) {
                this._MgetGreetingTimeout = true;
            }
            if (set.contains("getJmxService")) {
                this._MgetJmxService = true;
            }
            if (set.contains("getListeningIp")) {
                this._MgetListeningIp = true;
            }
            if (set.contains("getListeningPort")) {
                this._MgetListeningPort = true;
            }
            if (set.contains("getTtl")) {
                this._MgetTtl = true;
            }
            if (set.contains("getUrlsList")) {
                this._MgetUrlsList = true;
            }
            if (set.contains("isDiscoveryMaster")) {
                this._MisDiscoveryMaster = true;
            }
            if (set.contains("setJmxServiceorg_ow2_jonas_jmx_JmxService")) {
                this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("setListeningIpjava_lang_String")) {
                this._MsetListeningIpjava_lang_String = true;
            }
            if (set.contains("setListeningPortint")) {
                this._MsetListeningPortint = true;
            }
            if (set.contains("setUrlsListjava_util_ArrayList")) {
                this._MsetUrlsListjava_util_ArrayList = true;
            }
            if (set.contains("getGreetingListeningPort")) {
                this._MgetGreetingListeningPort = true;
            }
            if (set.contains("setTimeToLiveint")) {
                this._MsetTimeToLiveint = true;
            }
            if (set.contains("setGreetingTimeoutint")) {
                this._MsetGreetingTimeoutint = true;
            }
            if (set.contains("getIsDiscoveryMaster")) {
                this._MgetIsDiscoveryMaster = true;
            }
            if (set.contains("getMulticastAddress")) {
                this._MgetMulticastAddress = true;
            }
            if (set.contains("getMulticastPort")) {
                this._MgetMulticastPort = true;
            }
            if (set.contains("isMulticast")) {
                this._MisMulticast = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this._cm;
    }
}

