/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.rmi.multi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.ow2.carol.irmi.ClientInterceptor;
import org.ow2.carol.irmi.Interceptor;
import org.ow2.carol.irmi.PRO;
import org.ow2.carol.irmi.Server;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorHelper;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorStore;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorsKind;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JRMPClientRequestInfoImpl;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JRMPServerRequestInfoImpl;
import org.ow2.carol.rmi.jrmp.interceptor.spi.JClientRequestInterceptor;
import org.ow2.carol.rmi.jrmp.interceptor.spi.JServerRequestInterceptor;
import org.ow2.carol.rmi.jrmp.interceptor.spi.JServiceContext;
import org.ow2.carol.rmi.util.PortNumber;
import org.ow2.carol.util.configuration.ConfigurationRepository;

public class IrmiPRODelegate
extends PRO {
    private static Server getServer() {
        int port = 0;
        Properties prop = ConfigurationRepository.getProperties();
        if (prop != null) {
            String propertyName = "carol.irmi.server.port";
            port = PortNumber.strToint(prop.getProperty(propertyName, "0"), propertyName);
        }
        JInterceptorStore jiStore = JInterceptorStore.getJInterceptorStore();
        JInterceptorsKind interceptorsByType = JInterceptorHelper.getInterceptorsByType(jiStore.getJInterceptors());
        List<JServerRequestInterceptor> sistmp = interceptorsByType.getJServerRequestInterceptors();
        JServerRequestInterceptor[] sis = sistmp.toArray(new JServerRequestInterceptor[sistmp.size()]);
        List<JClientRequestInterceptor> cistmp = interceptorsByType.getJClientRequestInterceptors();
        JClientRequestInterceptor[] cis = cistmp.toArray(new JClientRequestInterceptor[cistmp.size()]);
        return new Server(port, (ClientInterceptor)new ClientInterceptorImpl(cis), (Interceptor)new ServerInterceptorImpl(sis));
    }

    public IrmiPRODelegate() {
        super(IrmiPRODelegate.getServer());
    }

    private static class ClientInterceptorImpl
    implements ClientInterceptor {
        private static final long serialVersionUID = -5212967521441892250L;
        private final JClientRequestInterceptor[] cis;

        public ClientInterceptorImpl(JClientRequestInterceptor[] cis) {
            this.cis = cis;
        }

        public void send(byte code, ObjectOutput out) throws IOException {
            JRMPClientRequestInfoImpl info = new JRMPClientRequestInfoImpl();
            for (JClientRequestInterceptor ci : this.cis) {
                ci.send_request(info);
            }
            Collection<JServiceContext> c = info.get_all_request_service_context();
            out.writeShort(c.size());
            for (JServiceContext jServiceContext : c) {
                out.writeObject(jServiceContext);
            }
        }

        public void receive(byte code, ObjectInput in) throws IOException, ClassNotFoundException {
            JRMPClientRequestInfoImpl info = new JRMPClientRequestInfoImpl();
            int len = in.readShort();
            for (int i = 0; i < len; ++i) {
                info.add_request_service_context((JServiceContext)in.readObject());
            }
            block5: for (JClientRequestInterceptor ci : this.cis) {
                switch (code) {
                    case 1: {
                        ci.receive_reply(info);
                        continue block5;
                    }
                    case 2: 
                    case 3: {
                        ci.receive_exception(info);
                    }
                }
            }
        }
    }

    private static class ServerInterceptorImpl
    implements Interceptor {
        private JServerRequestInterceptor[] sis;

        public ServerInterceptorImpl(JServerRequestInterceptor[] sis) {
            this.sis = sis;
        }

        public void receive(byte code, ObjectInput in) throws IOException, ClassNotFoundException {
            JRMPServerRequestInfoImpl info = new JRMPServerRequestInfoImpl();
            int len = in.readShort();
            for (int i = 0; i < len; ++i) {
                info.add_reply_service_context((JServiceContext)in.readObject());
            }
            for (JServerRequestInterceptor si : this.sis) {
                si.receive_request(info);
            }
        }

        public void send(byte code, ObjectOutput out) throws IOException {
            JRMPServerRequestInfoImpl info = new JRMPServerRequestInfoImpl();
            block4: for (JServerRequestInterceptor si : this.sis) {
                switch (code) {
                    case 1: {
                        si.send_reply(info);
                        continue block4;
                    }
                    case 2: 
                    case 3: {
                        si.send_exception(info);
                    }
                }
            }
            Collection<JServiceContext> c = info.get_all_reply_service_context();
            out.writeShort(c.size());
            for (JServiceContext jServiceContext : c) {
                out.writeObject(jServiceContext);
            }
        }
    }
}

