/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.NamingException;
import org.apache.AnnotationProcessor;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.util.DefaultAnnotationProcessor;
import org.apache.catalina.util.ServerInfo;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.security.SecurityService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.web.JWebContainerService;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.jonas.web.base.BaseWebContainerService;
import org.ow2.jonas.web.base.lib.PermissionManager;
import org.ow2.jonas.web.tomcat6.JCatalinaRuleSet;
import org.ow2.jonas.web.tomcat6.JOnASContextConfig;
import org.ow2.jonas.web.tomcat6.JOnASStandardContext;
import org.ow2.jonas.web.tomcat6.ResetAuthenticationValve;
import org.ow2.jonas.web.tomcat6.security.Realm;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tomcat6Service
extends BaseWebContainerService
implements JWebContainerService,
Pojo {
    private InstanceManager _cm;
    private static Log logger = LogFactory.getLog(Tomcat6Service.class);
    protected static final String CONFIG_FILE = "conf" + File.separator + "tomcat6-server.xml";
    private boolean _Fserver;
    private Server server;
    private boolean _FparentClassLoader;
    private ClassLoader parentClassLoader;
    private boolean _FcatalinaLoader;
    private ClassLoader catalinaLoader;
    private boolean _FtomcatStarted;
    private boolean tomcatStarted;
    private boolean _FsecurityService;
    private SecurityService securityService;
    private boolean _M$initorg_apache_felix_ipojo_InstanceManager;
    private boolean _MinitCatalinaEnvironment;
    private boolean _MdoStart;
    private boolean _MdoStop;
    private boolean _MdoRegisterWarjavax_naming_Context;
    private boolean _MgetConfiguredMatchingJonasContextsjava_lang_Stringjava_io_Filejava_lang_String;
    private boolean _McheckStartedContextorg_apache_catalina_Contextorg_ow2_jonas_web_base_lib_PermissionManager;
    private boolean _MgetEngines;
    private boolean _MgetContexts;
    private boolean _MdoUnRegisterWarjavax_naming_Context;
    private boolean _MremoveContextorg_apache_catalina_Context;
    private boolean _MisTomcatStarted;
    private boolean _MsetServerorg_apache_catalina_Server;
    private boolean _MgetConfigFile;
    private boolean _MfindHostjava_lang_String;
    private boolean _McreateServerDigester;
    private boolean _MupdateServerInfos;
    private boolean _MgetDefaultHost;
    private boolean _MgetDefaultHttpPort;
    private boolean _MgetFirstConnectorFromSchemejava_lang_String;
    private boolean _MgetFirstService;
    private boolean _MgetDefaultHttpsPort;
    private boolean _MregisterWarjava_lang_String;
    private boolean _MunRegisterWarjava_lang_String;
    private boolean _MsetSecurityServiceorg_ow2_jonas_security_SecurityService;

    private Server _getserver() {
        if (!this._Fserver) {
            return this.server;
        }
        return (Server)this._cm.getterCallback("server");
    }

    private void _setserver(Server server) {
        if (!this._Fserver) {
            this.server = server;
            return;
        }
        this._cm.setterCallback("server", (Object)server);
    }

    private ClassLoader _getparentClassLoader() {
        if (!this._FparentClassLoader) {
            return this.parentClassLoader;
        }
        return (ClassLoader)this._cm.getterCallback("parentClassLoader");
    }

    private void _setparentClassLoader(ClassLoader classLoader) {
        if (!this._FparentClassLoader) {
            this.parentClassLoader = classLoader;
            return;
        }
        this._cm.setterCallback("parentClassLoader", (Object)classLoader);
    }

    private ClassLoader _getcatalinaLoader() {
        if (!this._FcatalinaLoader) {
            return this.catalinaLoader;
        }
        return (ClassLoader)this._cm.getterCallback("catalinaLoader");
    }

    private void _setcatalinaLoader(ClassLoader classLoader) {
        if (!this._FcatalinaLoader) {
            this.catalinaLoader = classLoader;
            return;
        }
        this._cm.setterCallback("catalinaLoader", (Object)classLoader);
    }

    private boolean _gettomcatStarted() {
        if (!this._FtomcatStarted) {
            return this.tomcatStarted;
        }
        Object object = this._cm.getterCallback("tomcatStarted");
        Boolean bl = (Boolean)object;
        return bl;
    }

    private void _settomcatStarted(boolean bl) {
        if (!this._FtomcatStarted) {
            this.tomcatStarted = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this._cm.setterCallback("tomcatStarted", (Object)bl2);
    }

    private SecurityService _getsecurityService() {
        if (!this._FsecurityService) {
            return this.securityService;
        }
        return (SecurityService)this._cm.getterCallback("securityService");
    }

    private void _setsecurityService(SecurityService securityService) {
        if (!this._FsecurityService) {
            this.securityService = securityService;
            return;
        }
        this._cm.setterCallback("securityService", (Object)securityService);
    }

    public Tomcat6Service(InstanceManager _manager) {
        this._setComponentManager(_manager);
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.entryCallback("$initorg_apache_felix_ipojo_InstanceManager");
        }
        this._setserver(null);
        this._setparentClassLoader(null);
        this._setcatalinaLoader(null);
        this._settomcatStarted(false);
        this._setsecurityService(null);
        Object var3_2 = null;
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.exitCallback("$initorg_apache_felix_ipojo_InstanceManager", var3_2);
        }
    }

    protected void initCatalinaEnvironment() throws ServiceException {
        if (this._MinitCatalinaEnvironment) {
            this._cm.entryCallback("initCatalinaEnvironment");
        }
        String jonasRoot = System.getProperty("install.root");
        String jonasBase = System.getProperty("jonas.base");
        String catalinaHome = System.getProperty("catalina.home");
        String catalinaBase = System.getProperty("catalina.base");
        if (catalinaHome != null && !jonasRoot.equals(catalinaHome)) {
            logger.warn((Object)"The CATALINA_HOME property was set to ''{0}'', fix it by using JONAS_ROOT ''{1}''", new Object[]{catalinaHome, jonasRoot});
        }
        System.setProperty("catalina.home", jonasRoot);
        if (catalinaBase != null && !jonasBase.equals(catalinaBase)) {
            logger.warn((Object)"The CATALINA_BASE property was set to ''{0}'', fix it by using JONAS_BASE ''{1}''", new Object[]{catalinaBase, jonasBase});
        }
        System.setProperty("catalina.base", jonasBase);
        System.setProperty("catalina.useNaming", "false");
        Object var5_5 = null;
        if (this._MinitCatalinaEnvironment) {
            this._cm.exitCallback("initCatalinaEnvironment", var5_5);
        }
    }

    public void doStart() throws ServiceException {
        if (this._MdoStart) {
            this._cm.entryCallback("doStart");
        }
        this.initCatalinaEnvironment();
        LoaderManager lm = LoaderManager.getInstance();
        try {
            this._setparentClassLoader((ClassLoader)lm.getAppsLoader());
            this._setcatalinaLoader((ClassLoader)lm.getCatalinaLoader());
        }
        catch (Exception e1) {
            ServiceException serviceException = new ServiceException("Cannot get Application/Tomcat ClassLoader", (Throwable)e1);
            if (this._MdoStart) {
                this._cm.exitCallback("doStart", (Object)serviceException);
            }
            throw serviceException;
        }
        Digester digester = this.createServerDigester();
        File configFile = null;
        try {
            configFile = this.getConfigFile();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Cannot find the file ''{0}''", new Object[]{CONFIG_FILE, e});
            ServiceException serviceException = new ServiceException("Cannot find the configuration file", (Throwable)e);
            if (this._MdoStart) {
                this._cm.exitCallback("doStart", (Object)serviceException);
            }
            throw serviceException;
        }
        try {
            InputSource is = new InputSource("file://" + configFile.getAbsolutePath());
            FileInputStream fis = new FileInputStream(configFile);
            is.setByteStream(fis);
            digester.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            digester.push((Object)this);
            digester.parse(is);
            fis.close();
        }
        catch (Exception e) {
            logger.error((Object)"Cannot parse the configuration file ''{0}''", new Object[]{configFile, e});
            ServiceException serviceException = new ServiceException("Cannot parse the configuration file '" + configFile + "'", (Throwable)e);
            if (this._MdoStart) {
                this._cm.exitCallback("doStart", (Object)serviceException);
            }
            throw serviceException;
        }
        for (StandardEngine engine : this.getEngines()) {
            engine.setDomain(this.getDomainName());
            engine.setName(this.getDomainName());
        }
        IExecution<Void> startExec = new IExecution<Void>(){

            public Void execute() throws ServiceException {
                if (Tomcat6Service.this.server instanceof Lifecycle) {
                    try {
                        Tomcat6Service.this.server.initialize();
                        ((Lifecycle)Tomcat6Service.this.server).start();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Cannot start the Tomcat server", new Object[]{e});
                        throw new ServiceException("Cannot start the Tomcat server", (Throwable)e);
                    }
                }
                return null;
            }
        };
        ExecutionResult startExecResult = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)startExec);
        if (startExecResult.hasException()) {
            logger.error((Object)"Cannot start the Tomcat server", new Object[]{startExecResult.getException()});
            ServiceException serviceException = new ServiceException("Cannot start the Tomcat Server", (Throwable)startExecResult.getException());
            if (this._MdoStart) {
                this._cm.exitCallback("doStart", (Object)serviceException);
            }
            throw serviceException;
        }
        this._settomcatStarted(true);
        super.doStart();
        Object var10_13 = null;
        if (this._MdoStart) {
            this._cm.exitCallback("doStart", var10_13);
        }
    }

    protected void doStop() throws ServiceException {
        if (this._MdoStop) {
            this._cm.entryCallback("doStop");
        }
        super.doStop();
        if (this._getserver() instanceof Lifecycle) {
            try {
                ((Lifecycle)this._getserver()).stop();
            }
            catch (Exception e) {
                ServiceException serviceException = new ServiceException(e.getMessage(), (Throwable)e);
                if (this._MdoStop) {
                    this._cm.exitCallback("doStop", (Object)serviceException);
                }
                throw serviceException;
            }
        }
        Object var3_3 = null;
        if (this._MdoStop) {
            this._cm.exitCallback("doStop", var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doRegisterWar(javax.naming.Context context) throws JWebContainerServiceException {
        void ctx;
        if (this._MdoRegisterWarjavax_naming_Context) {
            this._cm.entryCallback("doRegisterWarjavax_naming_Context");
        }
        URL warURL = null;
        URL earURL = null;
        URL unpackedWarURL = null;
        String contextRoot = null;
        boolean java2DelegationModel = true;
        PermissionManager permissionManager = null;
        boolean inEarCase = true;
        String earAppName = null;
        String jonasDD = null;
        try {
            warURL = (URL)ctx.lookup("warURL");
            unpackedWarURL = (URL)ctx.lookup("unpackedWarURL");
            contextRoot = (String)ctx.lookup("contextRoot");
            Boolean bool = (Boolean)ctx.lookup("java2DelegationModel");
            java2DelegationModel = bool;
            jonasDD = (String)ctx.lookup("jonasDD");
            permissionManager = (PermissionManager)ctx.lookup("permissionManager");
        }
        catch (NamingException e) {
            logger.error((Object)"Unable to get default parameters", new Object[]{e});
            JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException("Unable to get default parameters", (Throwable)e);
            if (this._MdoRegisterWarjavax_naming_Context) {
                this._cm.exitCallback("doRegisterWarjavax_naming_Context", (Object)jWebContainerServiceException);
            }
            throw jWebContainerServiceException;
        }
        try {
            earAppName = (String)ctx.lookup("earAppName");
            earURL = (URL)ctx.lookup("earURL");
        }
        catch (NamingException e) {
            inEarCase = false;
            earURL = warURL;
        }
        ClassLoader webClassLoader = null;
        try {
            webClassLoader = (ClassLoader)ctx.lookup("parentCL");
        }
        catch (NamingException e) {
            logger.error((Object)"Unable to get parentCL parameter", new Object[]{e});
            JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException("Unable to get parentCL parameter", (Throwable)e);
            if (this._MdoRegisterWarjavax_naming_Context) {
                this._cm.exitCallback("doRegisterWarjavax_naming_Context", (Object)jWebContainerServiceException);
            }
            throw jWebContainerServiceException;
        }
        String hostName = null;
        try {
            hostName = (String)ctx.lookup("hostName");
        }
        catch (NamingException e) {
            hostName = "";
        }
        contextRoot = contextRoot.equals("/") ? "" : "/" + contextRoot;
        File fWar = new File(warURL.getFile());
        String destDir = null;
        destDir = fWar.isDirectory() ? warURL.getPath() : unpackedWarURL.getPath();
        File contextXmlFile = new File(destDir + File.separator + "META-INF" + File.separator + "context.xml");
        List<JOnASStandardContext> jonasContexts = this.getConfiguredMatchingJonasContexts(contextRoot, fWar, destDir);
        Host deployer = null;
        if (jonasContexts.isEmpty()) {
            deployer = this.findHost(hostName);
            JOnASStandardContext context2 = new JOnASStandardContext(false, java2DelegationModel, inEarCase);
            context2.setDocBase(destDir);
            context2.setPath(contextRoot);
            JOnASContextConfig config = new JOnASContextConfig();
            config.setSecurityService(this._getsecurityService());
            context2.addLifecycleListener((LifecycleListener)config);
            jonasContexts.add(context2);
        }
        for (JOnASStandardContext jStdCtx : jonasContexts) {
            jStdCtx.setTomcatService(this);
            jStdCtx.setParentClassLoader(webClassLoader);
            jStdCtx.setDelegate(java2DelegationModel);
            if (Tomcat6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                Tomcat6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Webapp class loader java 2 delegation model set to " + java2DelegationModel));
            }
            jStdCtx.addValve((Valve)new ResetAuthenticationValve());
            if (contextXmlFile.exists()) {
                jStdCtx.setConfigFile(contextXmlFile.getAbsolutePath());
            }
            javax.naming.Context envCtx = null;
            try {
                envCtx = (javax.naming.Context)this.getNaming().getComponentContext(webClassLoader).lookup("comp/env");
            }
            catch (NamingException e) {
                Tomcat6Service.getLogger().log(BasicLevel.ERROR, (Object)("Cannot get the context of the webapplication '" + warURL + "'."), (Throwable)e);
            }
            jStdCtx.setAnnotationProcessor((AnnotationProcessor)new DefaultAnnotationProcessor(envCtx));
            jStdCtx.setJ2EEServer(this.getJonasServerName());
            jStdCtx.setServer(J2eeObjectName.J2EEServer((String)this.getDomainName(), (String)this.getJonasServerName()).toString());
            MBeanServer mbeanServer = this.jmxService.getJmxServer();
            ObjectName j2eeServerOn = J2eeObjectName.J2EEServer((String)this.getDomainName(), (String)this.getJonasServerName());
            try {
                String[] as = (String[])mbeanServer.getAttribute(j2eeServerOn, "javaVMs");
                jStdCtx.setJavaVMs(as);
            }
            catch (Exception e) {
                Tomcat6Service.getLogger().log(BasicLevel.WARN, (Object)("Set MBean JVM error : " + e.getClass().getName() + " " + e.getMessage()));
            }
            if (earAppName != null) {
                jStdCtx.setJ2EEApplication(earAppName);
            }
            jStdCtx.setJonasDeploymentDescriptor(jonasDD);
            org.apache.catalina.Realm ctxRealm = jStdCtx.getRealm();
            if (ctxRealm == null) {
                ctxRealm = deployer.getRealm();
            }
            if (ctxRealm != null && ctxRealm instanceof Realm) {
                Realm jaccRealm = null;
                try {
                    jaccRealm = (Realm)((Realm)ctxRealm).clone();
                }
                catch (CloneNotSupportedException cnse) {
                    String err = "Cannot clone the realm used by the existing context or its parent realm";
                    Tomcat6Service.getLogger().log(BasicLevel.ERROR, (Object)(err + cnse.getMessage()));
                    JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException(err, (Throwable)cnse);
                    if (this._MdoRegisterWarjavax_naming_Context) {
                        this._cm.exitCallback("doRegisterWarjavax_naming_Context", (Object)jWebContainerServiceException);
                    }
                    throw jWebContainerServiceException;
                }
                if (Tomcat6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Tomcat6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Setting permission manager to " + permissionManager));
                }
                jaccRealm.setPermissionManager(permissionManager);
                jaccRealm.setSecurityService(this._getsecurityService());
                jaccRealm.setContext((Context)jStdCtx);
                jStdCtx.setRealm((org.apache.catalina.Realm)jaccRealm);
            }
            jStdCtx.setWarURL(warURL);
            if (inEarCase) {
                jStdCtx.setEarURL(earURL);
            }
            if (jStdCtx.isInServerXml()) {
                try {
                    jStdCtx.setLoader(null);
                    jStdCtx.start();
                }
                catch (LifecycleException lce) {
                    logger.error((Object)("Cannot start the context '" + (Object)((Object)jStdCtx) + "'."), new Object[]{lce});
                    JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException("Cannot start the context '" + (Object)((Object)jStdCtx) + "'.", (Throwable)lce);
                    if (this._MdoRegisterWarjavax_naming_Context) {
                        this._cm.exitCallback("doRegisterWarjavax_naming_Context", (Object)jWebContainerServiceException);
                    }
                    throw jWebContainerServiceException;
                }
            } else {
                if (deployer == null) {
                    logger.error((Object)("No deployer found for the deployment of the context '" + (Object)((Object)jStdCtx) + "'."), new Object[0]);
                    JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException("No deployer found for the deployment of the context '" + (Object)((Object)jStdCtx) + "'.");
                    if (this._MdoRegisterWarjavax_naming_Context) {
                        this._cm.exitCallback("doRegisterWarjavax_naming_Context", (Object)jWebContainerServiceException);
                    }
                    throw jWebContainerServiceException;
                }
                deployer.addChild((Container)jStdCtx);
            }
            this.checkStartedContext((Context)jStdCtx, permissionManager);
            try {
                ctx.rebind("WebModule", (Object)jStdCtx.createObjectName(this.getDomainName(), jStdCtx.getParentName()));
            }
            catch (Exception e) {
                String err = "Cannot rebind WebModule ObjectName in Context";
                Tomcat6Service.getLogger().log(BasicLevel.ERROR, (Object)err, (Throwable)e);
                JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException(err, (Throwable)e);
                if (this._MdoRegisterWarjavax_naming_Context) {
                    this._cm.exitCallback("doRegisterWarjavax_naming_Context", (Object)jWebContainerServiceException);
                }
                throw jWebContainerServiceException;
            }
        }
        Object var33_42 = null;
        if (this._MdoRegisterWarjavax_naming_Context) {
            this._cm.exitCallback("doRegisterWarjavax_naming_Context", var33_42);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected List<JOnASStandardContext> getConfiguredMatchingJonasContexts(String string, File file, String string2) {
        if (this._MgetConfiguredMatchingJonasContextsjava_lang_Stringjava_io_Filejava_lang_String) {
            this._cm.entryCallback("getConfiguredMatchingJonasContextsjava_lang_Stringjava_io_Filejava_lang_String");
        }
        ArrayList<JOnASStandardContext> jonasContexts = new ArrayList<JOnASStandardContext>();
        for (Context ctx : this.getContexts()) {
            void contextRoot;
            String serverCtxRoot;
            JOnASStandardContext jStdCtx;
            if (!(ctx instanceof JOnASStandardContext) || (jStdCtx = (JOnASStandardContext)ctx) == null || !jStdCtx.isInServerXml() || !(serverCtxRoot = jStdCtx.getPath()).equals(contextRoot)) continue;
            if (jStdCtx.getPrivileged()) {
                void fpackedWar;
                if (fpackedWar.isDirectory()) {
                    logger.error((Object)("Can deploy a privileged context '" + (Object)((Object)jStdCtx) + "' only if it's a war file (and not a directory)"), new Object[0]);
                }
                jStdCtx.setDocBase(fpackedWar.getPath());
            } else {
                void destDir;
                jStdCtx.setDocBase((String)destDir);
            }
            jonasContexts.add(jStdCtx);
        }
        ArrayList<JOnASStandardContext> arrayList = jonasContexts;
        if (this._MgetConfiguredMatchingJonasContextsjava_lang_Stringjava_io_Filejava_lang_String) {
            this._cm.exitCallback("getConfiguredMatchingJonasContextsjava_lang_Stringjava_io_Filejava_lang_String", arrayList);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkStartedContext(Context context, PermissionManager permissionManager) throws JWebContainerServiceException {
        void permissionManager2;
        Realm jaccRealm;
        PermissionManager ctxPerm;
        void context2;
        if (this._McheckStartedContextorg_apache_catalina_Contextorg_ow2_jonas_web_base_lib_PermissionManager) {
            this._cm.entryCallback("checkStartedContextorg_apache_catalina_Contextorg_ow2_jonas_web_base_lib_PermissionManager");
        }
        if (!context2.getConfigured()) {
            JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException("Context '" + context2 + "' was not configured");
            if (this._McheckStartedContextorg_apache_catalina_Contextorg_ow2_jonas_web_base_lib_PermissionManager) {
                this._cm.exitCallback("checkStartedContextorg_apache_catalina_Contextorg_ow2_jonas_web_base_lib_PermissionManager", (Object)jWebContainerServiceException);
            }
            throw jWebContainerServiceException;
        }
        org.apache.catalina.Realm ctxRealm = context2.getRealm();
        if (ctxRealm != null && ctxRealm instanceof Realm && (ctxPerm = (jaccRealm = (Realm)ctxRealm).getPermissionManager()) == null && permissionManager2 != null) {
            jaccRealm.setPermissionManager((PermissionManager)permissionManager2);
            jaccRealm.setContext((Context)context2);
        }
        if (Tomcat6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Tomcat6Service.getLogger().log(BasicLevel.DEBUG, (Object)("context " + context2 + " started"));
        }
        Object var7_7 = null;
        if (this._McheckStartedContextorg_apache_catalina_Contextorg_ow2_jonas_web_base_lib_PermissionManager) {
            this._cm.exitCallback("checkStartedContextorg_apache_catalina_Contextorg_ow2_jonas_web_base_lib_PermissionManager", var7_7);
        }
    }

    protected synchronized List<StandardEngine> getEngines() throws JWebContainerServiceException {
        if (this._MgetEngines) {
            this._cm.entryCallback("getEngines");
        }
        ArrayList<StandardEngine> engines = new ArrayList<StandardEngine>();
        Service[] services = this._getserver().findServices();
        for (int s = 0; s < services.length; ++s) {
            Container cont = services[s].getContainer();
            if (!(cont instanceof StandardEngine)) {
                String err = "The container of the service must be an engine (server.xml)";
                JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException(err);
                if (this._MgetEngines) {
                    this._cm.exitCallback("getEngines", (Object)jWebContainerServiceException);
                }
                throw jWebContainerServiceException;
            }
            engines.add((StandardEngine)cont);
        }
        ArrayList<StandardEngine> arrayList = engines;
        if (this._MgetEngines) {
            this._cm.exitCallback("getEngines", arrayList);
        }
        return arrayList;
    }

    protected synchronized List<Context> getContexts() throws JWebContainerServiceException {
        if (this._MgetContexts) {
            this._cm.entryCallback("getContexts");
        }
        ArrayList<Context> contexts = new ArrayList<Context>();
        for (StandardEngine engine : this.getEngines()) {
            Container[] hosts = engine.findChildren();
            for (int j = 0; j < hosts.length; ++j) {
                Container[] containers = hosts[j].findChildren();
                for (int k = 0; k < containers.length; ++k) {
                    Container container = containers[k];
                    if (!(container instanceof Context)) continue;
                    contexts.add((Context)container);
                }
            }
        }
        ArrayList<Context> arrayList = contexts;
        if (this._MgetContexts) {
            this._cm.exitCallback("getContexts", arrayList);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    protected void doUnRegisterWar(javax.naming.Context context) throws JWebContainerServiceException {
        void ctx;
        if (this._MdoUnRegisterWarjavax_naming_Context) {
            this._cm.entryCallback("doUnRegisterWarjavax_naming_Context");
        }
        String contextRoot = null;
        try {
            contextRoot = (String)ctx.lookup("contextRoot");
        }
        catch (NamingException e) {
            JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException("Unable to find the contextRoot parameter", (Throwable)e);
            if (this._MdoUnRegisterWarjavax_naming_Context) {
                this._cm.exitCallback("doUnRegisterWarjavax_naming_Context", (Object)jWebContainerServiceException);
            }
            throw jWebContainerServiceException;
        }
        contextRoot = contextRoot.equals("/") ? "" : "/" + contextRoot;
        String hostName = null;
        try {
            hostName = (String)ctx.lookup("hostName");
        }
        catch (NamingException e) {
            logger.debug((Object)"No hostname was defined for this context", new Object[0]);
        }
        if (hostName == null) {
            boolean found = false;
            for (Context context2 : this.getContexts()) {
                String serverCtxRoot = context2.getPath();
                if (!serverCtxRoot.equals(contextRoot)) continue;
                this.removeContext(context2);
                found = true;
                break;
            }
            if (!found) {
                JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException("Unable to remove a context with the context name '" + contextRoot + "'.");
                if (this._MdoUnRegisterWarjavax_naming_Context) {
                    this._cm.exitCallback("doUnRegisterWarjavax_naming_Context", (Object)jWebContainerServiceException);
                }
                throw jWebContainerServiceException;
            }
        } else {
            Host host = this.findHost(hostName);
            Context context3 = host.map(contextRoot);
            if (context3 != null) {
                this.removeContext(context3);
            } else {
                JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException("Unable to find a context for the given hostname '" + hostName + "'.");
                if (this._MdoUnRegisterWarjavax_naming_Context) {
                    this._cm.exitCallback("doUnRegisterWarjavax_naming_Context", (Object)jWebContainerServiceException);
                }
                throw jWebContainerServiceException;
            }
        }
        Object var11_15 = null;
        if (this._MdoUnRegisterWarjavax_naming_Context) {
            this._cm.exitCallback("doUnRegisterWarjavax_naming_Context", var11_15);
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void removeContext(Context context) throws JWebContainerServiceException {
        void context2;
        if (this._MremoveContextorg_apache_catalina_Context) {
            this._cm.entryCallback("removeContextorg_apache_catalina_Context");
        }
        boolean found = false;
        Iterator<Context> it = this.getContexts().iterator();
        while (it.hasNext() && !found) {
            if (context2 != it.next()) continue;
            found = true;
        }
        if (!found) {
            Object var4_4 = null;
            if (this._MremoveContextorg_apache_catalina_Context) {
                this._cm.exitCallback("removeContextorg_apache_catalina_Context", var4_4);
            }
            return;
        }
        if (context2 instanceof JOnASStandardContext) {
            JOnASStandardContext jctx = (JOnASStandardContext)context2;
            if (jctx.isInServerXml()) {
                try {
                    ((JOnASStandardContext)context2).stop();
                }
                catch (LifecycleException le) {
                    JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException("Cannot stop context (" + le.getMessage() + ")");
                    if (this._MremoveContextorg_apache_catalina_Context) {
                        this._cm.exitCallback("removeContextorg_apache_catalina_Context", (Object)jWebContainerServiceException);
                    }
                    throw jWebContainerServiceException;
                }
            } else {
                context2.getParent().removeChild((Container)context2);
                try {
                    this.jmxService.getJmxServer().unregisterMBean(jctx.getJmxName());
                }
                catch (Exception e) {
                    Tomcat6Service.getLogger().log(BasicLevel.ERROR, (Object)("Cannot remove the MBean for the WebModule " + jctx.getObjectName() + " : " + e.getMessage()));
                }
            }
        } else {
            context2.getParent().removeChild((Container)context2);
            if (context2 instanceof StandardContext) {
                StandardContext ctx = (StandardContext)context2;
                try {
                    this.jmxService.getJmxServer().unregisterMBean(ctx.getJmxName());
                }
                catch (Exception e) {
                    Tomcat6Service.getLogger().log(BasicLevel.ERROR, (Object)("Cannot remove the MBean for the WebModule " + ctx.getObjectName() + " : " + e.getMessage()));
                }
            }
        }
        Object var8_11 = null;
        if (this._MremoveContextorg_apache_catalina_Context) {
            this._cm.exitCallback("removeContextorg_apache_catalina_Context", var8_11);
        }
    }

    public boolean isTomcatStarted() {
        if (this._MisTomcatStarted) {
            this._cm.entryCallback("isTomcatStarted");
        }
        Boolean bl = new Boolean(this._gettomcatStarted());
        if (this._MisTomcatStarted) {
            this._cm.exitCallback("isTomcatStarted", (Object)bl);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void setServer(Server server) {
        void server2;
        if (this._MsetServerorg_apache_catalina_Server) {
            this._cm.entryCallback("setServerorg_apache_catalina_Server");
        }
        this._setserver((Server)server2);
        Object var2_2 = null;
        if (this._MsetServerorg_apache_catalina_Server) {
            this._cm.exitCallback("setServerorg_apache_catalina_Server", var2_2);
        }
    }

    protected File getConfigFile() throws FileNotFoundException {
        if (this._MgetConfigFile) {
            this._cm.entryCallback("getConfigFile");
        }
        String fileName = System.getProperty("catalina.base");
        File file = new File(fileName = fileName + File.separator + CONFIG_FILE);
        if (!file.exists()) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException("The configuration file '" + fileName + "' does not exists.");
            if (this._MgetConfigFile) {
                this._cm.exitCallback("getConfigFile", (Object)fileNotFoundException);
            }
            throw fileNotFoundException;
        }
        File file2 = file;
        if (this._MgetConfigFile) {
            this._cm.exitCallback("getConfigFile", (Object)file2);
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    public Host findHost(String string) throws JWebContainerServiceException {
        void hostName;
        Service[] services;
        if (this._MfindHostjava_lang_String) {
            this._cm.entryCallback("findHostjava_lang_String");
        }
        if ((services = this._getserver().findServices()).length < 1) {
            String err = "At least one service must be define in the server.xml of Tomcat";
            JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException(err);
            if (this._MfindHostjava_lang_String) {
                this._cm.exitCallback("findHostjava_lang_String", (Object)jWebContainerServiceException);
            }
            throw jWebContainerServiceException;
        }
        if (hostName == null || hostName.equals("")) {
            Service service = services[0];
            Container cont = service.getContainer();
            if (!(cont instanceof Engine)) {
                String err = "The container of the service must be an engine";
                JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException(err);
                if (this._MfindHostjava_lang_String) {
                    this._cm.exitCallback("findHostjava_lang_String", (Object)jWebContainerServiceException);
                }
                throw jWebContainerServiceException;
            }
            Engine engine = (Engine)cont;
            String defaultHost = engine.getDefaultHost();
            if (defaultHost == null) {
                String err = "Default host must be specified in server.xml or host must be specified in jonas-web.xml";
                JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException(err);
                if (this._MfindHostjava_lang_String) {
                    this._cm.exitCallback("findHostjava_lang_String", (Object)jWebContainerServiceException);
                }
                throw jWebContainerServiceException;
            }
            Container child = engine.findChild(defaultHost);
            if (child instanceof Host) {
                Host host = (Host)child;
                if (this._MfindHostjava_lang_String) {
                    this._cm.exitCallback("findHostjava_lang_String", (Object)host);
                }
                return host;
            }
            String err = "Default host " + defaultHost + " not found";
            JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException(err);
            if (this._MfindHostjava_lang_String) {
                this._cm.exitCallback("findHostjava_lang_String", (Object)jWebContainerServiceException);
            }
            throw jWebContainerServiceException;
        }
        ArrayList<Host> hosts = new ArrayList<Host>();
        for (int s = 0; s < services.length; ++s) {
            Container cont = services[s].getContainer();
            if (!(cont instanceof Engine)) {
                String err = "The container of a service must be an engine";
                JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException(err);
                if (this._MfindHostjava_lang_String) {
                    this._cm.exitCallback("findHostjava_lang_String", (Object)jWebContainerServiceException);
                }
                throw jWebContainerServiceException;
            }
            Engine engine = (Engine)cont;
            Container child = engine.findChild((String)hostName);
            if (!(child instanceof Host)) continue;
            hosts.add((Host)child);
        }
        if (hosts.size() == 0) {
            String err = "Host " + (String)hostName + " not found in all services/Engine of server.xml";
            JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException(err);
            if (this._MfindHostjava_lang_String) {
                this._cm.exitCallback("findHostjava_lang_String", (Object)jWebContainerServiceException);
            }
            throw jWebContainerServiceException;
        }
        Host host = (Host)hosts.get(0);
        if (this._MfindHostjava_lang_String) {
            this._cm.exitCallback("findHostjava_lang_String", (Object)host);
        }
        return host;
    }

    protected Digester createServerDigester() {
        if (this._McreateServerDigester) {
            this._cm.entryCallback("createServerDigester");
        }
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addRuleSet((RuleSet)new JCatalinaRuleSet(this._getparentClassLoader(), this._getsecurityService()));
        digester.setUseContextClassLoader(true);
        Digester digester2 = digester;
        if (this._McreateServerDigester) {
            this._cm.exitCallback("createServerDigester", (Object)digester2);
        }
        return digester2;
    }

    protected void updateServerInfos() {
        String infos;
        StringTokenizer st;
        if (this._MupdateServerInfos) {
            this._cm.entryCallback("updateServerInfos");
        }
        if ((st = new StringTokenizer(infos = ServerInfo.getServerInfo(), "/")).countTokens() != 2) {
            this.setServerName(infos);
            this.setServerVersion("");
        } else {
            this.setServerName(st.nextToken());
            this.setServerVersion(st.nextToken());
        }
        Object var3_3 = null;
        if (this._MupdateServerInfos) {
            this._cm.exitCallback("updateServerInfos", var3_3);
        }
    }

    public String getDefaultHost() throws JWebContainerServiceException {
        if (this._MgetDefaultHost) {
            this._cm.entryCallback("getDefaultHost");
        }
        Engine engine = (Engine)this.getFirstService().getContainer();
        String string = engine.getDefaultHost();
        if (this._MgetDefaultHost) {
            this._cm.exitCallback("getDefaultHost", (Object)string);
        }
        return string;
    }

    public String getDefaultHttpPort() throws JWebContainerServiceException {
        if (this._MgetDefaultHttpPort) {
            this._cm.entryCallback("getDefaultHttpPort");
        }
        String string = String.valueOf(this.getFirstConnectorFromScheme("http").getPort());
        if (this._MgetDefaultHttpPort) {
            this._cm.exitCallback("getDefaultHttpPort", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private Connector getFirstConnectorFromScheme(String string) {
        void scheme;
        if (this._MgetFirstConnectorFromSchemejava_lang_String) {
            this._cm.entryCallback("getFirstConnectorFromSchemejava_lang_String");
        }
        Service svc = this.getFirstService();
        Connector[] conn = svc.findConnectors();
        ArrayList<Connector> httpConn = new ArrayList<Connector>();
        for (int i = 0; i < conn.length; ++i) {
            if (!conn[i].getScheme().equalsIgnoreCase((String)scheme)) continue;
            httpConn.add(conn[i]);
        }
        if (httpConn.isEmpty()) {
            JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException("No Connectors found for scheme '" + (String)scheme + "' in " + CONFIG_FILE);
            if (this._MgetFirstConnectorFromSchemejava_lang_String) {
                this._cm.exitCallback("getFirstConnectorFromSchemejava_lang_String", (Object)jWebContainerServiceException);
            }
            throw jWebContainerServiceException;
        }
        Connector c = (Connector)httpConn.get(0);
        if (httpConn.size() > 1 && Tomcat6Service.getLogger().isLoggable(BasicLevel.WARN)) {
            Tomcat6Service.getLogger().log(BasicLevel.WARN, (Object)("Found multiple Connectors for scheme '" + (String)scheme + "' in " + CONFIG_FILE + ", using first by default! (port:" + c.getPort() + ")"));
        }
        Connector connector = c;
        if (this._MgetFirstConnectorFromSchemejava_lang_String) {
            this._cm.exitCallback("getFirstConnectorFromSchemejava_lang_String", (Object)connector);
        }
        return connector;
    }

    private Service getFirstService() {
        Service[] svc;
        if (this._MgetFirstService) {
            this._cm.entryCallback("getFirstService");
        }
        if ((svc = this._getserver().findServices()) == null || svc.length == 0) {
            JWebContainerServiceException jWebContainerServiceException = new JWebContainerServiceException("No Services found in " + CONFIG_FILE);
            if (this._MgetFirstService) {
                this._cm.exitCallback("getFirstService", (Object)jWebContainerServiceException);
            }
            throw jWebContainerServiceException;
        }
        if (svc.length > 1 && Tomcat6Service.getLogger().isLoggable(BasicLevel.WARN)) {
            Tomcat6Service.getLogger().log(BasicLevel.WARN, (Object)("Found multiple Services in " + CONFIG_FILE + ", using first by default!"));
        }
        Service service = svc[0];
        if (this._MgetFirstService) {
            this._cm.exitCallback("getFirstService", (Object)service);
        }
        return service;
    }

    public String getDefaultHttpsPort() throws JWebContainerServiceException {
        if (this._MgetDefaultHttpsPort) {
            this._cm.entryCallback("getDefaultHttpsPort");
        }
        String string = String.valueOf(this.getFirstConnectorFromScheme("https").getPort());
        if (this._MgetDefaultHttpsPort) {
            this._cm.exitCallback("getDefaultHttpsPort", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public void registerWar(String string) throws RemoteException, JWebContainerServiceException {
        if (this._MregisterWarjava_lang_String) {
            this._cm.entryCallback("registerWarjava_lang_String");
        }
        ClassLoader old = null;
        try {
            void fileName;
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this._getcatalinaLoader());
            super.registerWar((String)fileName);
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        catch (Exception e) {
            try {
                ServiceException serviceException = new ServiceException("Exception during registering war", (Throwable)e);
                if (this._MregisterWarjava_lang_String) {
                    this._cm.exitCallback("registerWarjava_lang_String", (Object)serviceException);
                }
                throw serviceException;
            }
            catch (Throwable throwable) {
                if (old != null) {
                    Thread.currentThread().setContextClassLoader(old);
                }
                Throwable throwable2 = throwable;
                if (this._MregisterWarjava_lang_String) {
                    this._cm.exitCallback("registerWarjava_lang_String", (Object)throwable2);
                }
                throw throwable2;
            }
        }
        Object var7_7 = null;
        if (this._MregisterWarjava_lang_String) {
            this._cm.exitCallback("registerWarjava_lang_String", var7_7);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void unRegisterWar(String string) throws RemoteException, JWebContainerServiceException {
        if (this._MunRegisterWarjava_lang_String) {
            this._cm.entryCallback("unRegisterWarjava_lang_String");
        }
        ClassLoader old = null;
        try {
            void fileName;
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this._getcatalinaLoader());
            super.unRegisterWar((String)fileName);
            if (old != null) {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        catch (Exception e) {
            try {
                ServiceException serviceException = new ServiceException("Exception during unregistering war", (Throwable)e);
                if (this._MunRegisterWarjava_lang_String) {
                    this._cm.exitCallback("unRegisterWarjava_lang_String", (Object)serviceException);
                }
                throw serviceException;
            }
            catch (Throwable throwable) {
                if (old != null) {
                    Thread.currentThread().setContextClassLoader(old);
                }
                Throwable throwable2 = throwable;
                if (this._MunRegisterWarjava_lang_String) {
                    this._cm.exitCallback("unRegisterWarjava_lang_String", (Object)throwable2);
                }
                throw throwable2;
            }
        }
        Object var7_7 = null;
        if (this._MunRegisterWarjava_lang_String) {
            this._cm.exitCallback("unRegisterWarjava_lang_String", var7_7);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSecurityService(SecurityService securityService) {
        void securityService2;
        if (this._MsetSecurityServiceorg_ow2_jonas_security_SecurityService) {
            this._cm.entryCallback("setSecurityServiceorg_ow2_jonas_security_SecurityService");
        }
        this._setsecurityService((SecurityService)securityService2);
        Object var2_2 = null;
        if (this._MsetSecurityServiceorg_ow2_jonas_security_SecurityService) {
            this._cm.exitCallback("setSecurityServiceorg_ow2_jonas_security_SecurityService", var2_2);
        }
    }

    private void _setComponentManager(InstanceManager instanceManager) {
        this._cm = instanceManager;
        Set set = this._cm.getRegistredFields();
        if (set != null) {
            if (set.contains("parentClassLoader")) {
                this._FparentClassLoader = true;
            }
            if (set.contains("CONFIG_FILE")) {
                this._FCONFIG_FILE = true;
            }
            if (set.contains("catalinaLoader")) {
                this._FcatalinaLoader = true;
            }
            if (set.contains("logger")) {
                this._Flogger = true;
            }
            if (set.contains("tomcatStarted")) {
                this._FtomcatStarted = true;
            }
            if (set.contains("server")) {
                this._Fserver = true;
            }
            if (set.contains("securityService")) {
                this._FsecurityService = true;
            }
        }
        if ((set = this._cm.getRegistredMethods()) != null) {
            if (set.contains("$initorg_apache_felix_ipojo_InstanceManager")) {
                this._M$initorg_apache_felix_ipojo_InstanceManager = true;
            }
            if (set.contains("initCatalinaEnvironment")) {
                this._MinitCatalinaEnvironment = true;
            }
            if (set.contains("doStart")) {
                this._MdoStart = true;
            }
            if (set.contains("doStop")) {
                this._MdoStop = true;
            }
            if (set.contains("doRegisterWarjavax_naming_Context")) {
                this._MdoRegisterWarjavax_naming_Context = true;
            }
            if (set.contains("getConfiguredMatchingJonasContextsjava_lang_Stringjava_io_Filejava_lang_String")) {
                this._MgetConfiguredMatchingJonasContextsjava_lang_Stringjava_io_Filejava_lang_String = true;
            }
            if (set.contains("checkStartedContextorg_apache_catalina_Contextorg_ow2_jonas_web_base_lib_PermissionManager")) {
                this._McheckStartedContextorg_apache_catalina_Contextorg_ow2_jonas_web_base_lib_PermissionManager = true;
            }
            if (set.contains("getEngines")) {
                this._MgetEngines = true;
            }
            if (set.contains("getContexts")) {
                this._MgetContexts = true;
            }
            if (set.contains("doUnRegisterWarjavax_naming_Context")) {
                this._MdoUnRegisterWarjavax_naming_Context = true;
            }
            if (set.contains("removeContextorg_apache_catalina_Context")) {
                this._MremoveContextorg_apache_catalina_Context = true;
            }
            if (set.contains("isTomcatStarted")) {
                this._MisTomcatStarted = true;
            }
            if (set.contains("setServerorg_apache_catalina_Server")) {
                this._MsetServerorg_apache_catalina_Server = true;
            }
            if (set.contains("getConfigFile")) {
                this._MgetConfigFile = true;
            }
            if (set.contains("findHostjava_lang_String")) {
                this._MfindHostjava_lang_String = true;
            }
            if (set.contains("createServerDigester")) {
                this._McreateServerDigester = true;
            }
            if (set.contains("updateServerInfos")) {
                this._MupdateServerInfos = true;
            }
            if (set.contains("getDefaultHost")) {
                this._MgetDefaultHost = true;
            }
            if (set.contains("getDefaultHttpPort")) {
                this._MgetDefaultHttpPort = true;
            }
            if (set.contains("getFirstConnectorFromSchemejava_lang_String")) {
                this._MgetFirstConnectorFromSchemejava_lang_String = true;
            }
            if (set.contains("getFirstService")) {
                this._MgetFirstService = true;
            }
            if (set.contains("getDefaultHttpsPort")) {
                this._MgetDefaultHttpsPort = true;
            }
            if (set.contains("registerWarjava_lang_String")) {
                this._MregisterWarjava_lang_String = true;
            }
            if (set.contains("unRegisterWarjava_lang_String")) {
                this._MunRegisterWarjava_lang_String = true;
            }
            if (set.contains("setSecurityServiceorg_ow2_jonas_security_SecurityService")) {
                this._MsetSecurityServiceorg_ow2_jonas_security_SecurityService = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this._cm;
    }
}

