/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.internal;

import java.util.Enumeration;
import java.util.Hashtable;
import org.ow2.jonas.security.SecurityService;
import org.ow2.jonas.security.internal.realm.factory.JResourceDS;
import org.ow2.jonas.security.internal.realm.factory.JResourceLDAP;
import org.ow2.jonas.security.internal.realm.factory.JResourceMemory;
import org.ow2.jonas.security.realm.factory.JResource;

public class JResources {
    private Hashtable jResources = new Hashtable();
    private SecurityService service = null;
    public static final String HEADER_XML = "<?xml version='1.0' encoding='utf-8'?>\n<!DOCTYPE jonas-realm PUBLIC\n          \"-//ObjectWeb//DTD JOnAS realm 1.0//EN\"\n          \"http://www.objectweb.org/jonas/dtds/jonas-realm_1_0.dtd\">\n";

    public JResources(SecurityService s) {
        this.service = s;
    }

    public void addJResource(JResource jResource) throws Exception {
        if (this.jResources.get(jResource.getName()) != null) {
            throw new Exception("The resource name " + jResource.getName() + " already exists !");
        }
        this.jResources.put(jResource.getName(), jResource);
        this.service.bindResource(jResource.getName(), jResource);
    }

    public JResource remove(String resourceName) throws Exception {
        JResource jResource = (JResource)this.jResources.get(resourceName);
        if (jResource == null) {
            throw new Exception("The resource name " + resourceName + " doesn't exist !");
        }
        this.jResources.remove(resourceName);
        return jResource;
    }

    public JResource getJResource(String name) {
        return (JResource)this.jResources.get(name);
    }

    public Enumeration getResources() {
        return this.jResources.elements();
    }

    public String toXML() {
        Object o;
        StringBuffer xml = new StringBuffer(HEADER_XML);
        xml.append("<!--\n");
        xml.append(" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n");
        xml.append(" - Define a jonas-realm.xml file for JOnAS realms\n");
        xml.append(" - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n");
        xml.append(" -->\n");
        xml.append("<jonas-realm>\n");
        xml.append("  <!--\n");
        xml.append("       -=  MEMORY REALM =-\n");
        xml.append("       Define the users, groups and roles\n");
        xml.append("  -->\n");
        xml.append("  <jonas-memoryrealm>\n");
        Enumeration e = this.jResources.elements();
        while (e.hasMoreElements()) {
            o = e.nextElement();
            if (!(o instanceof JResourceMemory)) continue;
            xml.append(o.toString());
            xml.append("\n");
        }
        xml.append("  </jonas-memoryrealm>\n");
        xml.append("  <!--\n");
        xml.append("       -=  DATASOURCE REALM =-\n");
        xml.append("       Define the configuration to use datas from a datasource\n");
        xml.append("  -->\n");
        xml.append("  <jonas-dsrealm>\n");
        e = this.jResources.elements();
        while (e.hasMoreElements()) {
            o = e.nextElement();
            if (!(o instanceof JResourceDS)) continue;
            xml.append(o.toString());
            xml.append("\n");
        }
        xml.append("  </jonas-dsrealm>\n");
        xml.append("  <!--\n");
        xml.append("       -=  LDAP REALM =-\n");
        xml.append("       Define the configuration to use datas from an ldap server\n");
        xml.append("  -->\n");
        xml.append("  <jonas-ldaprealm>\n");
        e = this.jResources.elements();
        while (e.hasMoreElements()) {
            o = e.nextElement();
            if (!(o instanceof JResourceLDAP)) continue;
            xml.append(o.toString());
            xml.append("\n");
        }
        xml.append("  </jonas-ldaprealm>\n");
        xml.append("</jonas-realm>\n");
        return xml.toString();
    }
}

