/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jmx.internal;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.jmx.internal.BaseJMXService;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.service.JonasAlreadyStartedException;
import org.ow2.jonas.service.ServiceException;

public class JOnASJMXService
extends BaseJMXService
implements Pojo {
    private InstanceManager _cm;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.jmx");
    private static final String MX4J_COMMONS_LOGGER_CLASSNAME = "mx4j.log.CommonsLogger";
    private static final String MX4J_LOG_CLASSNAME = "mx4j.log.Log";
    private static final String MX4J_LOGGER_CLASS = "mx4j.log.Logger";
    private boolean _FconnectorServers;
    private JMXConnectorServer[] connectorServers;
    private boolean _FconnectorServerURLs;
    private JMXServiceURL[] connectorServerURLs;
    private boolean _FregistryService;
    private RegistryService registryService;
    private boolean _FconnectorObjectNames;
    private List connectorObjectNames;
    private boolean _M$initorg_apache_felix_ipojo_InstanceManager;
    private boolean _MinitializeMX4JLoggingSystem;
    private boolean _MdoStart;
    private boolean _McheckRequirements;
    private boolean _MdoStop;
    private boolean _MgetConnectorServerURLs;
    private boolean _MsetRegistryServiceorg_ow2_jonas_registry_RegistryService;

    private JMXConnectorServer[] _getconnectorServers() {
        if (!this._FconnectorServers) {
            return this.connectorServers;
        }
        return (JMXConnectorServer[])this._cm.getterCallback("connectorServers");
    }

    private void _setconnectorServers(JMXConnectorServer[] jMXConnectorServerArray) {
        if (!this._FconnectorServers) {
            this.connectorServers = jMXConnectorServerArray;
            return;
        }
        this._cm.setterCallback("connectorServers", (Object)jMXConnectorServerArray);
    }

    private JMXServiceURL[] _getconnectorServerURLs() {
        if (!this._FconnectorServerURLs) {
            return this.connectorServerURLs;
        }
        return (JMXServiceURL[])this._cm.getterCallback("connectorServerURLs");
    }

    private void _setconnectorServerURLs(JMXServiceURL[] jMXServiceURLArray) {
        if (!this._FconnectorServerURLs) {
            this.connectorServerURLs = jMXServiceURLArray;
            return;
        }
        this._cm.setterCallback("connectorServerURLs", (Object)jMXServiceURLArray);
    }

    private RegistryService _getregistryService() {
        if (!this._FregistryService) {
            return this.registryService;
        }
        return (RegistryService)this._cm.getterCallback("registryService");
    }

    private void _setregistryService(RegistryService registryService) {
        if (!this._FregistryService) {
            this.registryService = registryService;
            return;
        }
        this._cm.setterCallback("registryService", (Object)registryService);
    }

    private List _getconnectorObjectNames() {
        if (!this._FconnectorObjectNames) {
            return this.connectorObjectNames;
        }
        return (List)this._cm.getterCallback("connectorObjectNames");
    }

    private void _setconnectorObjectNames(List list) {
        if (!this._FconnectorObjectNames) {
            this.connectorObjectNames = list;
            return;
        }
        this._cm.setterCallback("connectorObjectNames", (Object)list);
    }

    public JOnASJMXService(InstanceManager _manager) {
        this._setComponentManager(_manager);
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.entryCallback("$initorg_apache_felix_ipojo_InstanceManager");
        }
        this._setconnectorServers(null);
        this._setconnectorServerURLs(null);
        this._setregistryService(null);
        this._setconnectorObjectNames(null);
        Object var3_2 = null;
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.exitCallback("$initorg_apache_felix_ipojo_InstanceManager", var3_2);
        }
    }

    private void initializeMX4JLoggingSystem() {
        block8: {
            if (this._MinitializeMX4JLoggingSystem) {
                this._cm.entryCallback("initializeMX4JLoggingSystem");
            }
            Class<?> mx4jCommonsLoggerClass = null;
            try {
                mx4jCommonsLoggerClass = Thread.currentThread().getContextClassLoader().loadClass(MX4J_COMMONS_LOGGER_CLASSNAME);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"Class mx4j.log.CommonsLogger founded");
                }
                Object o = mx4jCommonsLoggerClass.newInstance();
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(MX4J_LOG_CLASSNAME);
                Class<?> mx4jLoggerClass = Thread.currentThread().getContextClassLoader().loadClass(MX4J_LOGGER_CLASS);
                Method m = clazz.getMethod("redirectTo", mx4jLoggerClass);
                m.invoke(clazz, o);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"MX4J logging redirected to the Jakarta commons logger");
                }
            }
            catch (ClassNotFoundException cnfe) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Class mx4j.log.CommonsLogger not found: " + cnfe));
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.WARN)) break block8;
                logger.log(BasicLevel.WARN, (Object)("Problem with mx4j.log.CommonsLogger instance creation " + e));
            }
        }
        Object var6_8 = null;
        if (this._MinitializeMX4JLoggingSystem) {
            this._cm.exitCallback("initializeMX4JLoggingSystem", var6_8);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doStart() throws ServiceException {
        if (this._MdoStart) {
            this._cm.entryCallback("doStart");
        }
        logger.log(BasicLevel.DEBUG, (Object)"Starting JMX Service");
        this.initializeMX4JLoggingSystem();
        super.doStart();
        String serverName = this.getJonasServerName();
        if (serverName == null) {
            ServiceException serviceException = new ServiceException("Cannot start JMX service. No serverName.");
            if (this._MdoStart) {
                this._cm.exitCallback("doStart", (Object)serviceException);
            }
            throw serviceException;
        }
        String defaultProtocolName = this._getregistryService().getDefaultProtocolName();
        try {
            List protocols = this._getregistryService().getActiveProtocolNames();
            int nbProtocols = protocols.size();
            this._setconnectorServerURLs(new JMXServiceURL[nbProtocols]);
            this._setconnectorServers(new JMXConnectorServer[nbProtocols]);
            this._setconnectorObjectNames(new ArrayList());
            int index = 0;
            for (String name : protocols) {
                JMXConnectorServer connectorServer;
                String connectorName = null;
                this._getregistryService().setDefaultProtocol(name);
                String protocol = "rmi";
                URI carolURL = this._getregistryService().getProviderURL(name);
                String scheme = carolURL.getScheme();
                String host = carolURL.getHost();
                int port = this._getregistryService().getExportedObjectPort(name);
                String ictxFactory = this._getregistryService().getInitialContextFactoryName(name);
                Properties props = new Properties();
                props.put("jmx.remote.jndi.rebind", "true");
                props.put("java.naming.factory.initial", ictxFactory);
                props.put("java.naming.provider.url", carolURL.toString());
                JMXServiceURL serviceURL = null;
                if (name.equals("jrmp")) {
                    connectorName = "jrmpconnector_" + serverName;
                } else if (name.equals("irmi")) {
                    connectorName = "irmiconnector_" + serverName;
                    if (port != 0) {
                        ++port;
                    }
                } else {
                    if (!name.equals("iiop")) continue;
                    connectorName = "iiopconnector_" + serverName;
                    protocol = "iiop";
                    props.put("java.naming.corba.orb", new InitialContext().lookup("java:comp/ORB"));
                }
                serviceURL = new JMXServiceURL(protocol, host, port, "/jndi/" + carolURL.toString() + "/" + connectorName);
                this._getconnectorServers()[index] = connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(serviceURL, props, null);
                String connectorObjectName = "connector_" + name;
                ObjectName connectorServerName = JonasObjectName.jmxConnectorServer((String)scheme, (String)connectorObjectName);
                this._getconnectorObjectNames().add(connectorServerName);
                if (this.getJmxServer().isRegistered(connectorServerName)) {
                    this.getJmxServer().unregisterMBean(connectorServerName);
                }
                this.getJmxServer().registerMBean(connectorServer, connectorServerName);
                final int idx = index++;
                final JMXConnectorServer server = connectorServer;
                IExecution<Void> exec = new IExecution<Void>(){

                    public Void execute() throws Exception {
                        server.start();
                        ((JOnASJMXService)JOnASJMXService.this).connectorServerURLs[idx] = server.getAddress();
                        return null;
                    }
                };
                System.setProperty("carol.multipro.protocol", name);
                ExecutionResult res = RunnableHelper.execute((ClassLoader)JOnASJMXService.class.getClassLoader(), (IExecution)exec);
                System.setProperty("carol.multipro.protocol", "any");
                if (!res.hasException()) continue;
                Exception exception = res.getException();
                if (this._MdoStart) {
                    this._cm.exitCallback("doStart", (Object)exception);
                }
                throw exception;
            }
        }
        catch (NameAlreadyBoundException ne) {
            try {
                logger.log(BasicLevel.DEBUG, (Object)("Cannot start JMX service " + ne));
                JonasAlreadyStartedException jonasAlreadyStartedException = new JonasAlreadyStartedException();
                if (this._MdoStart) {
                    this._cm.exitCallback("doStart", (Object)jonasAlreadyStartedException);
                }
                throw jonasAlreadyStartedException;
                catch (Exception e) {
                    ServiceException serviceException = new ServiceException("Cannot start JMX service", (Throwable)e);
                    if (this._MdoStart) {
                        this._cm.exitCallback("doStart", (Object)serviceException);
                    }
                    throw serviceException;
                }
            }
            catch (Throwable throwable) {
                this._getregistryService().setDefaultProtocol(defaultProtocolName);
                Throwable throwable2 = throwable;
                if (this._MdoStart) {
                    this._cm.exitCallback("doStart", (Object)throwable2);
                }
                throw throwable2;
            }
        }
        this._getregistryService().setDefaultProtocol(defaultProtocolName);
        logger.log(BasicLevel.INFO, (Object)("JMX Service started, using connector(s) " + Arrays.asList(this._getconnectorServerURLs())));
        Object var30_32 = null;
        if (!this._MdoStart) return;
        this._cm.exitCallback("doStart", var30_32);
    }

    public void checkRequirements() throws ServiceException {
        if (this._McheckRequirements) {
            this._cm.entryCallback("checkRequirements");
        }
        super.checkRequirements();
        if (this._getregistryService() == null) {
            this.throwRequirementException("Missing reference to " + RegistryService.class);
        }
        Object var1_1 = null;
        if (this._McheckRequirements) {
            this._cm.exitCallback("checkRequirements", var1_1);
        }
    }

    public void doStop() {
        if (this._MdoStop) {
            this._cm.entryCallback("doStop");
        }
        super.doStop();
        logger.log(BasicLevel.DEBUG, (Object)"Stopping JMX Service");
        if (this._getconnectorObjectNames() != null) {
            for (final ObjectName name : this._getconnectorObjectNames()) {
                try {
                    IExecution<Void> exec = new IExecution<Void>(){

                        public Void execute() throws Exception {
                            JOnASJMXService.this.getJmxServer().unregisterMBean(name);
                            return null;
                        }
                    };
                    String protocol = name.getKeyProperty("protocol");
                    System.setProperty("carol.multipro.protocol", protocol);
                    ExecutionResult result = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)exec);
                    System.setProperty("carol.multipro.protocol", "any");
                    if (!result.hasException()) continue;
                    Exception exception = result.getException();
                    if (this._MdoStop) {
                        this._cm.exitCallback("doStop", (Object)exception);
                    }
                    throw exception;
                }
                catch (Exception e) {
                    logger.log(BasicLevel.ERROR, (Object)("Cannot unregister Connector MBean for '" + name + "'"), (Throwable)e);
                }
            }
        }
        if (this._getconnectorServers() != null) {
            for (int i = 0; i < this._getconnectorServers().length; ++i) {
                try {
                    this._getconnectorServers()[i].stop();
                    continue;
                }
                catch (Exception e) {
                    logger.log(BasicLevel.INFO, (Object)"Cannot Stop JMX Connector", (Throwable)e);
                }
            }
        }
        logger.log(BasicLevel.INFO, (Object)"JMX Service stopped");
        Object var7_10 = null;
        if (this._MdoStop) {
            this._cm.exitCallback("doStop", var7_10);
        }
    }

    public JMXServiceURL[] getConnectorServerURLs() {
        if (this._MgetConnectorServerURLs) {
            this._cm.entryCallback("getConnectorServerURLs");
        }
        JMXServiceURL[] jMXServiceURLArray = this._getconnectorServerURLs();
        if (this._MgetConnectorServerURLs) {
            this._cm.exitCallback("getConnectorServerURLs", (Object)jMXServiceURLArray);
        }
        return jMXServiceURLArray;
    }

    /*
     * WARNING - void declaration
     */
    public void setRegistryService(RegistryService registryService) {
        void registryService2;
        if (this._MsetRegistryServiceorg_ow2_jonas_registry_RegistryService) {
            this._cm.entryCallback("setRegistryServiceorg_ow2_jonas_registry_RegistryService");
        }
        this._setregistryService((RegistryService)registryService2);
        Object var2_2 = null;
        if (this._MsetRegistryServiceorg_ow2_jonas_registry_RegistryService) {
            this._cm.exitCallback("setRegistryServiceorg_ow2_jonas_registry_RegistryService", var2_2);
        }
    }

    private void _setComponentManager(InstanceManager instanceManager) {
        this._cm = instanceManager;
        Set set = this._cm.getRegistredFields();
        if (set != null) {
            if (set.contains("connectorServers")) {
                this._FconnectorServers = true;
            }
            if (set.contains("MX4J_LOGGER_CLASS")) {
                this._FMX4J_LOGGER_CLASS = true;
            }
            if (set.contains("MX4J_LOG_CLASSNAME")) {
                this._FMX4J_LOG_CLASSNAME = true;
            }
            if (set.contains("MX4J_COMMONS_LOGGER_CLASSNAME")) {
                this._FMX4J_COMMONS_LOGGER_CLASSNAME = true;
            }
            if (set.contains("logger")) {
                this._Flogger = true;
            }
            if (set.contains("registryService")) {
                this._FregistryService = true;
            }
            if (set.contains("connectorObjectNames")) {
                this._FconnectorObjectNames = true;
            }
            if (set.contains("connectorServerURLs")) {
                this._FconnectorServerURLs = true;
            }
        }
        if ((set = this._cm.getRegistredMethods()) != null) {
            if (set.contains("$initorg_apache_felix_ipojo_InstanceManager")) {
                this._M$initorg_apache_felix_ipojo_InstanceManager = true;
            }
            if (set.contains("initializeMX4JLoggingSystem")) {
                this._MinitializeMX4JLoggingSystem = true;
            }
            if (set.contains("doStart")) {
                this._MdoStart = true;
            }
            if (set.contains("checkRequirements")) {
                this._McheckRequirements = true;
            }
            if (set.contains("doStop")) {
                this._MdoStop = true;
            }
            if (set.contains("getConnectorServerURLs")) {
                this._MgetConnectorServerURLs = true;
            }
            if (set.contains("setRegistryServiceorg_ow2_jonas_registry_RegistryService")) {
                this._MsetRegistryServiceorg_ow2_jonas_registry_RegistryService = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this._cm;
    }
}

