/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.registry.carol;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.carol.jndi.ns.NameServiceManager;
import org.ow2.carol.rmi.jrmp.interceptor.spi.JInitializer;
import org.ow2.carol.util.configuration.ConfigurationException;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.carol.util.configuration.ProtocolConfiguration;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.naming.JComponentContextFactory;
import org.ow2.jonas.naming.JComponentContextFactoryDelegate;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.registry.carol.delegate.ORBCCFDelegate;
import org.ow2.jonas.security.interceptors.jrmp.SecurityInitializer;
import org.ow2.jonas.security.interceptors.jrmp.ctxcheck.Initializer;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jotm.jta.rmi.JTAInterceptorInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CarolRegistryService
extends AbsServiceImpl
implements RegistryService,
Pojo {
    private InstanceManager _cm;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.registry");
    public static final String DEFAULT_MODE = "automatic";
    public static final String COLLOCATED = "collocated";
    public static final String REMOTE = "remote";
    private boolean _FbStartRegistry;
    private boolean bStartRegistry;
    private boolean _FbIgnoreError;
    private boolean bIgnoreError;
    private boolean _Fdelegate;
    private JComponentContextFactoryDelegate delegate;
    private boolean _Ffactory;
    private JComponentContextFactory factory;
    private boolean _FconfigurationURL;
    private URL configurationURL;
    private boolean _FmbeanServer;
    private MBeanServer mbeanServer;
    private boolean _Fictx;
    private InitialContext ictx;
    private static final String SECURITY_PROPAGATION = "jonas.security.propagation";
    private static final String CSIV2_PROPAGATION = "jonas.csiv2.propagation";
    private static final String SEC_CHECK = "jonas.security.context.check";
    private static final String TRANSACTION_PROPAGATION = "jonas.transaction.propagation";
    private boolean _FjrmpInterceptors;
    private List<Class<? extends JInitializer>> jrmpInterceptors;
    private boolean _M$initorg_apache_felix_ipojo_InstanceManager;
    private boolean _MsetModejava_lang_String;
    private boolean _MdoStart;
    private boolean _MinitInterceptors;
    private boolean _MremoveInterceptors;
    private boolean _MdoStop;
    private boolean _McheckRequirements;
    private boolean _MgetActiveProtocolNames;
    private boolean _MgetDefaultProtocolName;
    private boolean _MgetExportedObjectPortjava_lang_String;
    private boolean _MgetInitialContextFactoryNamejava_lang_String;
    private boolean _MgetProviderURLjava_lang_String;
    private boolean _MsetDefaultProtocoljava_lang_String;
    private boolean _MgetProtocolConfigurationjava_lang_String;
    private boolean _MsetComponentContextFactoryorg_ow2_jonas_naming_JComponentContextFactory;
    private boolean _MsetDelegateorg_ow2_jonas_naming_JComponentContextFactoryDelegate;
    private boolean _MsetStartRegistryboolean;
    private boolean _MsetIgnoreErrorboolean;
    private boolean _MsetConfigurationURLjava_net_URL;
    private boolean _MsetConfigurationjava_lang_String;
    private boolean _MgetRegistryContext;
    private boolean _MgetMBeanServerId;

    private boolean _getbStartRegistry() {
        if (!this._FbStartRegistry) {
            return this.bStartRegistry;
        }
        Object object = this._cm.getterCallback("bStartRegistry");
        Boolean bl = (Boolean)object;
        return bl;
    }

    private void _setbStartRegistry(boolean bl) {
        if (!this._FbStartRegistry) {
            this.bStartRegistry = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this._cm.setterCallback("bStartRegistry", (Object)bl2);
    }

    private boolean _getbIgnoreError() {
        if (!this._FbIgnoreError) {
            return this.bIgnoreError;
        }
        Object object = this._cm.getterCallback("bIgnoreError");
        Boolean bl = (Boolean)object;
        return bl;
    }

    private void _setbIgnoreError(boolean bl) {
        if (!this._FbIgnoreError) {
            this.bIgnoreError = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this._cm.setterCallback("bIgnoreError", (Object)bl2);
    }

    private JComponentContextFactoryDelegate _getdelegate() {
        if (!this._Fdelegate) {
            return this.delegate;
        }
        return (JComponentContextFactoryDelegate)this._cm.getterCallback("delegate");
    }

    private void _setdelegate(JComponentContextFactoryDelegate jComponentContextFactoryDelegate) {
        if (!this._Fdelegate) {
            this.delegate = jComponentContextFactoryDelegate;
            return;
        }
        this._cm.setterCallback("delegate", (Object)jComponentContextFactoryDelegate);
    }

    private JComponentContextFactory _getfactory() {
        if (!this._Ffactory) {
            return this.factory;
        }
        return (JComponentContextFactory)this._cm.getterCallback("factory");
    }

    private void _setfactory(JComponentContextFactory jComponentContextFactory) {
        if (!this._Ffactory) {
            this.factory = jComponentContextFactory;
            return;
        }
        this._cm.setterCallback("factory", (Object)jComponentContextFactory);
    }

    private URL _getconfigurationURL() {
        if (!this._FconfigurationURL) {
            return this.configurationURL;
        }
        return (URL)this._cm.getterCallback("configurationURL");
    }

    private void _setconfigurationURL(URL uRL) {
        if (!this._FconfigurationURL) {
            this.configurationURL = uRL;
            return;
        }
        this._cm.setterCallback("configurationURL", (Object)uRL);
    }

    private MBeanServer _getmbeanServer() {
        if (!this._FmbeanServer) {
            return this.mbeanServer;
        }
        return (MBeanServer)this._cm.getterCallback("mbeanServer");
    }

    private void _setmbeanServer(MBeanServer mBeanServer) {
        if (!this._FmbeanServer) {
            this.mbeanServer = mBeanServer;
            return;
        }
        this._cm.setterCallback("mbeanServer", (Object)mBeanServer);
    }

    private InitialContext _getictx() {
        if (!this._Fictx) {
            return this.ictx;
        }
        return (InitialContext)this._cm.getterCallback("ictx");
    }

    private void _setictx(InitialContext initialContext) {
        if (!this._Fictx) {
            this.ictx = initialContext;
            return;
        }
        this._cm.setterCallback("ictx", (Object)initialContext);
    }

    private List _getjrmpInterceptors() {
        if (!this._FjrmpInterceptors) {
            return this.jrmpInterceptors;
        }
        return (List)this._cm.getterCallback("jrmpInterceptors");
    }

    private void _setjrmpInterceptors(List list) {
        if (!this._FjrmpInterceptors) {
            this.jrmpInterceptors = list;
            return;
        }
        this._cm.setterCallback("jrmpInterceptors", (Object)list);
    }

    public CarolRegistryService(InstanceManager _manager) {
        this._setComponentManager(_manager);
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.entryCallback("$initorg_apache_felix_ipojo_InstanceManager");
        }
        this._setbStartRegistry(true);
        this._setbIgnoreError(true);
        this._setdelegate(null);
        this._setfactory(null);
        this._setmbeanServer(null);
        this._setictx(null);
        this._setjrmpInterceptors(null);
        this._setjrmpInterceptors(new ArrayList());
        Object var3_2 = null;
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.exitCallback("$initorg_apache_felix_ipojo_InstanceManager", var3_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setMode(String string) {
        void mode;
        if (this._MsetModejava_lang_String) {
            this._cm.entryCallback("setModejava_lang_String");
        }
        if (DEFAULT_MODE.equalsIgnoreCase((String)mode)) {
            this.setStartRegistry(true);
            this.setIgnoreError(true);
        } else if (COLLOCATED.equalsIgnoreCase((String)mode)) {
            this.setStartRegistry(true);
            this.setIgnoreError(false);
        } else if (REMOTE.equalsIgnoreCase((String)mode)) {
            this.setStartRegistry(false);
            this.setIgnoreError(false);
        }
        Object var2_2 = null;
        if (this._MsetModejava_lang_String) {
            this._cm.exitCallback("setModejava_lang_String", var2_2);
        }
    }

    public void doStart() throws ServiceException {
        if (this._MdoStart) {
            this._cm.entryCallback("doStart");
        }
        logger.log(BasicLevel.DEBUG, (Object)"Starting Carol Registry Service");
        IExecution<Void> carolStarter = new IExecution<Void>(){

            public Void execute() throws Exception {
                System.setProperty("carol.server.mode", "true");
                if (CarolRegistryService.this.configurationURL != null) {
                    try {
                        ConfigurationRepository.init((URL)CarolRegistryService.this.configurationURL, (String)CarolRegistryService.this.getDomainName(), (String)CarolRegistryService.this.getJonasServerName(), (String)CarolRegistryService.this.getMBeanServerId());
                    }
                    catch (ConfigurationException e) {
                        throw new ServiceException("Cannot init Carol", (Throwable)e);
                    }
                } else {
                    ConfigurationRepository.init((String)CarolRegistryService.this.getDomainName(), (String)CarolRegistryService.this.getJonasServerName(), (String)CarolRegistryService.this.getMBeanServerId());
                }
                return null;
            }
        };
        ExecutionResult result = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)carolStarter);
        if (result.hasException()) {
            ServiceException serviceException = new ServiceException(result.getException().getMessage(), (Throwable)result.getException());
            if (this._MdoStart) {
                this._cm.exitCallback("doStart", (Object)serviceException);
            }
            throw serviceException;
        }
        try {
            this.initInterceptors();
        }
        catch (ConfigurationException e1) {
            ServiceException serviceException = new ServiceException("Cannot init Carol interceptors", (Throwable)e1);
            if (this._MdoStart) {
                this._cm.exitCallback("doStart", (Object)serviceException);
            }
            throw serviceException;
        }
        if (this._getbStartRegistry()) {
            NameServiceManager nameServiceManager = NameServiceManager.getNameServiceManager();
            try {
                if (this._getbIgnoreError()) {
                    nameServiceManager.startNonStartedNS();
                } else {
                    nameServiceManager.startNS();
                }
            }
            catch (Exception e) {
                ServiceException serviceException = new ServiceException("Cannot start the registry", (Throwable)e);
                if (this._MdoStart) {
                    this._cm.exitCallback("doStart", (Object)serviceException);
                }
                throw serviceException;
            }
        }
        if (!this.isOSGi()) {
            try {
                this.setDelegate(new ORBCCFDelegate());
                this._getfactory().addDelegate(this._getdelegate());
            }
            catch (NamingException e) {
                ServiceException serviceException = new ServiceException("Cannot add the delegate", (Throwable)e);
                if (this._MdoStart) {
                    this._cm.exitCallback("doStart", (Object)serviceException);
                }
                throw serviceException;
            }
        }
        logger.log(BasicLevel.INFO, (Object)"Carol Registry Service Started");
        Object var9_11 = null;
        if (this._MdoStart) {
            this._cm.exitCallback("doStart", var9_11);
        }
    }

    private void initInterceptors() throws ConfigurationException {
        boolean iiopEnabled;
        if (this._MinitInterceptors) {
            this._cm.entryCallback("initInterceptors");
        }
        boolean security = Boolean.parseBoolean(this.getServerProperties().getValue(SECURITY_PROPAGATION));
        boolean transaction = Boolean.parseBoolean(this.getServerProperties().getValue(TRANSACTION_PROPAGATION));
        boolean csiv2 = Boolean.parseBoolean(this.getServerProperties().getValue(CSIV2_PROPAGATION));
        boolean securityCheck = Boolean.parseBoolean(this.getServerProperties().getValue(SEC_CHECK));
        boolean bl = iiopEnabled = ConfigurationRepository.getConfiguration((String)"iiop") != null;
        if (security) {
            this._getjrmpInterceptors().add(SecurityInitializer.class);
            if (iiopEnabled) {
                ConfigurationRepository.addInterceptors((String)"iiop", (String)"org.ow2.jonas.security.interceptors.iiop.SecurityInitializer");
            }
            if (securityCheck) {
                this._getjrmpInterceptors().add(Initializer.class);
            }
        }
        if (iiopEnabled && csiv2) {
            ConfigurationRepository.addInterceptors((String)"iiop", (String)"org.ow2.jonas.security.iiop.Csiv2Initializer");
        }
        if (transaction) {
            this._getjrmpInterceptors().add(JTAInterceptorInitializer.class);
            if (iiopEnabled) {
                ConfigurationRepository.addInterceptors((String)"iiop", (String)"org.ow2.jotm.ots.OTSORBInitializer");
            }
        }
        for (Class interceptor : this._getjrmpInterceptors()) {
            ConfigurationRepository.addInterceptors((String)"jrmp", (Class)interceptor);
        }
        Object var8_8 = null;
        if (this._MinitInterceptors) {
            this._cm.exitCallback("initInterceptors", var8_8);
        }
    }

    private void removeInterceptors() throws ConfigurationException {
        if (this._MremoveInterceptors) {
            this._cm.entryCallback("removeInterceptors");
        }
        for (Class interceptor : this._getjrmpInterceptors()) {
            ConfigurationRepository.removeInterceptors((String)"jrmp", (Class)interceptor);
        }
        this._getjrmpInterceptors().clear();
        Object var3_3 = null;
        if (this._MremoveInterceptors) {
            this._cm.exitCallback("removeInterceptors", var3_3);
        }
    }

    public void doStop() throws ServiceException {
        if (this._MdoStop) {
            this._cm.entryCallback("doStop");
        }
        logger.log(BasicLevel.DEBUG, (Object)"Stopping Carol Registry Service");
        try {
            this.removeInterceptors();
        }
        catch (ConfigurationException e) {
            ServiceException serviceException = new ServiceException("Cannot remove Carol interceptors", (Throwable)e);
            if (this._MdoStop) {
                this._cm.exitCallback("doStop", (Object)serviceException);
            }
            throw serviceException;
        }
        try {
            if (!this.isOSGi()) {
                try {
                    this._getfactory().removeDelegate(this._getdelegate());
                }
                catch (NamingException e) {
                    ServiceException serviceException = new ServiceException("Cannot remove the delegate", (Throwable)e);
                    if (this._MdoStop) {
                        this._cm.exitCallback("doStop", (Object)serviceException);
                    }
                    throw serviceException;
                }
            }
            NameServiceManager.getNameServiceManager().stopNS();
        }
        catch (Exception e) {
            ServiceException serviceException = new ServiceException("Problem when stopping registry service", (Throwable)e);
            if (this._MdoStop) {
                this._cm.exitCallback("doStop", (Object)serviceException);
            }
            throw serviceException;
        }
        logger.log(BasicLevel.INFO, (Object)"Carol Registry Service Stopped");
        Object var5_7 = null;
        if (this._MdoStop) {
            this._cm.exitCallback("doStop", var5_7);
        }
    }

    public void checkRequirements() throws ServiceException {
        if (this._McheckRequirements) {
            this._cm.entryCallback("checkRequirements");
        }
        if (!this.isOSGi() && this._getfactory() == null) {
            this.throwRequirementException("Missing reference on " + JComponentContextFactory.class);
        }
        Object var1_1 = null;
        if (this._McheckRequirements) {
            this._cm.exitCallback("checkRequirements", var1_1);
        }
    }

    public List<String> getActiveProtocolNames() {
        if (this._MgetActiveProtocolNames) {
            this._cm.entryCallback("getActiveProtocolNames");
        }
        ArrayList<String> protocols = new ArrayList<String>();
        ProtocolConfiguration[] configs = ConfigurationRepository.getConfigurations();
        for (int i = 0; i < configs.length; ++i) {
            protocols.add(configs[i].getName());
        }
        ArrayList<String> arrayList = protocols;
        if (this._MgetActiveProtocolNames) {
            this._cm.exitCallback("getActiveProtocolNames", arrayList);
        }
        return arrayList;
    }

    public String getDefaultProtocolName() {
        if (this._MgetDefaultProtocolName) {
            this._cm.entryCallback("getDefaultProtocolName");
        }
        String string = ConfigurationRepository.getDefaultConfiguration().getName();
        if (this._MgetDefaultProtocolName) {
            this._cm.exitCallback("getDefaultProtocolName", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public int getExportedObjectPort(String string) {
        void protocolName;
        if (this._MgetExportedObjectPortjava_lang_String) {
            this._cm.entryCallback("getExportedObjectPortjava_lang_String");
        }
        ProtocolConfiguration config = this.getProtocolConfiguration((String)protocolName);
        String key = "carol." + (String)protocolName + ".server.port";
        String port = config.getProperties().getProperty(key, "0");
        Integer n = new Integer(Integer.valueOf(port));
        if (this._MgetExportedObjectPortjava_lang_String) {
            this._cm.exitCallback("getExportedObjectPortjava_lang_String", (Object)n);
        }
        return ((Number)n).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public String getInitialContextFactoryName(String string) {
        void protocolName;
        if (this._MgetInitialContextFactoryNamejava_lang_String) {
            this._cm.entryCallback("getInitialContextFactoryNamejava_lang_String");
        }
        ProtocolConfiguration config = this.getProtocolConfiguration((String)protocolName);
        String string2 = config.getProtocol().getInitialContextFactoryClassName();
        if (this._MgetInitialContextFactoryNamejava_lang_String) {
            this._cm.exitCallback("getInitialContextFactoryNamejava_lang_String", (Object)string2);
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public URI getProviderURL(String string) {
        void protocolName;
        if (this._MgetProviderURLjava_lang_String) {
            this._cm.entryCallback("getProviderURLjava_lang_String");
        }
        ProtocolConfiguration config = this.getProtocolConfiguration((String)protocolName);
        URI uRI = URI.create(config.getProviderURL());
        if (this._MgetProviderURLjava_lang_String) {
            this._cm.exitCallback("getProviderURLjava_lang_String", (Object)uRI);
        }
        return uRI;
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultProtocol(String string) {
        void protocolName;
        if (this._MsetDefaultProtocoljava_lang_String) {
            this._cm.entryCallback("setDefaultProtocoljava_lang_String");
        }
        ProtocolConfiguration config = this.getProtocolConfiguration((String)protocolName);
        ConfigurationRepository.setCurrentConfiguration((ProtocolConfiguration)config);
        Object var3_3 = null;
        if (this._MsetDefaultProtocoljava_lang_String) {
            this._cm.exitCallback("setDefaultProtocoljava_lang_String", var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ProtocolConfiguration getProtocolConfiguration(String string) {
        void protocolName;
        if (this._MgetProtocolConfigurationjava_lang_String) {
            this._cm.entryCallback("getProtocolConfigurationjava_lang_String");
        }
        ProtocolConfiguration protocolConfiguration = ConfigurationRepository.getConfiguration((String)protocolName);
        if (this._MgetProtocolConfigurationjava_lang_String) {
            this._cm.exitCallback("getProtocolConfigurationjava_lang_String", (Object)protocolConfiguration);
        }
        return protocolConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    public void setComponentContextFactory(JComponentContextFactory jComponentContextFactory) {
        void factory;
        if (this._MsetComponentContextFactoryorg_ow2_jonas_naming_JComponentContextFactory) {
            this._cm.entryCallback("setComponentContextFactoryorg_ow2_jonas_naming_JComponentContextFactory");
        }
        this._setfactory((JComponentContextFactory)factory);
        Object var2_2 = null;
        if (this._MsetComponentContextFactoryorg_ow2_jonas_naming_JComponentContextFactory) {
            this._cm.exitCallback("setComponentContextFactoryorg_ow2_jonas_naming_JComponentContextFactory", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDelegate(JComponentContextFactoryDelegate jComponentContextFactoryDelegate) {
        void delegate;
        if (this._MsetDelegateorg_ow2_jonas_naming_JComponentContextFactoryDelegate) {
            this._cm.entryCallback("setDelegateorg_ow2_jonas_naming_JComponentContextFactoryDelegate");
        }
        this._setdelegate((JComponentContextFactoryDelegate)delegate);
        Object var2_2 = null;
        if (this._MsetDelegateorg_ow2_jonas_naming_JComponentContextFactoryDelegate) {
            this._cm.exitCallback("setDelegateorg_ow2_jonas_naming_JComponentContextFactoryDelegate", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setStartRegistry(boolean bl) {
        void startRegistry;
        if (this._MsetStartRegistryboolean) {
            this._cm.entryCallback("setStartRegistryboolean");
        }
        this._setbStartRegistry((boolean)startRegistry);
        Object var2_2 = null;
        if (this._MsetStartRegistryboolean) {
            this._cm.exitCallback("setStartRegistryboolean", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setIgnoreError(boolean bl) {
        void ignoreError;
        if (this._MsetIgnoreErrorboolean) {
            this._cm.entryCallback("setIgnoreErrorboolean");
        }
        this._setbIgnoreError((boolean)ignoreError);
        Object var2_2 = null;
        if (this._MsetIgnoreErrorboolean) {
            this._cm.exitCallback("setIgnoreErrorboolean", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setConfigurationURL(URL uRL) {
        void configurationURL;
        if (this._MsetConfigurationURLjava_net_URL) {
            this._cm.entryCallback("setConfigurationURLjava_net_URL");
        }
        this._setconfigurationURL((URL)configurationURL);
        Object var2_2 = null;
        if (this._MsetConfigurationURLjava_net_URL) {
            this._cm.exitCallback("setConfigurationURLjava_net_URL", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setConfiguration(String string) throws MalformedURLException {
        void configurationURL;
        if (this._MsetConfigurationjava_lang_String) {
            this._cm.entryCallback("setConfigurationjava_lang_String");
        }
        this.setConfigurationURL(new URL((String)configurationURL));
        Object var2_2 = null;
        if (this._MsetConfigurationjava_lang_String) {
            this._cm.exitCallback("setConfigurationjava_lang_String", var2_2);
        }
    }

    public InitialContext getRegistryContext() {
        if (this._MgetRegistryContext) {
            this._cm.entryCallback("getRegistryContext");
        }
        if (this._getictx() == null) {
            IExecution<InitialContext> ie = new IExecution<InitialContext>(){

                public InitialContext execute() throws Exception {
                    return new InitialContext();
                }
            };
            ExecutionResult result = null;
            result = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)ie);
            if (result.hasException()) {
                logger.log(BasicLevel.ERROR, (Object)result.getException());
            }
            this._setictx((InitialContext)result.getResult());
        }
        InitialContext initialContext = this._getictx();
        if (this._MgetRegistryContext) {
            this._cm.exitCallback("getRegistryContext", (Object)initialContext);
        }
        return initialContext;
    }

    private String getMBeanServerId() throws ServiceException {
        String string;
        block6: {
            if (this._MgetMBeanServerId) {
                this._cm.entryCallback("getMBeanServerId");
            }
            if (!this.isOSGi()) {
                String string2 = null;
                if (this._MgetMBeanServerId) {
                    this._cm.exitCallback("getMBeanServerId", string2);
                }
                return string2;
            }
            try {
                ObjectName on = ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate");
                string = (String)this._getmbeanServer().getAttribute(on, "MBeanServerId");
                if (!this._MgetMBeanServerId) break block6;
            }
            catch (Exception e) {
                ServiceException serviceException = new ServiceException("MBeanServerId cannot be retrieved", (Throwable)e);
                if (this._MgetMBeanServerId) {
                    this._cm.exitCallback("getMBeanServerId", (Object)serviceException);
                }
                throw serviceException;
            }
            this._cm.exitCallback("getMBeanServerId", (Object)string);
        }
        return string;
    }

    private void _setComponentManager(InstanceManager instanceManager) {
        this._cm = instanceManager;
        Set set = this._cm.getRegistredFields();
        if (set != null) {
            if (set.contains("REMOTE")) {
                this._FREMOTE = true;
            }
            if (set.contains("bIgnoreError")) {
                this._FbIgnoreError = true;
            }
            if (set.contains("DEFAULT_MODE")) {
                this._FDEFAULT_MODE = true;
            }
            if (set.contains("CSIV2_PROPAGATION")) {
                this._FCSIV2_PROPAGATION = true;
            }
            if (set.contains("factory")) {
                this._Ffactory = true;
            }
            if (set.contains("delegate")) {
                this._Fdelegate = true;
            }
            if (set.contains("configurationURL")) {
                this._FconfigurationURL = true;
            }
            if (set.contains("COLLOCATED")) {
                this._FCOLLOCATED = true;
            }
            if (set.contains("ictx")) {
                this._Fictx = true;
            }
            if (set.contains("jrmpInterceptors")) {
                this._FjrmpInterceptors = true;
            }
            if (set.contains("bStartRegistry")) {
                this._FbStartRegistry = true;
            }
            if (set.contains("SEC_CHECK")) {
                this._FSEC_CHECK = true;
            }
            if (set.contains("mbeanServer")) {
                this._FmbeanServer = true;
            }
            if (set.contains("SECURITY_PROPAGATION")) {
                this._FSECURITY_PROPAGATION = true;
            }
            if (set.contains("logger")) {
                this._Flogger = true;
            }
            if (set.contains("TRANSACTION_PROPAGATION")) {
                this._FTRANSACTION_PROPAGATION = true;
            }
        }
        if ((set = this._cm.getRegistredMethods()) != null) {
            if (set.contains("$initorg_apache_felix_ipojo_InstanceManager")) {
                this._M$initorg_apache_felix_ipojo_InstanceManager = true;
            }
            if (set.contains("setModejava_lang_String")) {
                this._MsetModejava_lang_String = true;
            }
            if (set.contains("doStart")) {
                this._MdoStart = true;
            }
            if (set.contains("initInterceptors")) {
                this._MinitInterceptors = true;
            }
            if (set.contains("removeInterceptors")) {
                this._MremoveInterceptors = true;
            }
            if (set.contains("doStop")) {
                this._MdoStop = true;
            }
            if (set.contains("checkRequirements")) {
                this._McheckRequirements = true;
            }
            if (set.contains("getActiveProtocolNames")) {
                this._MgetActiveProtocolNames = true;
            }
            if (set.contains("getDefaultProtocolName")) {
                this._MgetDefaultProtocolName = true;
            }
            if (set.contains("getExportedObjectPortjava_lang_String")) {
                this._MgetExportedObjectPortjava_lang_String = true;
            }
            if (set.contains("getInitialContextFactoryNamejava_lang_String")) {
                this._MgetInitialContextFactoryNamejava_lang_String = true;
            }
            if (set.contains("getProviderURLjava_lang_String")) {
                this._MgetProviderURLjava_lang_String = true;
            }
            if (set.contains("setDefaultProtocoljava_lang_String")) {
                this._MsetDefaultProtocoljava_lang_String = true;
            }
            if (set.contains("getProtocolConfigurationjava_lang_String")) {
                this._MgetProtocolConfigurationjava_lang_String = true;
            }
            if (set.contains("setComponentContextFactoryorg_ow2_jonas_naming_JComponentContextFactory")) {
                this._MsetComponentContextFactoryorg_ow2_jonas_naming_JComponentContextFactory = true;
            }
            if (set.contains("setDelegateorg_ow2_jonas_naming_JComponentContextFactoryDelegate")) {
                this._MsetDelegateorg_ow2_jonas_naming_JComponentContextFactoryDelegate = true;
            }
            if (set.contains("setStartRegistryboolean")) {
                this._MsetStartRegistryboolean = true;
            }
            if (set.contains("setIgnoreErrorboolean")) {
                this._MsetIgnoreErrorboolean = true;
            }
            if (set.contains("setConfigurationURLjava_net_URL")) {
                this._MsetConfigurationURLjava_net_URL = true;
            }
            if (set.contains("setConfigurationjava_lang_String")) {
                this._MsetConfigurationjava_lang_String = true;
            }
            if (set.contains("getRegistryContext")) {
                this._MgetRegistryContext = true;
            }
            if (set.contains("getMBeanServerId")) {
                this._MgetMBeanServerId = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this._cm;
    }
}

