/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.service.instantiator;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.MissingHandlerException;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.UnacceptableConfiguration;
import org.apache.felix.ipojo.composite.service.instantiator.ServiceInstantiatorHandler;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.util.Tracker;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class SvcInstance
implements TrackerCustomizer {
    private String m_specification;
    private Dictionary m_configuration;
    private Map m_usedRef = new HashMap();
    private boolean m_isAggregate = false;
    private boolean m_isOptional = false;
    private ServiceInstantiatorHandler m_handler;
    private ServiceContext m_context;
    private boolean m_isValid = false;
    private Tracker m_tracker;

    public SvcInstance(ServiceInstantiatorHandler h, String spec, Dictionary conf, boolean isAgg, boolean isOpt, String filt) {
        this.m_handler = h;
        this.m_context = h.getCompositeManager().getServiceContext();
        this.m_specification = spec;
        this.m_configuration = conf;
        this.m_isAggregate = isAgg;
        this.m_isOptional = isOpt;
        try {
            this.m_tracker = new Tracker((BundleContext)this.m_context, h.getCompositeManager().getContext().createFilter(filt), (TrackerCustomizer)this);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    public void start() {
        this.m_tracker.open();
        this.m_isValid = this.isSatisfied();
    }

    public void stop() {
        this.m_tracker.close();
        Set keys = this.m_usedRef.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            ServiceReference ref = (ServiceReference)it.next();
            Object o = this.m_usedRef.get(ref);
            if (o == null) continue;
            ((ComponentInstance)o).dispose();
        }
        this.m_usedRef.clear();
        this.m_tracker = null;
        this.m_isValid = false;
    }

    private boolean isAnInstanceCreated() {
        Set keys = this.m_usedRef.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            if (this.m_usedRef.get(it.next()) == null) continue;
            return true;
        }
        return false;
    }

    private ComponentInstance createInstance(Factory factory) {
        Properties p = new Properties();
        Enumeration kk = this.m_configuration.keys();
        while (kk.hasMoreElements()) {
            String k = (String)kk.nextElement();
            p.put(k, this.m_configuration.get(k));
        }
        ComponentInstance instance = null;
        try {
            instance = factory.createComponentInstance(p);
        }
        catch (UnacceptableConfiguration e) {
            e.printStackTrace();
        }
        catch (MissingHandlerException e) {
            e.printStackTrace();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        return instance;
    }

    private void createNextInstance() {
        Set keys = this.m_usedRef.keySet();
        Iterator it = keys.iterator();
        ServiceReference ref = (ServiceReference)it.next();
        try {
            Factory factory = (Factory)this.m_context.getService(ref);
            Properties p = new Properties();
            Enumeration kk = this.m_configuration.keys();
            while (kk.hasMoreElements()) {
                String k = (String)kk.nextElement();
                p.put(k, this.m_configuration.get(k));
            }
            ComponentInstance instance = factory.createComponentInstance(p);
            this.m_usedRef.put(ref, instance);
            this.m_context.ungetService(ref);
        }
        catch (UnacceptableConfiguration e) {
            this.m_handler.log(1, "A matching factory (" + ref.getProperty("instance.name") + ") seems to refuse the given configuration : " + e.getMessage());
        }
        catch (MissingHandlerException e) {
            this.m_handler.log(1, "A matching factory (" + ref.getProperty("instance.name") + ") seems to refuse the given configuration : " + e.getMessage());
        }
        catch (ConfigurationException e) {
            this.m_handler.log(1, "A matching factory (" + ref.getProperty("instance.name") + ") seems to refuse the given configuration : " + e.getMessage());
        }
    }

    public boolean isSatisfied() {
        return this.m_isOptional || this.m_usedRef.size() > 0;
    }

    private boolean match(Factory fact) {
        Element[] provides = fact.getDescription().getElements("provides");
        for (int i = 0; i < provides.length; ++i) {
            if (!provides[i].getAttribute("specification").equals(this.m_specification)) continue;
            Enumeration e = this.m_configuration.keys();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                if (this.containsProperty(k, fact)) continue;
                return false;
            }
            Properties p = new Properties();
            Enumeration keys = this.m_configuration.keys();
            while (keys.hasMoreElements()) {
                String k = (String)keys.nextElement();
                p.put(k, this.m_configuration.get(k));
            }
            return fact.isAcceptable(p);
        }
        return false;
    }

    private boolean containsProperty(String name, Factory factory) {
        Element[] props = factory.getDescription().getElements("property");
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].getAttribute("name").equalsIgnoreCase(name)) continue;
            return true;
        }
        return name.equalsIgnoreCase("name");
    }

    public String getSpecification() {
        return this.m_specification;
    }

    public boolean isAggregate() {
        return this.m_isAggregate;
    }

    public boolean isOptional() {
        return this.m_isOptional;
    }

    protected Map getUsedReferences() {
        return this.m_usedRef;
    }

    public boolean addingService(ServiceReference reference) {
        Factory fact = (Factory)this.m_tracker.getService(reference);
        if (this.match(fact)) {
            this.m_tracker.ungetService(reference);
            return true;
        }
        this.m_tracker.ungetService(reference);
        return false;
    }

    public void addedService(ServiceReference reference) {
        Factory fact = (Factory)this.m_tracker.getService(reference);
        if (this.m_isAggregate) {
            this.m_usedRef.put(reference, this.createInstance(fact));
            if (!this.m_isValid) {
                this.m_isValid = true;
                this.m_handler.validate();
            }
        } else {
            if (!this.isAnInstanceCreated()) {
                this.m_usedRef.put(reference, this.createInstance(fact));
            } else {
                this.m_usedRef.put(reference, null);
            }
            if (!this.m_isValid) {
                this.m_isValid = true;
                this.m_handler.validate();
            }
        }
        this.m_tracker.ungetService(reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        Object o = this.m_usedRef.remove(reference);
        if (o != null) {
            ((ComponentInstance)o).dispose();
            if (this.m_usedRef.size() > 0) {
                if (!this.m_isAggregate) {
                    this.createNextInstance();
                }
            } else if (!this.m_isOptional) {
                this.m_isValid = false;
                this.m_handler.invalidate();
            }
        }
    }
}

