/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.archive;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.url.URLUtils;
import org.ow2.util.url.URLUtilsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryArchiveImpl
implements IArchive {
    private File directory = null;

    protected DirectoryArchiveImpl(File directory) {
        this.directory = directory;
    }

    public String getName() {
        return this.directory.getPath();
    }

    private String encode(String resourceName) {
        String[] tokens = resourceName.split("/");
        StringBuilder sb = new StringBuilder();
        for (String token : tokens) {
            if (sb.length() > 0) {
                sb.append(File.separator);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public boolean close() {
        return true;
    }

    public URL getResource(String resourceName) throws ArchiveException {
        URL resourceURL = null;
        File f = new File(this.directory, this.encode(resourceName));
        try {
            if (f.exists()) {
                resourceURL = URLUtils.fileToURL2((File)f);
            }
        }
        catch (URLUtilsException e) {
            throw new ArchiveException("Invalid url", (Throwable)e);
        }
        return resourceURL;
    }

    public Iterator<URL> getResources() throws ArchiveException {
        ArrayList<URL> listResources = new ArrayList<URL>();
        this.addFiles(this.directory, listResources);
        return listResources.iterator();
    }

    private void addFiles(File file, List<URL> listResources) {
        block5: {
            block4: {
                if (!file.exists()) {
                    return;
                }
                if (!file.isDirectory()) break block4;
                File[] files = file.listFiles();
                if (files == null) break block5;
                for (File f : files) {
                    this.addFiles(f, listResources);
                }
                break block5;
            }
            try {
                listResources.add(URLUtils.fileToURL2((File)file));
            }
            catch (URLUtilsException e) {
                throw new IllegalStateException("Invalid url", e);
            }
        }
    }

    public Iterator<URL> getResources(String resourceName) throws ArchiveException {
        ArrayList<URL> listResources = new ArrayList<URL>();
        File f = new File(this.directory, this.encode(resourceName));
        if (f.exists()) {
            try {
                listResources.add(URLUtils.fileToURL2((File)f));
            }
            catch (URLUtilsException e) {
                throw new ArchiveException("Invalid url", (Throwable)e);
            }
        }
        return listResources.iterator();
    }

    public URL getURL() throws ArchiveException {
        try {
            return URLUtils.fileToURL2((File)this.directory);
        }
        catch (URLUtilsException e) {
            throw new IllegalStateException("Invalid url", e);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DirectoryArchiveImpl)) {
            return false;
        }
        DirectoryArchiveImpl other = (DirectoryArchiveImpl)o;
        return this.directory.equals(other.directory);
    }

    public int hashCode() {
        return this.directory.hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

