/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.quartz;

import javax.ejb.Timer;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.api.EmbeddedManager;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.component.quartz.EasyBeansJobDetail;
import org.ow2.easybeans.component.quartz.EasyBeansJobDetailData;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EasyBeansJob
implements Job {
    public void execute(JobExecutionContext context) throws JobExecutionException {
        EasyBeansJobDetailData data = ((EasyBeansJobDetail)context.getJobDetail()).getJobDetailData();
        EZBServer server = EmbeddedManager.getEmbedded((Integer)data.getEasyBeansServerID());
        if (server == null) {
            throw new JobExecutionException("Cannot find the embedded server with the id '" + data.getEasyBeansServerID() + "'.");
        }
        EZBContainer container = server.getContainer(data.getContainerId());
        if (container == null) {
            throw new JobExecutionException("Cannot find the container with the id '" + data.getContainerId() + "'.");
        }
        Factory factory = container.getFactory(data.getFactoryName());
        if (factory == null) {
            throw new JobExecutionException("Cannot find the factory with the name '" + data.getFactoryName() + "'.");
        }
        Timer timer = data.getTimer();
        if (timer == null) {
            throw new JobExecutionException("No timer found in the given JobExecutionContext.");
        }
        factory.notifyTimeout(timer);
    }
}

