/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.commands.admin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.ow2.jonas.adm.AdmException;
import org.ow2.jonas.adm.AdmInterface;
import org.ow2.jonas.commands.admin.CLIArgument;

public class JonasAdmin {
    private static final String SERVERNAME = "JOnAS server ";
    private static String jonasName = null;
    private static AdmInterface admI = null;
    private static int state = -1;
    private static boolean reachable = false;
    private static boolean isNotEJB = false;
    private static boolean isError = false;
    private static final int DEFAULT_TIMEOUT = 100;
    private static final long WAIT_LOOP_MSEC = 500L;
    private static String[] target = null;
    public static final int ADDFILE = 101;
    public static final int REMOVEFILE = 102;
    public static final int LISTBEAN = 103;
    public static final int LISTJNDI = 104;
    public static final int LISTENV = 105;
    public static final int LISTTOPICS = 106;
    public static final int DEBUGOPTION = 107;
    public static final int TTOPTION = 108;
    public static final int SYNCOPTION = 109;
    public static final int CUSTOMOPTION = 110;
    public static final int PASSIVATEOPTION = 111;
    public static final int GCOPTION = 112;
    public static final int ISDEPLOYOPTION = 113;
    public static final int STARTOPTION = 114;
    public static final int STOPOPTION = 115;
    private static boolean qOption = false;

    private static void checkAdm() {
        String admName = jonasName + "_Adm";
        System.setProperty("carol.start.cmi", "false");
        try {
            InitialContext initialContext = new InitialContext();
            admI = (AdmInterface)PortableRemoteObject.narrow((Object)initialContext.lookup(admName), AdmInterface.class);
            state = admI.getServerState();
            boolean bl = reachable = state == 1;
            if (reachable) {
                isNotEJB = !admI.isEJBContainer();
            }
        }
        catch (Exception e) {
            reachable = false;
        }
    }

    private static int waitServer(int pingTimeout) {
        if (pingTimeout <= 0) {
            throw new IllegalArgumentException("Timeout should be a value greater than 0");
        }
        double loopValue = (double)pingTimeout / 0.5;
        int i = 0;
        while ((double)i < loopValue) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                return 1;
            }
            if (reachable) {
                return 0;
            }
            JonasAdmin.checkAdm();
            if (state == 2) {
                return 1;
            }
            ++i;
        }
        System.out.println(SERVERNAME + jonasName + " unreachable");
        return 1;
    }

    private static void addFile(String fileName) {
        block18: {
            if (!qOption) {
                System.out.println("Add File:");
            }
            if (!reachable) {
                System.err.println(SERVERNAME + jonasName + " unreachable");
                isError = true;
                return;
            }
            try {
                if (fileName.toLowerCase().endsWith(".jar") || fileName.toLowerCase().endsWith(".xml")) {
                    if (isNotEJB) {
                        System.err.println("This server doesn't implement an EJB Container");
                        isError = true;
                        return;
                    }
                    if (target == null) {
                        admI.addBeans(fileName);
                    } else {
                        admI.deployFileOn(fileName, target);
                    }
                    break block18;
                }
                if (fileName.toLowerCase().endsWith(".war")) {
                    if (target == null) {
                        admI.addWar(fileName);
                    } else {
                        admI.deployFileOn(fileName, target);
                    }
                    break block18;
                }
                if (fileName.toLowerCase().endsWith(".ear")) {
                    if (target == null) {
                        admI.addEar(fileName);
                    } else {
                        admI.deployFileOn(fileName, target);
                    }
                    break block18;
                }
                if (fileName.toLowerCase().endsWith(".rar")) {
                    if (target == null) {
                        admI.addRar(fileName);
                    } else {
                        admI.deployFileOn(fileName, target);
                    }
                    break block18;
                }
                System.err.println("Valid file extensions are : .jar, .xml, .war, .ear, .rar");
                return;
            }
            catch (AdmException e) {
                System.err.println("admI, addModule: " + (Object)((Object)e));
                isError = true;
                return;
            }
            catch (RemoteException e) {
                System.err.println("Cannot Deploy " + fileName + ": " + e.getCause().getMessage());
                return;
            }
        }
    }

    private static void removeFile(String fileName) {
        block10: {
            if (!qOption) {
                System.out.println("Remove File:");
            }
            if (!reachable) {
                System.err.println(SERVERNAME + jonasName + " unreachable");
                isError = true;
                return;
            }
            try {
                if (fileName.toLowerCase().endsWith(".jar") || fileName.toLowerCase().endsWith(".xml")) {
                    if (isNotEJB) {
                        System.err.println("no beans on TMServer");
                        isError = true;
                        return;
                    }
                    admI.removeBeans(fileName);
                    break block10;
                }
                if (fileName.toLowerCase().endsWith(".war")) {
                    admI.removeWar(fileName);
                    break block10;
                }
                if (fileName.toLowerCase().endsWith(".ear")) {
                    admI.removeEar(fileName);
                    break block10;
                }
                if (fileName.toLowerCase().endsWith(".rar")) {
                    admI.removeRar(fileName);
                    break block10;
                }
                System.err.println("Valid file extensions are : .jar, xml, .war, .ear, *.rar");
                return;
            }
            catch (AdmException e) {
                System.err.println("admI, removeModule: " + e.getMessage());
                isError = true;
                return;
            }
            catch (RemoteException e) {
                System.err.println("RemoteException : " + e.getMessage());
                isError = true;
                return;
            }
        }
        System.out.println("");
    }

    private static void isDeployedFile(String fileName) {
        if (!qOption) {
            System.out.println("Is File Deployable:");
        }
        if (!reachable) {
            System.err.println(SERVERNAME + jonasName + " unreachable");
            isError = true;
            return;
        }
        try {
            boolean isDeployed = false;
            if (fileName.toLowerCase().endsWith(".jar") || fileName.toLowerCase().endsWith(".xml")) {
                if (isNotEJB) {
                    System.err.println("no beans on TMServer");
                    isError = true;
                    return;
                }
                isDeployed = admI.isLoaded(fileName);
            } else if (fileName.toLowerCase().endsWith(".war")) {
                isDeployed = admI.isWarLoaded(fileName);
            } else if (fileName.toLowerCase().endsWith(".ear")) {
                isDeployed = admI.isEarLoaded(fileName);
            } else if (fileName.toLowerCase().endsWith(".rar")) {
                isDeployed = admI.isRarLoaded(fileName);
            } else {
                System.err.println("Valid file extensions are : .jar, xml, .war, .ear, .rar");
                return;
            }
            if (isDeployed) {
                System.out.println(fileName + " deployed in " + jonasName);
            } else {
                System.out.println(fileName + " NOT deployed in " + jonasName);
            }
        }
        catch (AdmException e) {
            System.err.println("admI, isModuleLoaded: " + e.getMessage());
            isError = true;
            return;
        }
        catch (RemoteException e) {
            System.err.println("RemoteException : " + e.getMessage());
            isError = true;
            return;
        }
        System.out.println("");
    }

    private static void custom() {
        if (!qOption) {
            System.out.println("Custom:");
        }
        if (isNotEJB) {
            System.err.println("no beans on TMServer");
            isError = true;
            return;
        }
        if (!reachable) {
            System.err.println(SERVERNAME + jonasName + " unreachable");
            isError = true;
            return;
        }
        try {
            System.out.println(admI.dumpCustom());
        }
        catch (RemoteException e) {
            System.err.println("admI.dumpCustom() : " + e);
            isError = true;
            return;
        }
        System.out.println("");
    }

    private static void listbeans() {
        if (!qOption) {
            System.out.println("ListBeans:");
        }
        if (isNotEJB) {
            System.err.println("no beans on TMServer");
            isError = true;
            return;
        }
        if (!reachable) {
            System.err.println(SERVERNAME + jonasName + " unreachable");
            isError = true;
            return;
        }
        try {
            String[] result = admI.listBeans();
            if (result.length == 0) {
                System.out.println("No bean in " + jonasName);
            }
            for (int i = 0; i < result.length; ++i) {
                System.out.println(result[i]);
            }
        }
        catch (RemoteException e) {
            System.err.println("admI.listBeans() : " + e);
            isError = true;
            return;
        }
        System.out.println("");
    }

    private static void listnames() {
        if (!qOption) {
            System.out.println("List JndiNames:");
        }
        if (!reachable) {
            System.err.println(SERVERNAME + jonasName + " unreachable");
            isError = true;
            return;
        }
        Vector result = new Vector();
        try {
            result = admI.listContext();
        }
        catch (RemoteException e) {
            System.err.println("admI.listContext() : " + e);
            isError = true;
            return;
        }
        if (result.size() == 0) {
            System.out.println("No name in JNDI context.");
        }
        for (int i = 0; i < result.size(); ++i) {
            System.out.println(result.elementAt(i));
        }
        System.out.println("");
    }

    private static void listproperties() {
        if (!qOption) {
            System.out.println("ListProperties:");
        }
        if (!reachable) {
            System.err.println(SERVERNAME + jonasName + " unreachable");
            isError = true;
            return;
        }
        Properties p = new Properties();
        try {
            p = admI.listEnv();
        }
        catch (RemoteException e) {
            System.err.println("admI.listEnv() : " + e);
            isError = true;
            return;
        }
        Enumeration<Object> e = p.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = p.get(key);
            System.out.println(key.toString() + "=" + value.toString());
        }
        System.out.println("");
    }

    private static void sync(boolean passivate) {
        if (!qOption) {
            System.out.println("Sync:");
        }
        if (isNotEJB) {
            System.err.println("no beans on TMServer");
            isError = true;
            return;
        }
        if (!reachable) {
            System.err.println(SERVERNAME + jonasName + " unreachable");
            isError = true;
            return;
        }
        try {
            admI.syncAllEntities(passivate);
        }
        catch (RemoteException e) {
            System.err.println("admI.syncAllEntities : " + e);
            isError = true;
            return;
        }
        System.out.println("");
    }

    private static void runGC() {
        if (!qOption) {
            System.out.println("Run GC:");
        }
        if (!reachable) {
            System.err.println(SERVERNAME + jonasName + " unreachable");
            isError = true;
            return;
        }
        try {
            admI.runGC();
        }
        catch (RemoteException e) {
            System.err.println("admI.runGC : " + e);
            isError = true;
            return;
        }
        System.out.println("");
    }

    private static void setTTimeout(String tstr) {
        if (!qOption) {
            System.out.println("Set TransactionTimeout:");
        }
        if (!reachable) {
            System.err.println(SERVERNAME + jonasName + " unreachable");
            isError = true;
            return;
        }
        Integer i = new Integer(tstr);
        try {
            admI.setTransactionTimeout(i.intValue());
        }
        catch (RemoteException e) {
            System.err.println("admI.setTransactionTimeout : " + e);
            isError = true;
            return;
        }
        System.out.println("");
    }

    private static void listTopics() {
        if (!qOption) {
            System.out.println("List Monolog Topics:");
        }
        if (!reachable) {
            System.err.println(SERVERNAME + jonasName + " unreachable");
            isError = true;
            return;
        }
        try {
            String[] result = admI.getTopics();
            if (result.length == 0) {
                System.out.println("No topics in " + jonasName);
            }
            for (int i = 0; i < result.length; ++i) {
                String level = admI.getTopicLevel(result[i]);
                System.out.println(level + "\t" + result[i]);
            }
        }
        catch (RemoteException e) {
            System.err.println("admI.getTopics : " + e);
            isError = true;
            return;
        }
        System.out.println("");
    }

    private static void setTopic(String t, String l) {
        if (!qOption) {
            System.out.println("Set Monolog Topic:");
        }
        try {
            admI.setTopicLevel(t, l.toUpperCase());
        }
        catch (RemoteException e) {
            System.err.println("admI.setTopics : " + e);
            isError = true;
            return;
        }
        System.out.println("");
    }

    private static void startserver() {
        if (!reachable) {
            System.err.println(SERVERNAME + jonasName + " unreachable");
            isError = true;
            return;
        }
        if (target == null) {
            System.out.println("ERROR: Current Server Already started");
            return;
        }
        try {
            admI.startRemoteServers(target);
        }
        catch (RemoteException e) {
            System.err.println("Error while starting servers:" + e.getCause().getMessage());
        }
    }

    private static void stopserver() {
        block6: {
            if (!reachable) {
                System.err.println(SERVERNAME + jonasName + " unreachable");
                isError = true;
                return;
            }
            try {
                if (target == null) {
                    admI.killServer();
                } else {
                    admI.stopRemoteServers(target);
                }
            }
            catch (RemoteException e) {
                if (target == null) break block6;
                System.err.println("Error while stopping servers:" + e.getCause().getMessage());
            }
        }
        if (target == null) {
            System.out.println(SERVERNAME + jonasName + " stopped");
        }
    }

    private static void help() {
        System.out.println("addbeans    adds beans in a new JOnAS container");
        System.out.println("addfile     adds beans/servlets/j2ee app/rars based upon the file extension");
        System.out.println("custom      dump jonas customization");
        System.out.println("env         JOnAS properties used by the server");
        System.out.println("gc          run the garbage collector");
        System.out.println("help        help");
        System.out.println("jndinames   lists registered JNDI names");
        System.out.println("listbeans   lists beans");
        System.out.println("name        to identify a current JOnAS server");
        System.out.println("quit        quit JonasAdmin");
        System.out.println("removebeans remove beans in a new JOnAS container");
        System.out.println("removefile  remove beans/servlets/j2ee app/rars (based upon the file extension)");
        System.out.println("start       stop target servers");
        System.out.println("stop        stop target servers");
        System.out.println("sync        synchronize all entities");
        System.out.println("passivate   passivate all entities");
        System.out.println("trace       get/set monolog topics");
        System.out.println("ttimeout    set default transaction timeout");
        System.out.println("target      set list of servers where command must be applied");
    }

    private static void usage() {
        System.out.println("usage : jonas admin <options>");
        System.out.println("if no option(except -n), mode is interactive.");
        System.out.println("list of available options:");
        System.out.println("    -n JonasName : to identify an JOnAS Server");
        System.out.println("    -s : stops the EJB server.");
        System.out.println("    -l : lists beans currently in the JOnAS Server.");
        System.out.println("    -j : lists registered JNDI names.");
        System.out.println("    -e : lists JOnAS properties currently used by the JOnAS Server.");
        System.out.println("    -a fileName : dynamically adds   : - beans from fileName in a new container");
        System.out.println("                                     : - servlets from a WAR file");
        System.out.println("                                     : - j2ee application from an EAR file");
        System.out.println("                                     : - resource adapter from a RAR file");
        System.out.println("    -r fileName : dynamically remove : - beans from container fileName");
        System.out.println("                                     : - servlets of a WAR file");
        System.out.println("                                     : - j2ee application of an EAR file");
        System.out.println("                                     : - resource adapter from a RAR file");
        System.out.println("    -isdeployed fileName : tells if the file is deployed or not");
        System.out.println("    -sync: synchronize all entities");
        System.out.println("    -passivate: passivate all entities");
        System.out.println("    -gc: run the garbage collector");
        System.out.println("    -tt timeout: set default transaction timeout");
        System.out.println("    -start: Start servers designed by '-target' arg");
        System.out.println("    -target target: set target for commands (default is local server)");
        System.out.println("    -ping [-timeout <val (sec)>]: ping server for a given time.(default=100s)");
        System.out.println("    -t list monolog topics");
        System.out.println("    --debug-level topic : set DEBUG for a monolog topic");
        System.out.println("    -q : quiet mode, no processing header information.");
        System.out.println("    -h : help message.");
        System.out.println("    -? : help message.");
    }

    public static void menu() throws IOException {
        if (!reachable) {
            System.out.println("You must first choose a jonas server. (command `name`)");
            System.out.println("Type `help` to get the list of available commands");
        }
        BufferedReader inbuf = new BufferedReader(new InputStreamReader(System.in));
        block0: while (true) {
            String fName;
            System.out.print("Admin (" + jonasName + ") > ");
            String command = inbuf.readLine();
            if (command.length() == 0) continue;
            if ("addbeans".startsWith(command) || "addfile".startsWith(command)) {
                fName = null;
                System.out.print("file name ? > ");
                fName = inbuf.readLine();
                if (fName.length() == 0) continue;
                JonasAdmin.addFile(fName);
                continue;
            }
            if ("start".startsWith(command)) {
                JonasAdmin.startserver();
                continue;
            }
            if ("env".startsWith(command)) {
                JonasAdmin.listproperties();
                continue;
            }
            if ("gc".startsWith(command)) {
                JonasAdmin.runGC();
                continue;
            }
            if ("help".startsWith(command) || command.equals("?")) {
                JonasAdmin.help();
                continue;
            }
            if ("jndinames".startsWith(command)) {
                JonasAdmin.listnames();
                continue;
            }
            if ("listbeans".startsWith(command)) {
                JonasAdmin.listbeans();
                continue;
            }
            if ("custom".startsWith(command)) {
                JonasAdmin.custom();
                continue;
            }
            if ("name".startsWith(command)) {
                System.out.print("Enter the JOnAS server 's name (jonas.name property) : ");
                jonasName = new String(inbuf.readLine());
                JonasAdmin.checkAdm();
                continue;
            }
            if ("quit".startsWith(command) || "exit".startsWith(command)) {
                return;
            }
            if ("removebeans".startsWith(command) || "removefile".startsWith(command)) {
                fName = null;
                System.out.print("file name ? > ");
                fName = inbuf.readLine();
                if (fName.length() == 0) continue;
                JonasAdmin.removeFile(fName);
                continue;
            }
            if ("trace".startsWith(command)) {
                while (true) {
                    JonasAdmin.listTopics();
                    System.out.print("topic name ? > ");
                    String tname = inbuf.readLine().trim();
                    if (tname.length() == 0) continue block0;
                    System.out.print("topic level ? (DEBUG | WARN | INFO | ERROR | INHERIT) > ");
                    String levstr = inbuf.readLine().trim();
                    JonasAdmin.setTopic(tname, levstr);
                }
            }
            if ("stop".startsWith(command)) {
                JonasAdmin.stopserver();
                continue;
            }
            if ("sync".startsWith(command)) {
                JonasAdmin.sync(false);
                continue;
            }
            if ("passivate".startsWith(command)) {
                JonasAdmin.sync(true);
                continue;
            }
            if ("ttimeout".startsWith(command)) {
                String tstr = null;
                System.out.print("transaction timeout in seconds ? > ");
                tstr = inbuf.readLine();
                if (tstr.length() == 0) continue;
                JonasAdmin.setTTimeout(tstr);
                continue;
            }
            if ("target".startsWith(command)) {
                System.out.print("Server or Cluster where to deploy the beans ? > ");
                target = JonasAdmin.makeArrayFrom(inbuf.readLine());
                continue;
            }
            System.out.println("Unknown command. Type help to get for the list of commands.");
        }
    }

    private static String[] makeArrayFrom(String line) {
        StringTokenizer stk = new StringTokenizer(line, ",");
        int nb = stk.countTokens();
        String[] ret = new String[nb];
        for (int i = 0; i < nb; ++i) {
            ret[i] = stk.nextToken();
        }
        return ret;
    }

    public static void main(String[] args) throws IOException {
        String fileName = null;
        String timeout = null;
        String topic = null;
        String pingTimeoutValue = null;
        boolean pingOption = false;
        boolean sOption = false;
        boolean interactive = true;
        boolean namedServer = false;
        Vector<CLIArgument> lstArgs = new Vector<CLIArgument>();
        for (int argn = 0; argn < args.length; ++argn) {
            CLIArgument ja;
            boolean nextArgument;
            String arg = args[argn];
            boolean bl = nextArgument = argn < args.length - 1;
            if (arg.equals("-a") && nextArgument) {
                fileName = args[++argn];
                ja = new CLIArgument(101, fileName);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-ping")) {
                pingOption = true;
                continue;
            }
            if (arg.equals("-custom")) {
                ja = new CLIArgument(110);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-e")) {
                ja = new CLIArgument(105);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-h") || arg.equals("-?")) {
                JonasAdmin.usage();
                System.exit(0);
            }
            if (arg.equals("-gc")) {
                ja = new CLIArgument(112);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-j")) {
                ja = new CLIArgument(104);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-l")) {
                ja = new CLIArgument(103);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-n") && nextArgument) {
                jonasName = args[++argn];
                namedServer = true;
                continue;
            }
            if (arg.equals("-timeout") && nextArgument) {
                pingTimeoutValue = args[++argn];
                continue;
            }
            if (arg.equals("-target") && nextArgument) {
                target = JonasAdmin.makeArrayFrom(args[++argn]);
                continue;
            }
            if (arg.equals("-r") && nextArgument) {
                fileName = args[++argn];
                ja = new CLIArgument(102, fileName);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-s")) {
                sOption = true;
                interactive = false;
                continue;
            }
            if (arg.equals("-stop")) {
                ja = new CLIArgument(115);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-start")) {
                ja = new CLIArgument(114);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-sync")) {
                ja = new CLIArgument(109);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-passivate")) {
                ja = new CLIArgument(111);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("--debug-level") && nextArgument) {
                topic = args[++argn];
                ja = new CLIArgument(107, topic);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-t")) {
                ja = new CLIArgument(106);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-tt") && nextArgument) {
                timeout = args[++argn];
                ja = new CLIArgument(108, timeout);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-isdeployed") && nextArgument) {
                fileName = args[++argn];
                ja = new CLIArgument(113, fileName);
                lstArgs.add(ja);
                interactive = false;
                continue;
            }
            if (arg.equals("-q")) {
                qOption = true;
                interactive = false;
                continue;
            }
            System.out.println("Bad option: " + arg);
            JonasAdmin.usage();
            System.exit(2);
        }
        if (!namedServer) {
            jonasName = "jonas";
        }
        if (pingOption) {
            int pingTimeout = 100;
            if (pingTimeoutValue != null) {
                try {
                    pingTimeout = Integer.parseInt(pingTimeoutValue);
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Incorrect timeout value for ping. Value is '" + pingTimeoutValue + "'.");
                }
            }
            System.exit(JonasAdmin.waitServer(pingTimeout));
        }
        JonasAdmin.checkAdm();
        if (sOption) {
            JonasAdmin.stopserver();
            if (isError) {
                System.exit(2);
            } else {
                return;
            }
        }
        if (interactive) {
            JonasAdmin.menu();
        } else {
            boolean first = true;
            boolean forQuiet = qOption;
            qOption = true;
            Enumeration e = lstArgs.elements();
            while (e.hasMoreElements()) {
                CLIArgument ai = (CLIArgument)e.nextElement();
                switch (ai.type) {
                    case 101: {
                        JonasAdmin.addFile(ai.value);
                        break;
                    }
                    case 102: {
                        JonasAdmin.removeFile(ai.value);
                        break;
                    }
                    case 114: {
                        JonasAdmin.startserver();
                        break;
                    }
                    case 115: {
                        JonasAdmin.stopserver();
                        break;
                    }
                    case 103: {
                        JonasAdmin.listbeans();
                        break;
                    }
                    case 104: {
                        JonasAdmin.listnames();
                        break;
                    }
                    case 105: {
                        JonasAdmin.listproperties();
                        break;
                    }
                    case 106: {
                        JonasAdmin.listTopics();
                        break;
                    }
                    case 107: {
                        JonasAdmin.setTopic(ai.value, "DEBUG");
                        break;
                    }
                    case 108: {
                        JonasAdmin.setTTimeout(ai.value);
                        break;
                    }
                    case 109: {
                        JonasAdmin.sync(false);
                        break;
                    }
                    case 110: {
                        JonasAdmin.custom();
                        break;
                    }
                    case 111: {
                        JonasAdmin.sync(true);
                        break;
                    }
                    case 112: {
                        JonasAdmin.runGC();
                        break;
                    }
                    case 113: {
                        JonasAdmin.isDeployedFile(ai.value);
                    }
                }
                if (first) {
                    first = false;
                    qOption = forQuiet;
                }
                if (!isError) continue;
                System.exit(2);
            }
        }
    }
}

