/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genclientstub.modifier;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Application;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.Client;
import org.ow2.jonas.generators.genbase.archive.EjbJar;
import org.ow2.jonas.generators.genbase.archive.FileArchive;
import org.ow2.jonas.generators.genbase.archive.JarArchive;
import org.ow2.jonas.generators.genbase.archive.WebApp;
import org.ow2.jonas.generators.genbase.modifier.AbsModifierFactory;
import org.ow2.jonas.generators.genbase.modifier.ArchiveModifier;
import org.ow2.jonas.generators.genclientstub.ClientStubGenException;
import org.ow2.jonas.generators.genclientstub.modifier.ApplicationModifier;
import org.ow2.jonas.generators.genclientstub.modifier.ClientModifier;
import org.ow2.jonas.generators.genclientstub.modifier.EjbJarModifier;
import org.ow2.jonas.generators.genclientstub.modifier.WebAppModifier;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.ee.deploy.api.deployable.CARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.impl.archive.ArchiveManager;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;

public class ModifierFactory
extends AbsModifierFactory {
    private static I18n i18n = I18n.getInstance(ModifierFactory.class);

    private ModifierFactory() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArchiveModifier getModifier(String filename) throws GenBaseException {
        void var3_8;
        int mode;
        IDeployable deployable;
        FileArchive archive = null;
        Application j2eeArchive = null;
        Object var3_3 = null;
        File file = new File(filename);
        if (!file.exists()) {
            String err = i18n.getMessage("ModifierFactory.getModifier.notfound", (Object)filename);
            throw new ClientStubGenException(err);
        }
        IArchive fileArchive = ArchiveManager.getInstance().getArchive((Object)file);
        if (file.isFile()) {
            try {
                JarFile jarfile = new JarFile(file);
            }
            catch (IOException ioe) {
                String err = i18n.getMessage("ModifierFactory.getModifier.notjar", (Object)filename);
                throw new ClientStubGenException(err);
            }
            archive = new JarArchive(file);
        } else {
            archive = new FileArchive(file);
        }
        try {
            deployable = DeployableHelper.getDeployable((IArchive)fileArchive);
        }
        catch (DeployableHelperException e) {
            throw new ClientStubGenException("Cannot get a deployable for the archive '" + archive + "'", (Exception)((Object)e));
        }
        if (deployable instanceof EARDeployable) {
            j2eeArchive = new Application((Archive)archive);
            mode = 0;
        } else if (deployable instanceof EJBDeployable) {
            j2eeArchive = new EjbJar((Archive)archive);
            mode = 1;
        } else if (deployable instanceof WARDeployable) {
            j2eeArchive = new WebApp((Archive)archive);
            mode = 2;
        } else {
            if (!(deployable instanceof CARDeployable)) {
                String err = i18n.getMessage("ModifierFactory.getModifier.unsupported", (Object)filename);
                throw new ClientStubGenException(err);
            }
            j2eeArchive = new Client((Archive)archive);
            mode = 3;
        }
        j2eeArchive.initialize();
        switch (mode) {
            case 0: {
                ApplicationModifier applicationModifier = new ApplicationModifier(j2eeArchive);
                return var3_8;
            }
            case 1: {
                EjbJarModifier ejbJarModifier = new EjbJarModifier((EjbJar)j2eeArchive);
                return var3_8;
            }
            case 2: {
                WebAppModifier webAppModifier = new WebAppModifier((WebApp)j2eeArchive);
                return var3_8;
            }
            case 3: {
                ClientModifier clientModifier = new ClientModifier((Client)j2eeArchive);
                return var3_8;
            }
        }
        return var3_8;
    }
}

